#!/bin/bash
# towi, 2004-11-14

if [ "a$1" = "a" ] ; then
    echo "$0 filelist-file > output-file"
    echo "Create a flat ASCII file (fasta-format) from a tree of c't-ROM files."
    echo "The first argument contains a list of file."
    echo "Each line in that file is treated as a filename, which content"
    echo "is read, translated to FASTA format and printed to stdout."
    exit
fi

echo Creating Plain Text file...
WC=`cat $1 | wc -l`
J=$WC
for i in `cat $1` ; do 
    if [ $(($J % 50)) -eq 0 ] ; then echo "   $J: $i..." > /dev/stderr ; fi
    # this is "fasta-format": a line with a ">" and the filename.
    echo "> $i" 
    #    then the text until the next ">".
    # translate to uppercase and eliminate control chars, etc.
    cat "$i" | tr '[a-z]<>\0 \177\200-\377\1-\11\13-\37' '[A-Z]{}$_[**]'
    # newline
    echo
    J=$(($J-1))
done
