#!/usr/bin/env python
'''
run it like this:

$ python ./run_deep_shallow_param_test.py > log.txt

$ gnuplot
set dgrid3d 17,10
set data style lines
splot "log.txt" using 1:2:3

'''

import os, sys

def runit(a=500, b=2000, file='t/T2', iters='10', algs=0x08):
    f = os.popen('./blocksort %(file)s %(iters)s %(algs)s %(a)s %(b)s' % locals())
    try:
        for line in f.readlines():
            if line.startswith("Deep-Shallow"):
                # line = "Deep-Shallow       .. .................    818 ms"
                time = int(line.split()[3])
                return time
    finally:
        f.close()
    

def main():
    # execute runs
    RUNS = 5
    print >>sys.stderr, "doing average over best-of-%s, removing top and bottom" % RUNS
    print "# log(a) log(b) avg(time w/o:min/max) min(time) max(time) a b "
    for a1 in reversed(range(10)):
        a = 100 + 100*(2**a1-1)
        print >>sys.stderr, "a=%s, b=[" % a,
        for b1 in range(17):
            b = 2**b1
            print >>sys.stderr, b,
            times = [ runit(a=a,b=b)  for i in range(RUNS) ]
            times.sort()
            # remove top and bottom
            times2 = times[1:-1]
            # average
            average = float(sum(times)) / len(times2)
            # output for gnuplot
            print "%7d %7d %7.2f %7.2f %7.2f %7d %7d" % (a1,b1,average,times[0],times[-1],a,b)
        print >>sys.stderr, "]"
    
                
main()
