/* $Id: radixsort.cpp 94 2004-12-15 10:27:17Z olau $ */

#include "../bwt.h"

/// Radix Sort -- McIlroy, Bostic and McIlroy 

#define SIZE 510
#define THRESHOLD 16
#define rswap(p, q, r)    (r) = (p), (p) = (q), (q) = (r)

typedef char *string;
typedef struct
{
   string *sa;
   int sn;
   int si;
} rstack_t;

void simplesort(string *a, int n, int b)    /* insertion sort */
{
   string *ak, *ai, s, t;

   for (ak = a+1; --n >= 1; ak++)
   {
      for (ai = ak; ai > a; ai--)
      {
         for (s = ai[0]+b, t = ai[-1]+b; *s; s++, t++)
            if (*s != *t)
               break;
         if (*s >= *t)
            break;
         rswap(ai[0], ai[-1], s);
      }
   }
}

#define push(a, n, i)   sp->sa = a, sp->sn = n, (sp++)->si = i
#define pop(a, n, i)    a = (--sp)->sa, n = sp->sn, i = sp->si
#define stackempty()    (sp <= stack)

void rsorta(string *a, int n, int b)
{   
   rstack_t stack[SIZE], stmp, *oldsp, *bigsp, *sp = stack;
   string *pile[256], *ak, *an, r, t;
   static int count[256], cmin, nc;
   int c, *cp;

   push(a, n, b);
   while (!stackempty())
   {
      pop(a, n, b);
      if(n < THRESHOLD)
      {   // divert
         simplesort(a, n, b);
         continue;
      }
      an = a + n;
      if(nc == 0) // nonrecursive?
      {            
         cmin = 255;        // tally
         for (ak = a; ak < an; )
         {
            c = (*ak++)[b];
            if (++count[c] == 1 && c)
            {
               if (c < cmin) cmin = c;
               nc++;
            }    }
         if (sp + nc > stack+SIZE) // stack overflow
         { 
            rsorta(a, n, b);
            continue;
         }    
      }
      oldsp = bigsp = sp, c = 2;    // logarithmic stack
      pile[0] = ak = a + count[0];    // find places
      for (cp = count+cmin; nc > 0; cp++, nc--)
      {
         while (*cp == 0) cp++;
         if (*cp > 1)
         {
            if (*cp > c)
            {
               c = *cp;
               bigsp = sp;
            }
            push(ak, *cp, b+1);
         }
         pile[cp-count] = ak += *cp;
      }
      rswap(*oldsp, *bigsp, stmp);

      for (ak = a; ak < an; ak += count[c], count[c] = 0)
      {
         r = *ak;
         while(--pile[c = r[b]] > ak)
            rswap(*pile[c], r, t);
         *ak = r;
      }        // here nc = count[...] = 0
   }
}


/* Aufruf der Radix-Sortierroutine */
void BWT_M_radix_sort(void)
{
   rsorta(M, Mlen, 0);
}
