/* $Id: blocksort.cpp 96 2004-12-15 10:50:06Z olau $ */

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/stat.h>
#include <locale.h>

#ifdef __GNUG__
#include <unistd.h>
#endif

#include "../bwt.h"
#include "../timer.h"
#include "../ds.h"
#include "mkqsort.h"
#include "radixsort.h"
#include "stl_sort.h"
#include "dumbqsort.h"

// static const char *projectname = "Blocksort-Test";
// static const char *projectversion = "$Id: blocksort.cpp 96 2004-12-15 10:50:06Z olau $";

char **M;
int Mlen = 0;


/* Die Eingabe T in (L, I) wandeln und zurckgeben
*/
void BWT_encode(char *T, BWT *bwt, void (sortfunction)(void))
{
   int i;
   char *T2;

   // den Ursprungsstring zweimal hintereinander kopieren
   T2 = (char *) malloc(2 * Mlen);
   memcpy(T2, T, Mlen);
   memcpy(T2 + Mlen, T, Mlen);

   // M[i] auf die Rotationen von T zeigen lassen
   M = (char **) malloc(Mlen * sizeof(char *));
   for (i = 0; i < Mlen; i++)
      M[i] = T2 + i;

   sortfunction();

   // L aus M extrahieren
   bwt->L = (char *) malloc(Mlen);
   for (i = 0; i < Mlen; i++)
      bwt->L[i] = M[i][Mlen-1];
   bwt->L[Mlen] = '\0';

   // den primren Index suchen
   i = -1;
   while (memcmp(M[++i], T, Mlen) != 0);
   bwt->I = i;

   free(M);
   free(T2);
}


/* Los geht's ...
*/
int main(int argc, char *argv[])
{
   BWT *bwt;
   struct stat fattr;
   TIMER stopwatch;
   int iterator;
   long cpu_time_used_quick = -1;
   long cpu_time_used_stl_quick = -1;
   long cpu_time_used_mk_quick = -1;
   long cpu_time_used_radix = -1;
   long cpu_time_used_ds = -1;

   if (stat(argv[1], &fattr) != 0)
   {
      perror("can't stat() file");
      return 1;
   }
   const int iterations = (argc > 2) ? atoi(argv[2]) : 1000;
   // bitmask to enable/disable some algorithms.
   //   0: all of, 1: first on, 2: second on, ... , 255: all on.
   const int algorithms = (argc > 3) ? atoi(argv[3]) : 0xff;
   printf("Lesen der Datei '%s' .. ", argv[1]);
   fflush(stdout);

   ds_overshoot = init_ds_ssort( (argc > 4) ? atoi(argv[4]) : 500, 
      (argc > 5) ? atoi(argv[5]) : 2000 
      );
   if (ds_overshoot <= 0)
   {
      fprintf(stderr, "fail overshoot. 'impossible' ds_ssort lib error.\n");
      exit(-1);
   }
   char *T = (char *) malloc(fattr.st_size + ds_overshoot);
   memset(T, '\0', fattr.st_size + ds_overshoot);
   FILE *fp = fopen(argv[1], "rb");
   Mlen = fread(T, sizeof(char), fattr.st_size, fp);
   fclose(fp);
   printf("%d Byte\n", Mlen);
   bwt = (BWT *) malloc(sizeof(BWT));


#define EXECUTE_ALGORITHM(nameX, timerX, executeX) { \
   if (algorithms & _alg) {  \
      START(nameX); \
      ITERATE {     \
         PROGRESS; \
         executeX; \
      }             \
      STOP(timerX); \
      printf("%11ld ms\n", timerX); \
   } \
   _alg <<= 1; \
}

   int _alg = 0x01; // will be shifted left for each alg

   EXECUTE_ALGORITHM("QuickSort         ", 
      cpu_time_used_quick,    
      BWT_encode(T, bwt, BWT_M_dumb_qsort) );

   EXECUTE_ALGORITHM("QuickSort (STL)   ", 
      cpu_time_used_stl_quick,    
      BWT_encode(T, bwt, BWT_M_STL_sort) );

   EXECUTE_ALGORITHM("Multikey-QuickSort", 
      cpu_time_used_mk_quick, 
      BWT_encode(T, bwt, BWT_M_mk_qsort) );

   EXECUTE_ALGORITHM("Radix-Sort        ", 
      cpu_time_used_radix, 
      BWT_encode(T, bwt, BWT_M_radix_sort) );

   EXECUTE_ALGORITHM("Deep-Shallow      ", 
      cpu_time_used_ds, 
      BWT_encode_DeepShallow(T, bwt); );

#ifdef _WAIT_FOR_KEYPRESS
   printf("\n\nZum Beenden Enter drcken .. ");
   fflush(stdout);
   getchar();
#endif
   printf("\n");
   return 0;
}
