/*
 * Created on 14.04.2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
/**
 * @author olz
 *
 * This class generates the graphical user interface for the communication with the XPort.
 * It also initializes and runs the other methods.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

/**
 * @author Oliver Zechiel (olz)
 *
 */
public class GUI extends Applet implements ActionListener {
	
	/** this value is just a placeholder to encode XPort specific values */
	private static final int StartCode = 0x41;
	
	/** this value is just a placeholder to encode XPort specific values */
	private static final int StopCode = 0x42;
	
	/** port 10001 is used to directly transmit data from RS232 to Ethernet */
	private static final int bridgePort = 10001;
	
	/** this variable will keep track if a connection to the XPort currently exists */
	private boolean isConnected = false;
	
	/** This variable will keep track if a connection to the XPort existed 
	 * before sending a command to the B-module. Its purpose is to check
	 * if the connection is to be  be ended after the command was sent. */ 
	private boolean wasConnected = false;
	
	/** instance of a Communication class object */
	private Communication XPort;
	
	/** this TextField serves to send messages to the XPort*/
	private TextField EingabeFeld;
	
	/** this TextField stores the IP address*/
	private TextArea IPAdresse;
	
	/** this TextField stores the port*/
	private TextField PortField;
	
	/** this TextArea will display information on the TCP/IP communication etc */
	private TextArea StatusFeld;
	
	/** this TextArea will show the answers sent by the XPort */
	private TextArea AusgabeFeld;
	
	/** clicking on this button initiates the connection setup to the XPort */
	private Button Connect;
	
	/** Clicking on this button will allow toggling the LEDs on / off */
	private Button toggleLEDButton;
	
	/** this button will terminate the connection to the XPort */
	private Button Disconnect;
	
	/** this instance will effectively control the XPort's network connections */
	private IOControl IOControl1;
	
	/** this thread will loop endlessly while connected,
	 * 	receiving data from the XPort */
	private OutputReadThread ReadThread;
	
	/** this textfield will display if the I/O pins are set to outgoing or incoming */
	private TextArea IODir;
	
	/** this button will re-read the XPort's I/O pins' status */
	private Button getIODir, setIODir, getFuncButton;
	
	/** this textfield will display the LED's status */
	private TextArea LEDStatus;
	
	/** this button will allow to read and set the I/O pins' settings and values */
	private Button getState;
	
	/** this panel will contain the GUI's elements for the B panel */
	private Panel BPanel;
	
	/** this panel will contain the GUI's elements for the A panel */
	private Panel Connection, LED, IO;
	
	/** this checkbox will allow toggling its respective LED on and off */
	private Checkbox checkLED1, checkLED2, checkLED3;
	
	/** this checkbox will allow setting ist respective I/O direction 
	 * to incoming / outgoing */
	private Checkbox IO1, IO2, IO3;
	
	/** this textfields is used to send commands to the B-Module */
	private TextField StartCodeField, Command, Data, StopCodeField;
	
	/** this button will toggle between the Applet's A panel (XPort control)
	 * and the B panel (B-Module control)
	 */
	private Button ChangeTab;
	
	/** this button will send a command to the B-Module as set up in the B panel */
	private Button sendCommand;
	
	/** this array of bytes will contain responses from the XPort */
	byte[] antwort={0,0,0,0,0};
	
	/** this method will allow to switch between the XPort's control panel
	 * and the B-module's control panel */
	private void changeTab() {	
		if (ChangeTab.getLabel() == "Switch to B-module control") {
			IO.setVisible(false);			// set A panel to invisible
			LED.setVisible(false);
			
			BPanel.setVisible(true);		// set B panel to visible
			ChangeTab.setLabel("Switch to XPort control");
			
			BPanel.doLayout();				// re-arrange the Applet's layout
			this.doLayout();
			
		}
		else {
			BPanel.setVisible(false);	// set B panel invisible
			
			LED.setVisible(true);		// set A panel visible
			IO.setVisible(true);
			ChangeTab.setLabel("Switch to B-module control");
			
			this.repaint();				// re-arrange the Applet's layout
			this.doLayout();
		}
	}
	
	/** This method will display all the GUI's elements on the Applet and
	 * preset them with a number of values. It does not perform any actions
	 * other than that.
	 * Since it's name is init() and we've got an Applet here, it's automatically
	 * run by the JRE.
	 */
	public void init() {
		
		Connection = new Panel(); // initialize the GUI's panels
		LED = new Panel();
		IO = new Panel();
		BPanel = new Panel();
		
		this.add(Connection);
		this.add(LED);
		this.add(IO);
		this.add(BPanel);
		
		BPanel.setVisible(false);	// since we start with the A panel, we hide
									// the B panel from the user
		
		IO.setLayout(new BorderLayout());
		
		StartCodeField = new TextField(2);
		StartCodeField.addActionListener(this);
		BPanel.add(StartCodeField);
		StartCodeField.setText(Integer.toString(StartCode));
		StartCodeField.setEditable(false);
		
		Command = new TextField(2);
		Command.addActionListener(this);
		BPanel.add(Command);
		Command.setText("30");
		
		Data = new TextField(15);
		Data.addActionListener(this);
		BPanel.add(Data);
		Data.setText("07");
		
		StopCodeField = new TextField(2);
		StopCodeField.addActionListener(this);
		BPanel.add(StopCodeField);
		StopCodeField.setText(Integer.toString(StopCode));
		StopCodeField.setEditable(false);
		
		sendCommand = new Button();
		sendCommand.setLabel("send command to B-module");
		sendCommand.addActionListener(this);
		BPanel.add(sendCommand);
		
		EingabeFeld = new TextField(15);
		EingabeFeld.addActionListener(this);
		Connection.add(EingabeFeld);
		
		IPAdresse = new TextArea("", 1, 20, 3);
		Connection.add(IPAdresse);
		
		PortField = new TextField(5);
		Connection.add(PortField);
		PortField.setText(Integer.toString(bridgePort));
		
		AusgabeFeld = new TextArea(10, 50);
		this.add("Center",AusgabeFeld);
		AusgabeFeld.setText("");
		AusgabeFeld.setEditable(false);
		
		Connect = new Button();
		Connect.setLabel("Connect to XPort");
		Connect.addActionListener(this);
		Connection.add(Connect);
		
		Disconnect = new Button();
		Disconnect.setLabel("Disconnect");
		Disconnect.addActionListener(this);
		Connection.add(Disconnect);
		
		StatusFeld = new TextArea(1, 30);
		this.add(StatusFeld);
		StatusFeld.setEditable(false);
		StatusFeld.setText("");
		StatusFeld.setForeground(Color.red);
		
		toggleLEDButton = new Button();
		toggleLEDButton.setLabel("Toggle LED");
		toggleLEDButton.addActionListener(this);
		LED.add(toggleLEDButton);
		
		getFuncButton = new Button();
		getFuncButton.setLabel("Get I/O functions");
		getFuncButton.addActionListener(this);
		IO.add("West", getFuncButton);
		
		setIODir = new Button();
		setIODir.setLabel("Toggle I/O directions");
		setIODir.addActionListener(this);
		IO.add("North",setIODir);
		
		getIODir = new Button();
		getIODir.setLabel("get I/O directions");
		getIODir.addActionListener(this);
		IO.add("East", getIODir);	
		
		LEDStatus = new TextArea("", 1, 15, 3);
		this.add("East",LEDStatus);
		LEDStatus.setEditable(false);
		
		IOControl1 = new IOControl();
		
		checkLED1 = new Checkbox("LED1", false);
		LED.add(checkLED1);
		
		checkLED2 = new Checkbox("LED2", false);
		LED.add(checkLED2);
		
		checkLED3 = new Checkbox("LED3", false);
		LED.add(checkLED3);
		
		getState = new Button();
		getState.setLabel("Get Current States");
		getState.addActionListener(this);
		IO.add("South", getState);
		
		IODir = new TextArea("", 4, 10, 3);
		IO.add("Center", IODir);
		IODir.setEditable(false);
		
		Connection.setLayout(new GridLayout(2,3));
		
		IO1 = new Checkbox("Set IO1 to output", false);
		this.add(IO1);
		
		IO2 = new Checkbox("Set IO2 to output", false);
		this.add(IO2);
		
		IO3 = new Checkbox("Set IO3 to output", false);
		this.add(IO3);
		
		ChangeTab = new Button();
		ChangeTab.setLabel("Switch to B-module control");
		ChangeTab.addActionListener(this);
		this.add(ChangeTab);
		
		this.setSize(450, 600);
		this.doLayout();
	}
	
	/** This method is responsible for some additional initialisations and
	 * presetting values. Basically, it could be integrated into init() without
	 * any major trouble. 
	 */
	public void start() {
		
		try { 	// intercept problems with wrong or invalid IP addresses and ports
				// that's why we're using a try statement here
				// this.getCodeBase() will return the Applet's IP, including "http://".
				// However, we only want the pure IP address, so we use substring() to
				// extract the numbers. 
			IPAdresse.setText(this.getCodeBase().toString().substring(7, this.getCodeBase().toString().length() - 1));
			append("Current IP = " + IPAdresse.getText());	// display ip address  
		}
		catch (NullPointerException NPEx) {
			System.err.println("NullPointerException occured");
			PortField.setText("0"); // default port for serial interface control
		}
		// create a new instance of a Communication object to allow control of
		// the XPort
		XPort = new Communication();
		StatusFeld.setText("Applet initialised, ready to connect...\n\r");
		StatusFeld.append("Applet build: 17.05.04 11:48");
		Disconnect.setEnabled(false);			// keep the user from using the
												// "Disconnect" button while
												// not connected
		ReadThread = new OutputReadThread();	// initialise a thread and start
												// waiting for data from the XPort
	}
	/** This method will just test if the value entered in the field PortField
	 * is a number or not.
	 * @return
	 */
	private boolean port_auswert() {
		try {
			Integer.parseInt(PortField.getText());
		}
		catch (NumberFormatException NFEx) {
			AusgabeFeld
			.append("Entered port has invalid format - please correct!\n\r");
			return false;
		}
		return true;
	}
	
	/** This method will establish a connection to the XPort via the entered
	 * IP address and port. Its second purpose is to enable and disable GUI elements
	 * which are needed respectively not needed while a connection is established. 
	 */
	private void connect() {
		StatusFeld.setText("Trying to connect...");
		if (!port_auswert()) {			// if no valid port is stated, stop immediately
			append("Invalid port!");
			StatusFeld.setText("Wrong port");
			return;
		}
		else		// well, let's see if the IP address is valid...
			// if it is, start a connection!
			try {
				int port = Integer.parseInt(PortField.getText());
				AusgabeFeld.setText("Connecting to " + IPAdresse.getText()
						+ " at port " + port + "\n\r");
				// call the "real" connection method
				XPort.connect(IPAdresse.getText(), port);
				
				Connect.setEnabled(false);		// allow user only to use button "Disconnect"
				Disconnect.setEnabled(true);
				IPAdresse.setEditable(false);
				PortField.setEditable(false);
				// display some status info
				append("Connection successfully established.");
				append("Setting up reading loop.");
				StatusFeld.setText("Connected to XPort.\r\nReading loop established.");
				
				wasConnected=true;
				isConnected=true;
				ReadThread.start();
				getIODir();
				
				return;
			}
		// If any error occurs, display it and stop connecting.
		catch (IOException IOEx) {
			StatusFeld.setText("I/O error during connecting!");
			append("I/O error while connecting: "+IOEx);
		}
		catch (Exception Ex) {
			StatusFeld.setText("General error during connecting!");
			append("Error while connecting: "+Ex);
		}
	}
	/** Will call LEDauswert() to check which LEDs are to be toggled and sends
	 * this value to the XPort.
	 */
	private void toggleLEDs() {
		LockButtons();
		try {
			antwort = IOControl1.toggle(IPAdresse.getText(),LEDauswert());
		}
		catch (IOException IOEx) {
        	append("I/O error while toggling LEDs: "+IOEx);
        }
        catch (Exception Ex) {
            append("Error while toggling LEDs: "+Ex);
        }
		LEDStatus.setText("LEDs\r\n");
		for (int i=0; i<antwort.length; i++) {
			LEDStatus.append(Byte.toString(antwort[i])+" ");
		}
		UnlockButtons();
	}
	/** Allows toggling the XPort's I/O directions between incoming and outgoing.
	 * This method itself only sends the checkboxes' values to the XPort's respective
	 * method, toggleDirection().
	 *
	 */
	private void setIODir() {
		LockButtons();
		try{
			antwort = IOControl1.toggleDirection(IPAdresse.getText(), IOauswert());
		}
		catch (IOException IOEx) {
        	append("I/O error while toggling I/O directions: "+IOEx);
        }
        catch (Exception Ex) {
            append("Error while toggling I/O directions: "+Ex);
        }
		LEDStatus.setText("Direction:\r\n");
		for (int i=0; i<antwort.length; i++) {
			LEDStatus.append(Byte.toString(antwort[i])+" ");
		}
		getIODir();
	}
	/** Will ask the XPort how many I/O pins it's got and display the value. 
	 * As of May 18th, 2004, it does not really evaluate the answer, only
	 * displays the numbers.*/
	private void getIOFunctions() {
		LockButtons();
		try {
			antwort = IOControl1.getFunc(IPAdresse.getText());	// 1 = LED 2
		}
		catch (IOException IOEx) {
        	append("I/O error while getting I/O functions: "+IOEx);
        }
        catch (Exception Ex) {
            append("Error while getting I/O functions: "+Ex);
        }
		LEDStatus.setText("Functions\r\n");
		for (int i=0; i<antwort.length; i++) {
			LEDStatus.append(Byte.toString(antwort[i])+" ");
		}
		UnlockButtons();
	}
	/** reads the XPort's I/O directions and displays them on an output field.
	 * There is no need to read more than bits 0 to 2 from byte 0 since the XPort does
	 * not have more than three I/O pins. 
	 *  */
	private void getIODir() {
		LockButtons();
		try{
			antwort = IOControl1.getDir(IPAdresse.getText());
		}
		catch (IOException IOEx) {
        	append("I/O error while getting I/O directions: "+IOEx);
        }
        catch (Exception Ex) {
            append("Error while getting I/O directions: "+Ex);
        }
		
		if ((antwort[1] & 1) != 0) {				// compare if bit 0 is set
			IODir.setText("I/O 1: output\r\n");
			checkLED1.setEnabled(true);
		}
		else {
			IODir.setText("I/O 1: input\r\n");
			checkLED1.setEnabled(false);
		}
		if ((antwort[1] & 2) != 0) {				// compare if bit1 is set
			IODir.append("I/O 2: output\r\n");
			checkLED2.setEnabled(true);
		}
		else {
			IODir.append("I/O 2: input\r\n");
			checkLED2.setEnabled(false);
		}
		if (( antwort[1] & 4) != 0) {				// compare if bit2 is set
			IODir.append("I/O 3: output\r\n");
			checkLED3.setEnabled(true);
		}
		else {
			IODir.append("I/O 3: input\r\n");
			checkLED3.setEnabled(false);
		}
		UnlockButtons();
	}
	
	/** reads the XPort's I/O pin's current state and displays them.
	 * As of May 18th, 2004, it does not really evaluate the answer, only
	 * displays the numbers.
	 */
	private void getState() {
		LockButtons();
		try {
			antwort = IOControl1.getCurrentState(IPAdresse.getText());
		}
		catch (IOException IOEx) {
        	append("I/O error while getting current states: "+IOEx);
        }
        catch (Exception Ex) {
            append("Error while getting current states: "+Ex);
        }
		LEDStatus.setText("Zustand:\r\n");
		for (int i=0; i<antwort.length; i++) {
			LEDStatus.append(Byte.toString(antwort[i])+" ");
		}
		UnlockButtons();
	}
	/** will end the connection to the XPort and re-enable the GUI elements faded out
	 * while the connection existed.
	 *
	 */
	private void disconnect() {
		append("Trying to disconnect...");
		StatusFeld.setText("Disconnecting");
		try {
			XPort.disconnect();			// end connection and stop reading thread.
			ReadThread.interrupt();
			ReadThread.stop();
			isConnected=false;			// update connection flags
			wasConnected=false;
		}
		catch (IOException IOEx) {
			StatusFeld.setText("I/O error while disconnecting");
			append("I/O error during disconnection: "+IOEx);
		}
		catch (Exception Ex) {
			StatusFeld.setText("General error while disconnecting");
			append("General error during disconnection: "+Ex);
		}
		
		Connect.setEnabled(true);		// re-activate GUI elements
		Disconnect.setEnabled(false);	// and re-allow user to change IP address 
		IPAdresse.setEditable(true);	// and port
		PortField.setEditable(true);
		
		append("Connection closed.");
		StatusFeld.setText("Disconnected.");
	}
	/** This method reads the input field after hitting enter 
	 * and sends its content to the XPort.
	 * The string read is also displayed on the output textfield, preceded by >>.
	 */
	private void sendText() {
		try {
			String sendString = EingabeFeld.getText();
			XPort.send(sendString);
			append("\n>> " + sendString);
		}
		catch (IOException IOEx) {
			StatusFeld.setText("I/O error while reading!");
			append("I/O error while reading: "+IOEx);
		}
		catch (Exception Ex) {
			StatusFeld.setText("General error while reading!");
			append("Error while reading: "+Ex);
		}
		EingabeFeld.setText("");
		EingabeFeld.requestFocus();
	}
	
	/** Overrides ActionListener's actionPerformed(). To keep this method halfway 
	 * simple and not too complex, it only calls other methods to do the actual work.
	 */ 
	public void actionPerformed(ActionEvent e) throws NullPointerException {        
		if (e.getActionCommand() == Connect.getLabel()) { // Buttion "Connect" was clicked
			connect();
			return;
		}
		if (e.getActionCommand() == ChangeTab.getLabel()) {	
			// switch from A panel to B panel and vice versa
			changeTab();
			return;
		}
		if (e.getActionCommand() == toggleLEDButton.getLabel()) {
			// user wants to toggle some LEDs
			toggleLEDs();
			return;
		}
		if (e.getActionCommand() == getFuncButton.getLabel()) {
			// user wants to know how many pins are available
			getIOFunctions();
			return;
		}
		if (e.getActionCommand() == setIODir.getLabel()) {
			// user wants to change I/O directions
			setIODir();
			return;
		}
		if (e.getActionCommand() == getIODir.getLabel()) {
			// user wants to get the I/O directions updated
			getIODir();
			return;
		}
		if (e.getActionCommand() == sendCommand.getLabel()){
			// user wants to send a command to the B-Module
			cmdBModule();
			return;
		}
		if (e.getActionCommand() == getState.getLabel()) {	
			// read out current states
			getState();
			return;
		}
		if (e.getActionCommand() == Disconnect.getLabel()) {
			// user wants to end the connection to the XPort
			disconnect();
			return;
		}
		if (e.getSource() == EingabeFeld) {
			// user wants to send some command to the XPort
			sendText();
		}
	}
	
	
	/** Will lock the GUI's buttons during execution of a command 
	 * to keep the user from doing stupid things.
	 */	
	
	private void LockButtons() {
		toggleLEDButton.setEnabled(false);
		getFuncButton.setEnabled(false);
		getIODir.setEnabled(false);
		getState.setEnabled(false);
		getIODir.setEnabled(false);
		setIODir.setEnabled(false);
		return;
	}
	
	/** After execution of a command, re-enables the GUI's buttons */
	private void UnlockButtons() {
		toggleLEDButton.setEnabled(true);
		getFuncButton.setEnabled(true);
		getIODir.setEnabled(true);
		getState.setEnabled(true);
		getIODir.setEnabled(true);
		setIODir.setEnabled(true);
		return;
	}
	
	/** Will determine which LEDs are to be set. Just a helper method for toggleLED(). */
	private byte LEDauswert() {
		byte activeLEDs = 0;
		if (checkLED1.getState()) {
			activeLEDs=1;
		}
		if (checkLED2.getState()) {
			activeLEDs += 2;
		}
		if (checkLED3.getState()) {
			activeLEDs+=4;
		}
		return activeLEDs;
	}
	
	/** Will determine which I/O directions are to be changed.
	 * Another helper method.
	 * @return
	 */
	private byte IOauswert() {
		byte activeLEDs = 0;
		if (IO1.getState()) {
			activeLEDs=1;
		}
		if (IO2.getState()) {
			activeLEDs += 2;
		}
		if (IO3.getState()) {
			activeLEDs+=4;
		}
		return activeLEDs;
	}
	/** will evaluate the B panel's GUI elements, create a command from them and
	 * send this command to the B-Module via the XPort's TCP/IP connection.
	 * An already existing connection to port 10001 is used if available.
	 * If not connected to port 10001 yet, this method will establish a connection to that
	 * port, send the command and close the conenction to 10001.   
	 *
	 */
	private void cmdBModule() {
		// These calls will convert the values typed into the B panel's textfields
		// into hex bytes and put them into an array of bytes.  
		
		byte command = (byte)Integer.parseInt(Command.getText(), 16);
		byte data = (byte)Integer.parseInt(Data.getText(), 16);
		
		byte[] fullCommand = {(byte)StartCode, command, data, (byte)StopCode};
		
		if(!isConnected & (Integer.parseInt(PortField.getText()) == bridgePort)) {	
			// only connect to bridging port if not yet connected because the
			// XPort only allows one connection to one port at a time
			connect();
			wasConnected=false;	// note that there was no connection to port 10001 
			// in the first place, so that we need to disconnect
			// after the command is sent.
		}
		try {	// send data
			XPort.send(fullCommand);
		}
		catch (IOException IOEx) {
			StatusFeld.setText("I/O error while reading!");
			append("I/O error while reading: "+IOEx);
		}
		catch (Exception Ex) {
			StatusFeld.setText("General error while reading!");
			append("Error while reading: "+Ex);
		}
		// check wasConnected if we need to close the connection to port 10001 and
		// disconnect if neccessary.
		if(wasConnected == false) {
			try {
				disconnect();
			}
			catch (Exception Ex) {
				append("Error while trying to disconnect: "+Ex);
			}
		}
	}
	
	/** Prints the current time, its parameter string and \r\n to the output textfield. */ 
	private void append(String output) {
		Date now = Calendar.getInstance().getTime();
		AusgabeFeld.append("["+now.getHours() +":"+ now.getMinutes()+":"+ now.getSeconds()+"] "+ output +"\r\n");
	}
	
	/** This Thread will loop while a connection to the XPort exists.
	 * It will wait for data to read and display it on the Applet's textfield.
	 * Numbers and ASCII chars will be displayed as such, whereas 
	 * non-readable ASCII chars will show up as bytes in a (0xbyte) form.
	 */
	private class OutputReadThread extends Thread {
		
		public void run() {
			while (!isInterrupted()) {	// run while needed
				boolean i = false;
				try {					// check if data is available
					i = XPort.DataReady();
				}
				catch (Exception Ex) {
					StatusFeld.setText("General error while reading!");
					append("Error while reading: "+Ex);
				}
				try {	// since we need to handle some possible exceptions,
					// we use a try-catch-statement instead of while.
					if (!i) {	// wait while no data
						
					} 
					else {		// receive data, display it and clear the input field
						String test = XPort.receiveString();
						append(test);
						EingabeFeld.setText("");
					}
				}
				catch (Exception Ex) {
					append("Error while reading data:  " + Ex);
				}
				
				try {	// wait half a second before re-entering loop
					sleep(500);
				}
				catch (InterruptedException IntEx) {
				}
			}
		}
	}
}