/*
 * OutlookNotiz.java
 *
 * geschrieben 2004 von
 * Thomas Knneth
 */

import java.awt.*;
import java.util.*;
import java.util.zip.*;

/*
 * Java Outlook Connector
 */
import ch.kova.connector.exception.*;
import ch.kova.connector.ms.outlook.*;
import ch.kova.connector.ms.outlook.folder.*;
import ch.kova.connector.ms.outlook.item.*;
import ch.kova.connector.ms.outlook.note.*;

public class OutlookNotiz implements TypeManager {
    
    private Vector notes, checksums;
    private CRC32 checksum;
    
    /*
     * Instantiierung durch die Methode loadTypeManagers der
     * Klasse TKPDManager
     */
    public OutlookNotiz() {
        notes = new Vector();
        checksums = new Vector();
        checksum = new CRC32();
        load();
    }
    
    /*
     * laden der Notizen und berechnen
     * der CRC32 Prfsummen
     */
    private void load() {
        Outlook outlookApplication = null;
        OutlookItem item;
        OutlookNote note;
        try {
            outlookApplication = new Outlook();
            OutlookFolder folder = outlookApplication.getDefaultFolder(FolderType.NOTES);
            ItemsCollection items = folder.getItems();
            for (ItemsIterator it = items.iterator(); it.hasNext();) {
                item = it.nextItem();
                if (item != null && item.getType().isNote()) {
                    note = (OutlookNote) item;
                    notes.addElement(note);
                    checksum.update(note.getBody().getBytes());
                    checksums.addElement(new Long(checksum.getValue()));
                }
            }
        }
        catch (ItemNotFoundException ex) {
            TKPDManager.showExceptionDialog(ex);
        }
        catch(ComponentObjectModelException ex) {
            TKPDManager.showExceptionDialog(ex);
        }
        catch(LibraryNotFoundException ex) {
            TKPDManager.showExceptionDialog(ex);
        }
    }
    
    /*
     * speichern aller Notizen; nicht ntig, da die Speicherung
     * ja von Outlook bernommen wird
     */
    
    /*
     * diese Methode vereinfacht den Zugriff
     * auf eine bestimmte Notiz
     */
    private OutlookNote getNote(int pos) {
        return (OutlookNote) notes.elementAt(pos);
    }
    
    /*
     * diese Methode gehrt zum TypeManager Interface
     */
    public boolean fileDeleted(Entry e) {
        int i, j;
        long checksum1, checksum2;
        checksum1 = Long.parseLong(e.getIntern());
        for (i = 0; i < checksums.size(); i++) {
            checksum2 = ((Long)checksums.elementAt(i)).longValue();
            if (checksum1 == checksum2) {
                OutlookNote note = getNote(i);
                checksums.removeElementAt(i);
                notes.removeElementAt(i);
                try {
                    note.delete();
                } catch (ComponentObjectModelException ex) {
                }
            }
        }
        return false;
    }
    
    /*
     * diese Methode gehrt zum TypeManager Interface; ihr wird ein
     * Vector bergeben, der alle Eintrge im repository
     * enthlt (soweit sie zu diesem Modul gehren);
     * hier wird der lokale Datenbestand auf neue Notizen hin
     * berprft; wenn ein Element des Vectors entries im
     * lokalen Bestand gefunden wird, wird es aus entries entfernt;
     * die aufrufende Methode kann so Lschungen implements lokalen
     * Bestand ermitteln und das repository aktualisieren
     */
    public Vector getNewEntries(TKPDManager manager, Vector entries) {
        Entry e;
        long checksum1, checksum2;
        boolean found;
        int i, j;
        for (i = 0; i < checksums.size(); i++) {
            found = false;
            checksum1 = ((Long)checksums.elementAt(i)).longValue();
            for (j = 0; j < entries.size(); j++) {
                e = (Entry) entries.elementAt(j);
                checksum2 = Long.parseLong(e.getIntern());
                if (checksum1 == checksum2) {
                    found = true;
                    entries.removeElement(e);
                    break;
                }
            }
            if (found == false) {
                String text = "";
                try {
                    text = getNote(i).getBody();
                } catch (ComponentObjectModelException ex) {
                    TKPDManager.showExceptionDialog(ex);
                }
                TKPDCanvas canvas = manager.createTKPDCanvas(5);
                canvas.setText(text);
                manager.addEntry(canvas, this, manager.createFilenameFromText(text), Long.toString(checksum1));
            }
        }
        return entries;
    }
}
