/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: uart.c 
 * Info: Routinen zur seriellen Kommunikation
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <io.h>
#include "uart.h"
#include "led.h"

char uart_dest_akt =DEST_XPORT; // Hier sichern wir den aktuellen Zustand
char uart_dest_old =DEST_XPORT; // Hier sichern wir den letzten Zustand

char uart_data_available(void){
	if (((UCSRA >> RXC) & 1) ==0) return 0;
	else return 1;
}

char uart_read(void){	// Achtung ist noch blockierend!!!!
	
	while (((UCSRA >> RXC) & 1) ==0){}	// Warten bis RXC-Bit in UCSRA gesetzt
	
	return UDR;	// Zeichen abholen
}

void uart_send(char data){ // Achtung ist noch blockierend!!!!
	LED_on(LED_ROT);

	while (((UCSRA >> UDRE) & 1) ==0){
		
	}	// warten bis UART sendebereit

	LED_off(LED_ROT);
	UDR= data;
}

void uart_dest(char dest){
	if (dest == DEST_OLD)	// Zurck zum letzten Zustand
		dest=uart_dest_old;
	
	switch (dest) {
		case DEST_XPORT: 
			PORTB &= 0xFC;				// PB0=0; PB1=0  ==> Z=Z0 Y=Y0 
			PORTB |= 0x04; 				// PB2=1 ==> (X=X1)	
			break;
		case DEST_COM: 
			PORTB |=  0x03;				// PB0=1; PB1=1  ==> Z=Z1 Y=Y1 
			PORTB &=  0xFB;				// PB2=0 ==> (X=X0) (eigentlich don't care)
			break;
		case DEST_PASSTHROUGH:	
			//PORTB |=  0x03;			//  
			PORTB 	&=  0xFC;			// PB0=1; PB1=1  ==> Z=Z0 Y=Y0 
			break;
	}
	uart_dest_old=uart_dest_akt;
	uart_dest_akt=dest;	// Zustand sichern
}
