/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: mcu.c 
 * Info: Demo-Hauptprogramm
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>

#include "display.h"
#include "led.h"
#include "key.h"
#include "delay.h"
#include "uart.h"
#include "adc.h"
#include "key.h"
#include "tools.h"
#include "timer.h"
#include "mcu.h"

#define CMD_LENGTH 64
#define CMD_STARTCODE 0x7f
#define CMD_STOPCODE 0x7e

#define DEST_XPORT 0
#define DEST_COM 1
#define DEST_PASSTHROUGH 2

#define COMMAND_LEDS	0x30
#define LAUFLICHT	0x31
#define SWITCH_DEST 	0x50
#define READKEY		0x60
#define READADC		0x70


char ticks;  //          123456789 123456789 123456789 123456789 123456789 
char TICKER_TEXT[TICKER_LENGTH] =" c't Projekt:   Mikroncontroller-im-LAN  c't Projekt:   Mikr";
char * ticker = TICKER_TEXT;
char command[CMD_LENGTH];		// Puffer fr Kommando von/an PC

//Der Mikrocontroller braucht ein paar Einstellungen, bevor wir loslegen knnen.
void init(void){
	DDRD|= LED_ALL;	// LED-Ports PD3-PD6 als Ausgang

	DDRB|= 0x07;  // Multiplexleitungen seriell PB0-2 als Ausgang
	
	PORTB|= 0x03; // UART verbinden mit COM
	
	UBRRH= 0x0;  // UART auf 9600 baud
	UBRRL= 0x5F; //  UBRR= (fquarz/ (16* BAUD) ) -1
	
	UCSRB= 0x18; // Transmitter und Receiver einschalten
	UCSRC=0x86; // 8 bit 1 Stop No Parity

	DDRA|=0x10; // Piepserport PA4 auf Ausgang

	TCCR1A=0x00; // Timer 1 auf Normalbetrieb
	
	TCCR1B=5; // Clksoure = Quarz / 1024
	
	TCNT1H=0 ;// Timer auf 0 setzen
	TCNT1L=0 ;
}

// Liest ein Kommando von der seriellen Schnittstelle
void read_command(void){
	int i=1;
	
	command[0]=0x00;

	while (command[0] != CMD_STARTCODE)	// Zeichen Lesen bis Startcode kommt
		command[0] = uart_read();
	
	while ((i < CMD_LENGTH) && command[i-1] != CMD_STOPCODE){	// Lesen bis Stopcode oder Puffer voll
		command[i++] = uart_read();
	}
}

//Wertet das Kommando im Puffer aus
void evaluate_command(void){
	int adc=0;
		// hier knnte man das Kommado verifizieren!

	command[3]=0x00;	// hat nur historische Grnde. spter mal aufrumen.
	switch (command[1]) {
		case COMMAND_LEDS:	// LED Steuerung
			switch_LED(command[2]);
			break;
		case SWITCH_DEST:
			uart_dest(command[2]);
			break;
		case LAUFLICHT:
			lauflicht(command[2]);
			break;
		case READKEY:
			command[2]=key_read(command[2]);
			break;
		case READADC:
			adc=read_adc(command[2]);
			command[2]= (char) (adc && 0xFF);
			command[3]= (char) ((adc >> 8) && 0xFF);
		default:
			break;
	}
	
	//Antwort vorbereiten:
	char answer[5] = { CMD_STARTCODE, command[1], command[2], command[3], CMD_STOPCODE};
	
	uart_dest(DEST_XPORT);	// Antwort geht immer an den XPORT
	for (int i=0; i< 5; i++) {
		uart_send(answer[i]);
	}
	uart_dest(DEST_OLD);	// Alte serielle Konfiguration wieder herstellen.
}


//Zeigt ein Kommando auf dem Display an
void display_command(void){
	char i=0;
	char hex[3];
	
	display_cursor(4,1);
	display_string("0x");
	to_hex(command[i],hex);
	display_string(hex);
	display_string(" ");
	i++;

	while ( (i<CMD_LENGTH) && (command[i] != CMD_STOPCODE)){
		to_hex(command[i],hex);
		display_string(hex);
		i++;
	}

	display_string(" ");
	to_hex(command[i],hex);
	display_string(hex);
}


//Liest einen Port-Pin aus. Wartet bis zu timeout und kehrt dann auch zurck 
//wenn keine nderung erfolgt ist.
char pin_read(char pin){
	char old_DDR= DDRC;	// Alte Einstellungen sichern
	char old_PORT= PORTC;
	
	char data;
	
	DDRC &= ~ (1<<pin);	// Pin as Input	
	PORTC |= (1<<pin);	// Pullup an.

	data = PINC;		//  Einlesen 
	data = (data>> pin) &1;	// und maskieren
		
	DDRC= old_DDR;		// wiederherstellen
	PORTC= old_PORT;
	
	return data;
}


//volatile static int ADC[8];

/* Liest alle Sensoren aus und legt die Ergebnisse in Variablen ab.
   Da der Aufruf aus einem Interrupt heraus erfolgt, sollte hier nichts rein, was lange dauert! 
*/
/*void read_sensors(void){
	char i;
	for (i=0; i<8; i++)		//Alle acht AD-Kanle lesen
		ADC[i]=read_adc(i);	

}
*/
int main (void){
	int adc=0x0000;
	char hex[10];
	
	init();
	LED_off(LED_ALL);
	
	display_init();
	
	timer_0_init();
	timer_1_init();
	dreh_init();
	
	for(;;){
		display_cursor(1,1);
		display_string(ticker);
		
		display_cursor(2,1);
		display_string("D=");
		if (drehgeber < 0)
			display_string("-0x");
		else
			display_string("+0x");
		to_hex((char)(abs(drehgeber)>>8),hex);
		display_string(hex);
		to_hex((char)(abs(drehgeber)&0xff),hex);
		display_string(hex);

		display_cursor(2,11);
		display_string("Tast=0x");
		to_hex(drehtaste,hex);
		display_string(hex);

		adc=read_adc(0);
		display_cursor(3,1);
		display_string("A0=0x");
		to_hex((char)(adc>>8),hex);
		display_string(hex);
		to_hex((char)(adc & 0xFF),hex);
		display_string(hex);

		adc=pt100_read(0);
		display_cursor(3,11);
		sprintf(hex,"=%3d,%d C",adc/100,adc%100);
		display_string(hex);

		adc=read_adc(1);
		switch_LED(adc>>6);
		display_cursor(4,1);
		display_string("A1=0x");
		to_hex((char)(adc>>8),hex);
		display_string(hex);
		to_hex((char)(adc & 0xFF),hex);
		display_string(hex);
		
		adc=read_adc(2);
		switch_LED(adc>>6);
		display_cursor(4,11);
		display_string("A2=0x");
		to_hex((char)(adc>>8),hex);
		display_string(hex);
		to_hex((char)(adc & 0xFF),hex);
		display_string(hex);

	}
	
	return 1;
}
