property loopMode : false

property myBlueMP3 : 0
property playImage : missing value
property stopImage : missing value
property pauseImage : missing value

property btnTitle : "Play"
property songsBeingPlayed : {}
property lastSelectedList : ""

on awake from nib theObject
	if name of theObject is "lists" then
		set theDataSource to make new data source at end of data sources with properties {name:"lists"}
		
		make new data column at end of data columns of theDataSource with properties {name:"name"}
		make new data column at end of data columns of theDataSource with properties {name:"duration"}
		make new data column at end of data columns of theDataSource with properties {name:"size"}
		
		tell application "iTunes"
			set {allNames, allDurations, allSizes} to {name, time, size} of every playlist
		end tell
		
		repeat with i from 1 to (count of allNames)
			set theDataRow to make new data row at end of data rows of theDataSource
			set contents of data cell "name" of theDataRow to item i of allNames
			set contents of data cell "duration" of theDataRow to item i of allDurations
			set contents of data cell "size" of theDataRow to item i of allSizes
		end repeat
		
		set data source of theObject to theDataSource
		set update views of theDataSource to true
	else if name of theObject is "songs" then
		set theDataSource to make new data source at end of data sources with properties {name:"songs"}
		
		make new data column at end of data columns of theDataSource with properties {name:"number", sort order:ascending, sort type:numerical, sort case sensitivity:case sensitive}
		make new data column at end of data columns of theDataSource with properties {name:"name", sort order:ascending, sort type:alphabetical, sort case sensitivity:case sensitive}
		make new data column at end of data columns of theDataSource with properties {name:"time", sort order:ascending, sort type:numerical, sort case sensitivity:case sensitive}
		make new data column at end of data columns of theDataSource with properties {name:"artist", sort order:ascending, sort type:alphabetical, sort case sensitivity:case sensitive}
		make new data column at end of data columns of theDataSource with properties {name:"album", sort order:ascending, sort type:alphabetical, sort case sensitivity:case sensitive}
		make new data column at end of data columns of theDataSource with properties {name:"file"}
		
		set sorted of theDataSource to true
		
		-- Set the "number" data column as the sort column
		set sort column of theDataSource to data column "number" of theDataSource
		
		set data source of theObject to theDataSource
	else if name of theObject is "main" then
		set playImage to (load image "Play")
		set stopImage to (load image "Stop")
		set pauseImage to (load image "Pause")
		
		--set ascImage to load image "NSAscendingSortIndicator"
		--set descImage to load image "NSDescendingSortIndicator"
		
		make new default entry at end of default entries of user defaults with properties {name:"lastBlueMP3", contents:""}
		make new default entry at end of default entries of user defaults with properties {name:"loopMode", contents:false}
		make new default entry at end of default entries of user defaults with properties {name:"volume", contents:30}
		call method "synchronize" of object user defaults
		
		set loopMode to (contents of default entry "loopMode" of user defaults) as integer
		set loopMode to loopMode as boolean
		set state of button "loop" of window "main" to loopMode
		set content of slider "volume" of window "main" to (contents of default entry "volume" of user defaults)
	end if
end awake from nib

on selection changed theObject
	if name of theObject is "lists" then
		set rows to selected data rows of theObject
		UpdateSongsFromPlaylist(theObject, rows)
		if rows = {} then
			set lastSelectedList to ""
		else
			set lastSelectedList to contents of data cell "name" of item 1 of rows
		end if
	end if
end selection changed

on column clicked theObject table column tableColumn
	set theDataSource to data source of theObject
	set theSortColumn to sort column of theDataSource
	set update views of theDataSource to false
	set theClickedColumn to identifier of tableColumn
	
	if (name of theSortColumn) is not equal to theClickedColumn then
		set the sort column of theDataSource to data column theClickedColumn of theDataSource
	else
		if sort order of theSortColumn is ascending then
			set sort order of theSortColumn to descending
		else
			set sort order of theSortColumn to ascending
		end if
	end if
	
	set theSortColumn to sort column of theDataSource
	if sort order of theSortColumn is ascending then
		--call method "setIndicatorImage:inTableColumn:" of object theObject with parameters {ascImage, tableColumn}
	else
		--call method "setIndicatorImage:inTableColumn:" of object theObject with parameters {descImage, tableColumn}
	end if
	
	call method "setHighlightedTableColumn:" of object theObject with parameter tableColumn
	
	set update views of theDataSource to true
end column clicked

on resized sub views theObject
	set b to bounds of scroll view "songs" of split view "split" of window "main"
	set y1 to item 2 of b
	set bounds of text field "listInfo" of window "main" to {item 1 of b, y1 - 28, item 3 of b, y1 - 15}
end resized sub views

on clicked theObject
	log btnTitle
	set whichOne to name of theObject
	set theWindow to window of theObject
	if whichOne is "play" then
		if btnTitle = "Stop" then
			log "btn stop"
			call method "stopPlaying" of object myBlueMP3
			set content of text field "songInfo" of window "main" to ""
			stop progress indicator "player" of window "main"
			setButtonStatus(button "play" of theWindow, playImage, "Play", (lastSelectedList  ""))
			set enabled of button "prev" of theWindow to false
			set enabled of button "next" of theWindow to false
			set songsBeingPlayed to {}
			
			--Thread Zeit geben zu sterben
			do shell script "/bin/sleep 1"
		else if btnTitle = "Pause" then
			log "btn pause"
			if isPlaying() = 1 then call method "pausePlaying" of object myBlueMP3
			setButtonStatus(theObject, playImage, "Play", true)
			stop progress indicator "player" of window "main"
		else if btnTitle = "Play" then
			log "btn play"
			if connectToBlueMP3() is not true then return
			
			if isPlaying() = 1 then
				log "btn play - 1"
				call method "pausePlaying" of object myBlueMP3
				setButtonStatus(theObject, pauseImage, "Pause", true)
				start progress indicator "player" of window "main"
			else
				log "btn play - 2"
				set songList to table view "songs" of scroll view "songs" of split view "split" of theWindow
				set rows to selected data rows of songList
				set songs to {}
				set songsBeingPlayed to {}
				
				if rows = {} then set rows to every data row of data source of songList
				
				repeat with oneRow in rows
					set songs to songs & contents of data cell "file" of oneRow
					set songsBeingPlayed to songsBeingPlayed & {{contents of data cell "artist" of oneRow, contents of data cell "name" of oneRow}}
				end repeat
				
				set res to (call method "startPlaying:" of object myBlueMP3 with parameter songs) as boolean
				if res then
					log "btn play - 3"
					setButtonStatus(theObject, pauseImage, "Pause", true)
					set enabled of button "prev" of theWindow to true
					set enabled of button "next" of theWindow to true
					updateSongInfo()
					start progress indicator "player" of window "main"
				else
					log "btn play - 4"
					set songsBeingPlayed to {}
				end if
			end if
		end if
	else if whichOne is "prev" then
		if isConnected() = 1 then call method "previousSong" of object myBlueMP3
		do shell script "/bin/sleep 1"
		updateSongInfo()
	else if whichOne is "next" then
		if isConnected() = 1 then call method "nextSong" of object myBlueMP3
		do shell script "/bin/sleep 1"
		updateSongInfo()
	else if whichOne is "loop" then
		call method "setLoopMode:" of object myBlueMP3 with parameter ((state of theObject) as integer)
		set contents of default entry "loopMode" of user defaults to (state of theObject)
		set loopMode to (state of theObject)
	else if whichOne is "options" then
		set lastBlueMP3 to (contents of default entry "lastBlueMP3" of user defaults)
		call method "selectBlueMP3" of object myBlueMP3
		set newBlueMP3 to (contents of default entry "lastBlueMP3" of user defaults)
		if newBlueMP3  lastBlueMP3 then
			--Neuer BlueMP3 ausgewhlt, aktuelles Object ist ungltig
			call method "stopPlaying" of object myBlueMP3
			set content of text field "songInfo" of window "main" to ""
			stop progress indicator "player" of window "main"
			call method "disconnectFromBlueMP3" of object myBlueMP3
			call method "release" of object myBlueMP3
			
			set BlueMP3 to call method "alloc" of class "BlueMP3Object"
			set sl to (content of (slider "volume" of theWindow) as integer)
			call method "initWithVolume:andLoopMode:" of object myBlueMP3 with parameters {(content of (slider "volume" of theWindow) as integer), loopMode}
		end if
	else if whichOne is "update" then
		
		UpdatePlaylists()
	end if
end clicked

on UpdatePlaylists()
	set theObject to table view "lists" of scroll view "lists" of split view "split" of window "main"
	
	start progress indicator "busy" of window of theObject
	
	set sel to selected data rows of theObject
	if sel = {} then
		set lastList to ""
	else
		set lastList to contents of data cell "name" of item 1 of sel
	end if
	
	set theDataSource to data source of theObject
	set update views of theDataSource to false
	
	delete every data row of theDataSource
	
	tell application "iTunes"
		set {allNames, allDurations, allSizes} to {name, time, size} of every playlist
	end tell
	
	set lastListExists to false
	
	repeat with i from 1 to (count of allNames)
		set theDataRow to make new data row at end of data rows of theDataSource
		set contents of data cell "name" of theDataRow to item i of allNames
		set contents of data cell "duration" of theDataRow to item i of allDurations
		set contents of data cell "size" of theDataRow to item i of allSizes
		
		if lastList = item i of allNames then
			set lastListExists to true
			set selRow to theDataRow
		end if
	end repeat
	
	set update views of theDataSource to true
	
	if lastListExists = true then
		set selected data row of theObject to selRow
		UpdateSongsFromPlaylist(theObject, selRow)
	else
		set theDataSource to data source of table view "songs" of scroll view "songs" of split view "split" of window "main"
		set update views of theDataSource to false
		delete every data row of theDataSource
		set update views of theDataSource to true
		
		set btn to button "play" of window of theObject
		if isPlaying() = 1 then
			setButtonStatus(btn, stopImage, "Stop", true)
		else
			setButtonStatus(btn, playImage, "Play", false)
		end if
	end if
	
	stop progress indicator "busy" of window of theObject
end UpdatePlaylists

on UpdateSongsFromPlaylist(theObject, theRows)
	set theWindow to window of theObject
	
	start progress indicator "busy" of theWindow
	set theDataSource to data source of table view "songs" of scroll view "songs" of split view "split" of theWindow
	set update views of theDataSource to false
	delete every data row of theDataSource
	
	set update views of theDataSource to true
	set update views of theDataSource to false
	set content of text field "listInfo" of theWindow to ""
	
	if theRows is not {} then
		set theRow to item 1 of theRows
		
		tell theWindow
			set lastList to contents of data cell "name" of theRow
			set listInfo to {contents of data cell "duration" of theRow, contents of data cell "size" of theRow}
		end tell
		
		set names to {}
		set k to "MPEG-Audiodatei"
		tell application "iTunes"
			-- try ist ntig, da eine Playlist ohne MP3s einen Fehler verursacht
			try
				set {names, timess, artistss, albumss, locations} to {name, time, artist, album, location} of (every file track of playlist lastList whose kind is k)
			end try
		end tell
		
		if names  {} then
			set enabled of button "play" of theWindow to true
			
			repeat with i from 1 to (count of names)
				set theDataRow to make new data row at end of data rows of theDataSource
				set contents of data cell 1 of theDataRow to i
				set contents of data cell 2 of theDataRow to item i of names
				set contents of data cell 3 of theDataRow to item i of timess
				set contents of data cell 4 of theDataRow to item i of artistss
				set contents of data cell 5 of theDataRow to item i of albumss
				set contents of data cell 6 of theDataRow to item i of locations
				
				--Zugriff ber Name ist langsamer als ber Index
				--set contents of data cell "number" of theDataRow to i
				--set contents of data cell "name" of theDataRow to item 1 of oneSong
				--set contents of data cell "time" of theDataRow to item 2 of oneSong
				--set contents of data cell "artist" of theDataRow to item 3 of oneSong
				--set contents of data cell "album" of theDataRow to item 4 of oneSong
				--set contents of data cell "file" of theDataRow to item 5 of oneSong
				--set i to i + 1
			end repeat
			
			set de to time of (current date)
			set s to (item 2 of listInfo) as real
			set s to s / 1024.0 / 1024.0 as real
			
			if s > 1024 then
				set s to s / 1024.0 as real
				set suff to " GByte"
			else
				set suff to " MByte"
			end if
			
			set s to round (s * 10)
			set s to s as text
			set l to count (s)
			set s to (text 1 thru (l - 1) of s) & "," & (last character of s)
			
			set t to |Playlistinfo| of (call method "localizedInfoDictionary" of object (main bundle))
			set content of text field "listInfo" of theWindow to (i as text) & t & (item 1 of listInfo as text) & ", " & (s as text) & suff
			
			if lastList  lastSelectedList then
				set btn to button "play" of theWindow
				if isPlaying() = 1 then
					setButtonStatus(btn, stopImage, "Stop", true)
				else
					setButtonStatus(btn, playImage, "Play", true)
				end if
			end if
			
			
		else
			set content of text field "listInfo" of theWindow to ""
			set btn to button "play" of theWindow
			if isPlaying() = 1 then
				setButtonStatus(btn, stopImage, "Stop", true)
			else
				setButtonStatus(btn, playImage, "Play", false)
			end if
		end if
	else
		set content of text field "listInfo" of theWindow to ""
		set btn to button "play" of theWindow
		if isPlaying() = 1 then
			setButtonStatus(btn, stopImage, "Stop", true)
		else
			setButtonStatus(btn, playImage, "Play", false)
		end if
	end if
	
	set update views of theDataSource to true
	stop progress indicator "busy" of theWindow
end UpdateSongsFromPlaylist

on action theObject
	if name of theObject is "volume" then
		if isConnected() = 1 then call method "setVolume:" of object myBlueMP3 with parameter (content of theObject as integer)
		set contents of default entry "volume" of user defaults to (content of theObject as integer)
	end if
end action

on will open theObject
	if name of theObject is "main" then
		if myBlueMP3 = 0 then
			set myBlueMP3 to call method "alloc" of class "BlueMP3Object"
			set loopMode to (contents of default entry "loopMode" of user defaults) as integer
			set loopMode to loopMode as boolean
			set tmpVolume to (contents of default entry "volume" of user defaults) as integer
			call method "initWithVolume:andLoopMode:" of object myBlueMP3 with parameters {tmpVolume, loopMode}
			call method "setAppleScriptCallback:inScript:" of object myBlueMP3 with parameters {"callback", "BlueMP3"}
		end if
	end if
end will open

on double clicked theObject
	if name of theObject = "songs" then
		if connectToBlueMP3() is not true then return
		
		if isPlaying() = 1 then
			call method "stopPlaying" of object myBlueMP3
			set content of text field "songInfo" of window "main" to ""
			stop progress indicator "player" of window "main"
			
			--Thread Zeit geben zu sterben
			do shell script "/bin/sleep 1"
		end if
		
		set songList to table view "songs" of scroll view "songs" of split view "split" of window "main"
		set rows to selected data rows of songList
		set songs to {}
		set songsBeingPlayed to {}
		
		repeat with oneRow in rows
			set songs to songs & contents of data cell "file" of oneRow
			set songsBeingPlayed to songsBeingPlayed & {{contents of data cell "artist" of oneRow, contents of data cell "name" of oneRow}}
		end repeat
		
		set res to (call method "startPlaying:" of object myBlueMP3 with parameter songs) as boolean
		if res then
			start progress indicator "player" of window "main"
			setButtonStatus(button "play" of window "main", pauseImage, "Pause", true)
			set enabled of button "prev" of window of theObject to false
			set enabled of button "next" of window of theObject to false
			updateSongInfo()
		else
			set songsBeingPlayed to {}
		end if
	end if
end double clicked

on will become active theObject
	set state of button "loop" of window "main" to loopMode
end will become active

on will quit theObject
	if isConnected() = 1 then
		--log "y8"
		call method "stopPlaying" of object myBlueMP3
		set content of text field "songInfo" of window "main" to ""
		call method "disconnectFromBlueMP3" of object myBlueMP3
		call method "release" of object myBlueMP3
		set myBlueMP3 to 0
	end if
end will quit

on idle theObject
	if isPlaying() is 1 then
		updateSongInfo()
		return 3
	else
		set theWindow to window "main"
		set content of text field "songInfo" of theWindow to ""
		stop progress indicator "player" of theWindow
		setButtonStatus(button "play" of theWindow, playImage, "Play", (lastSelectedList  ""))
		set enabled of button "prev" of theWindow to false
		set enabled of button "next" of theWindow to false
		set songsBeingPlayed to {}
		return 15
	end if
end idle

on should quit after last window closed theObject
	return true
end should quit after last window closed

on updateSongInfo()
	set i to (call method "songBeingPlayedByIndex" of object myBlueMP3)
	if i  1 and i  (count of songsBeingPlayed) then
		set info to item i of songsBeingPlayed
		set content of text field "songInfo" of window "main" to (item 1 of info) & (ASCII character 13) & (item 2 of info)
	end if
end updateSongInfo

on isConnected()
	if myBlueMP3  0 then
		return (call method "isConnected" of object myBlueMP3)
	else
		return false
	end if
end isConnected

on isPlaying()
	if isConnected() is 1 then
		return (call method "isPlaying" of object myBlueMP3)
	else
		return false
	end if
end isPlaying

on connectToBlueMP3()
	if isConnected() = 0 then
		repeat while (((call method "connectToBlueMP3" of object myBlueMP3) as boolean) is not true)
			set b to (display dialog "Eine Verbindung mit dem BlueMP3 konnte nicht hergestellt werden." buttons {"Nochmal", "OK"} default button 1 giving up after 60)
			if button returned of b = "OK" then return false
		end repeat
		return true
	else
		return true
	end if
end connectToBlueMP3

on setButtonStatus(btn, img, tit, deact)
	if img  0 then
		set image of btn to img
	end if
	set btnTitle to tit
	set enabled of btn to deact
end setButtonStatus

on callback(msg, param)
	if msg = "volumeChanged" then
		set content of slider "volume" of window "main" to (param as integer)
		set contents of default entry "volume" of user defaults to (param as integer)
	else if msg = "batteryIsLow" then
		display dialog "Der BlueMP3 meldet eine niedrige Batteriespannung. Bitte erneuern Sie die Stromzellen." buttons {"OK"} default button 1 giving up after 60
	end if
	return true
end callback