// Einfachst-Komponente zur Demonstration der Verpackung von
// .NET-Komponenten als COM. Zwei privaten Datenfelder
// (int und string), Methoden zum Setzen, Eigenschaften zum Abruf


using System;
using System.Runtime.InteropServices; // Guid
using System.Diagnostics;   // Process.GetCurrentProcess

namespace CSServerLib
{
	[ClassInterface(ClassInterfaceType.AutoDual)]
 	[Guid("D926D7A1-D2CC-46cf-8D2A-56201C6DE423")]
	public class CSServer
	{
		private int m_IntVal;
		private string m_StrVal;

		public CSServer()
		{
		}

		public void NoParam()
		{
		}

		public void IntParam(int value)
		{
			 m_IntVal = value;
		}

		public void StrParam(string value)
		{
			 m_StrVal = value;
		}

		public int IntVal
		{
			get 
			{
					return m_IntVal; 
			}
		}

		public string StrVal
		{
			get 
			{
				return m_StrVal; 
			}
		}

		public int ProcessID
		{
			get
			{
				return Process.GetCurrentProcess().Id;
			}
		}

	}
}
