/*****************************************************************

getwww : Benchmark Tool to hit web servers

         Forks n clients and
         does HTTP-GET requests and counts reuqests/s

Version: 1.4, 22.6.04
         

Author: originally by Gert Doering
        heavily modified by Juergen Schmidt (ju@ct.heise.de)
	(so blame any errors on me, ju)
	and again patched by Benjamin Benz (bbe@heise.de) to support deflate

License: GPL
         If you publish any numbers based on this program, 
         please send me a note. Please mention my employer
	 "c't magazin, http://www.heise.de/ct", as source of 
         this program.

Disclaimer:

   Use at your own risk.
   The author takes no responsibility that this programm compiles, runs
   or does anything useful. No repsonibiltity for eventual harm to 
   your system is taken either.

   I'm not able to guarantee any support or bug fixes. 
   I will do my best though :-)

Changes: 

1.4
- added deflate Stuff to enable compression of HTTP-data (-P)

1.3

- added SSL stuff (-S) (works with keep-alive)
- added Transfer-Encoding: chunked
- redesign of get_one_page: 
  - systematic Header-Check
  - no recursion any more but calls do_read again if necesarry
- removed some exotic unused features like "optimistic read"
TODO:
- add "#ifdef SSL" so that it is possible to compile w.o. (open)ssl
- document cipher, key-length --- done, use -d 
- select cipher
- rename to getwww 

1.2: 

- added -H HTTP status check
- added -F to read URLs from file

1.1:

- support for a master process to sync processes from different hosts (-s)
- support for HTTP Keep-Alive (-k)

----Compile:

cc -O3 getwww.c -o getwww

tested on Linux 2.0, 2.2, 2.3.X, 2.4.0test1

Used to compile under AIX, Solaris (not recently tested).


----Run:

./getwww [options] server n_proc

example:

./getwww -u /html4k.html -r 60 192.168.99.100 64 > client1.p64

starts 64 processes that run for 60 seconds

To anyalyze the result use

./log2dat client1.p64

------TODO:

- comment the code
- clean the code
- various quirks, grep for FIXME
- port to winsock ???


******************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/mman.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <malloc.h>
#include <fcntl.h>
#include <time.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/tcp.h>

#define TRUE 1
#define FALSE 0


/* HTTP elements */
#define HTTP_RET "HTTP/1.1 "
#define HTTP_OK 200
#define DOCLEN "Content-Length: "
#define CHUNKED "Transfer-Encoding: chunked"

#define HEADEREND "\r\n\r\n"
#define CHUNK_END "\r\n0\r\n"


#define ITOA(x) ('0'+(x))   /* FIXME: dirty hack, converts integers [0-9]  */
                            /* to char ['0'..'9'], use as: ITOA(int)       */ 


#define TV_2_LONG(tv) ((tv).tv_sec*1E6 + (tv).tv_usec)

#define GET_TIME(x) do {   struct timeval __tv;                         \
                        gettimeofday(&__tv,NULL);                       \
                        (x) = TV_2_LONG(__tv); } while (0)


/* global vars - FIXME: check which really need to be global */

char readbuf[64000];         /* buffer to get HTTP results */

char	gettext[] = \
  "GET %s HTTP/1.1\r\nHost: hell\r\nConnection: close\r\n\r\n";
char	gettext_ka[] = \
  "GET %s HTTP/1.1\r\nHost: hell\r\nConnection: Keep-Alive\r\n\r\n";

char	gettext_def[] = \
  "GET %s HTTP/1.1\r\nHost: hell\r\nConnection: close\r\nAccept-Encoding: gzip, deflate\r\n\r\n";
char	gettext_ka_def[] = \
  "GET %s HTTP/1.1\r\nHost: hell\r\nConnection: Keep-Alive\r\nAccept-Encoding: gzip, deflate\r\n\r\n";


char	getme[1024];

int	port = 80;	     /* http changed via -p */
struct	sockaddr_in s_in;

char	verbose=FALSE, debug=FALSE, param_f=FALSE; 
char    param_F=FALSE, ign_size=FALSE, http_check=FALSE;

int     keepalive = FALSE;
int     deflate = FALSE;	/* Allow compression of HTTP-data-stream */

int rlevel = -1;
int db_tnum = 0;
int db_num = 10;
char dbget[1024];

static int sock = -1;

char **urls;
int nr_urls = 0;

int use_sync = FALSE;
int sync_port = 7777;

static const int getwww_magic = 0xdeadbeef;



int do_read(char *buf, int num, int *close) {
  int r;
  int flag = 0x00;

  if ( debug ) printf( "trying to read %4d\n", num);
  r = recv(sock, buf, num, flag);
  return(r);
}


int get_one_page (int total_read)
     /* 
	send one HTTP GET reuqest and reads the server response
	uses global struct s_in for target adress
	sends global string getme
	Return: number of bytes read or -1 if an error occurs
	        if http_check returns HTTP status instead
     */
{
int t_read, r, http_status=0;
static int close_this = TRUE;
static int chunked = FALSE;
char *tmp0=NULL;
int doclen=0;
int headlen;

/* Open socket if necessary */ 
    if (!keepalive || (sock == -1)) {
      int one = 0;

      if ( debug ) printf( "socket...\n" );
      sock = socket (AF_INET, SOCK_STREAM, 0);

      if (sock < 0)
      {
        if (verbose) perror( "socket() failed" );
        return -1;
      }

      if ( debug ) printf( "connect... (port %d)\n", s_in.sin_port );

      /* &s_in needs explicit cast, donno why */
      if (connect (sock, (struct sockaddr *) &s_in, sizeof (s_in)) < 0)
      { 
        if (verbose) perror( "connect() failed" );
        return -1;
      }
      setsockopt(sock, IPPROTO_TCP, TCP_NODELAY,(char *)&one,sizeof(one));
    }


    if ( write( sock, getme, strlen(getme) ) != strlen(getme) ) {
      if (verbose) perror( "write() failed" );
      close(sock);
      sock = -1;
      return -1;
    }

    if (debug) printf ("Wrote: %s\n", getme);

    /* do read and look what we've got */
    r = do_read(readbuf, sizeof(readbuf), &close_this);
    t_read = r;    

    // FIXME: do proper check 
    if (r <= 0) {
      t_read=-1;
      goto finish;
    }

    if ( r == sizeof(readbuf) ) {
      printf("Buffersize %d too small\n", sizeof(readbuf));
      exit (-1);
    }

    if ( debug ) 
      printf( "read %4d Bytes\n%.*s\n", r, (r>700)?700:r, readbuf );

    readbuf[t_read] = 0;  // insert end of string 
       
    /*-- Inspect Headers --*/
    /* HTTP Return Code */
    tmp0 = strstr(readbuf, HTTP_RET);
    if (!tmp0) {
      if ( debug ) printf( "No HTTP return code\n" );
      t_read = -1;
      goto finish;
    }

    tmp0 += strlen(HTTP_RET); 
    sscanf(tmp0, "%d", &http_status);
    if (verbose) fprintf (stderr, "HTTP status: %d\n", http_status);

    /* Document Length, optional */
    tmp0 = strstr(readbuf, DOCLEN);
    if ( tmp0 ) {
      tmp0 += strlen(DOCLEN); 
      sscanf(tmp0, "%d", &doclen);
      if ( doclen <= 0 ) {
	printf("Messed up DOCLEN Header!\n");
	t_read = -1;
	goto finish;
      }
    }
    
    /* Transfer Encoding */
    if ( strstr(readbuf, CHUNKED) ) {
      chunked = TRUE;
    }

    /* Keepalive requires either Transfer-encoding: chunked */
    /* or Document-Length specified                         */
    if ( keepalive ) {
      if ( !chunked && (doclen <= 0) ) {
	 printf("Keep-Alive but neither chunked nor document length\n");
	 t_read = -1;
	 goto finish;
      }
    }


    if (strstr(readbuf, "Connection: close")) {
      if (debug) printf("Conection close requested\n");
      close_this = TRUE;
    } else {
      if (keepalive && strstr(readbuf, "Connection: Keep-Alive") ) {
	if (debug) printf("Conection Keep-Alive\n");
	close_this = FALSE;
      }
    }

    tmp0 = strstr(readbuf, HEADEREND);
    if (!tmp0) {
      if (debug) printf("No end of headers found\n");
      t_read = -1;
      goto finish;
    }
    headlen = tmp0 + strlen(HEADEREND) - readbuf;
  
    /* Incomplete read */
    /* FIXME: other conditions for additional read?? */
    while ( (chunked) && (!strstr(readbuf, CHUNK_END)) ) {
      if (debug) printf("No chunk end found: re-read\n");
      if (t_read >= sizeof(readbuf)) {
	if (debug) 
	  printf("Error: read buffer exhausted %d", sizeof(readbuf));
	t_read=-1;
	goto finish;
      }
      r = do_read(readbuf+t_read, sizeof(readbuf)-t_read, &close_this);
      if (r < 0) {
	t_read=-1;
	goto finish;
      }
      t_read = t_read + r;
      readbuf[t_read] = 0;    // insert end of string
    }

    while ((doclen) && (t_read != (headlen + doclen)) ) {
      if (debug) 
	  printf("read only %d, should be %d: re-reading\n", 
		 t_read, (headlen + doclen));
      if (t_read >= sizeof(readbuf)) {
	if (debug) 
	  printf("Error: read buffer exhausted %d\n", sizeof(readbuf));
	t_read=-1;
	goto finish;
      }
      r = do_read(readbuf+t_read, sizeof(readbuf)-t_read, &close_this);
      t_read = t_read + r;
    }


    /* finish */

 finish:
    if (!keepalive || close_this || (r <= 0)) {
      if (debug) printf("closing connection\n");
      close(sock);
      sock = -1;
    }
    
    if ( debug ) 
      printf( "get_one_page returned HTTP status %d (%d read)\n", http_status, t_read);

    if ( debug && verbose ) 
      puts(readbuf);


    //    if ( (total_read>0) && (abs(t_read-total_read)>5) ) {
    //printf("Shit happened: %d requested, %d read\n", total_read, t_read);
    //  exit (-1);
    //}

    if ( t_read < 0 )  {
      if ( debug ) printf( "ERR return %d\n", r);
      return t_read;
    }
    
    return ( (http_check) ? http_status : t_read );
}


int irand(int max) {
  /* returns random integer between [0..max-1] */
  return (int) ((double)max*rand()/(RAND_MAX+1.0));
}

void randomize(char *getme, char *url)
     /* 
	Generates a new URL for every GET: [url/]i/j/.../z.html
	
	i,j,z aus ['0'-'9'], number of subdir levels = rlevel

	Parameters: 
	  getme: String to contain the complete GET request 
                 (uses gettext as sprintf format string)
	  url: String that contains root-URL	 
	uses global variable  rlevel
     */
{
  int rr, r1;
  char r_url[64];

  if (rlevel>=0) {                 /* handcrafted urls: /1/2/3.html */
    strcpy(r_url, url);  

    for (r1=0; r1 < rlevel; r1++) {
      rr = irand(10);
      sprintf( r_url, "%s%c/", r_url, ITOA(rr) );     /* append dirs */
    }

    rr = irand(10);
    sprintf( r_url, "%s%c.html", r_url, ITOA(rr) );   /* append file */
    /* new HTTP-GET */
    if (keepalive){
	if (deflate){
	      sprintf( getme, gettext_ka_def, r_url );
	}else{
	      sprintf( getme, gettext_ka, r_url );
	}
    } else{
	if (deflate){
      	      sprintf( getme, gettext_def, r_url );
	}else {
      	      sprintf( getme, gettext, r_url );
        }
    }
  }
  else {                          /* random urls from file */
    rr = irand(nr_urls); 
    if (keepalive){
	if (deflate){
      		sprintf( getme, gettext_ka_def, urls[rr] );
	} else {
      		sprintf( getme, gettext_ka, urls[rr] );
	}
    }else{
	if (deflate){
	      sprintf( getme, gettext_def, urls[rr] );
	} else {
	      sprintf( getme, gettext, urls[rr] );
	}
    }
  }
  if (verbose) fprintf(stderr,"%s\n", getme);
}


int do_sync(char *sync_host) {
  /*
    sync against a master server
    reads a "magic byte" from the server
    sends it back, to say "I'm here"
    and waits for another to sync with the other clients
  */

   int sock;
   int start_magic = 0;
   struct  hostent *shp;       // sync host entry
   struct sockaddr_in s_s_in;  // sync host IP

   if ( verbose ) fprintf(stderr, "gethostbyname... (%s)\n", sync_host );

   shp = gethostbyname (sync_host);

   if (!shp)
     {
       fprintf( stderr, "gethostbyname (%s) failed\n", sync_host );
       exit(1);
     }

   bzero ((char *) &s_s_in, sizeof (s_s_in));
   bcopy ((char *) shp->h_addr, (char *) &(s_s_in.sin_addr), shp->h_length);
   s_s_in.sin_family = shp->h_addrtype;
   s_s_in.sin_port = htons(sync_port);

   if ( verbose ) 
     fprintf( stderr, "\tsync host: %s, ip-address: %d.%d.%d.%d\n",
	     shp->h_name,
	     ((unsigned char*)&s_s_in.sin_addr.s_addr)[0],
	     ((unsigned char*)&s_s_in.sin_addr.s_addr)[1],
	     ((unsigned char*)&s_s_in.sin_addr.s_addr)[2],
	     ((unsigned char*)&s_s_in.sin_addr.s_addr)[3]);

   if ( verbose ) 
     fprintf(stderr, "doing the sync.\n");

   sock = socket (AF_INET, SOCK_STREAM, 0);
   connect (sock, (struct sockaddr *) &s_s_in, sizeof (s_s_in));
   if (read(sock, &start_magic, sizeof(start_magic) ) != sizeof(start_magic)) {
     fprintf( stderr, "sync read from host (%s) failed\n", sync_host);
     exit(1);
   }
   if (start_magic != getwww_magic) {
     fprintf( stderr, "sync magic from host (%s) == %08x, != %08x\n",
			sync_host, start_magic, getwww_magic);
     exit(1);
   }
   if (write(sock, &start_magic, sizeof(start_magic) ) != sizeof(start_magic)) {
     fprintf( stderr, "sync write to host (%s) failed\n", sync_host);
     exit(1);
   }
   if (read(sock, &start_magic, sizeof(start_magic) ) != sizeof(start_magic)) {
     fprintf( stderr, "sync read from host (%s) failed\n", sync_host);
     exit(1);
   }
   if (start_magic != getwww_magic) {
     fprintf( stderr, "sync magic from host (%s) == %08x, != %08x\n",
			sync_host, start_magic, getwww_magic);
     exit(1);
   }
   if ( verbose ) 
     fprintf(stderr, "sync done, starting test.\n");

   close (sock);
   return 0;
 }


char **add_url(char **urllist, int nr, char *buff) {

  // FIXME: memory is never freed 

  urllist = (char **) realloc (urllist, (nr+1) * sizeof(char*) );
  if ( !urllist ) {
    perror("error in realloc");
    exit (1);
  }
  urllist[nr] = (char *) malloc( strlen(buff) + 1 );
  strcpy (urllist[nr], buff);
  if ( !urllist[nr] ) {
    perror("error in malloc");
    exit (1);
  }
  return(urllist);
}

int main(int argc, char ** argv)
{

struct	hostent *hp;
char	host[128] = "";
char 	url[256] = "/";
char *  filename = NULL;
char *  urlfile = NULL;
int	errflag=0;

static char sync_host[256];

int	nr_procs=1, nr_reps=1;

int	n_loop, n_proc;

int	i, c, t_read, t_err;

int	run_time = 0;		/* max. run time of program(s) */
unsigned long long start_time, curr_time, stop_time;
double	secs;
double * results;

extern	char *	optarg;
extern	int	optind;

int	siz_wanted;			/* "should be" size */
int	count = 0;

 while ( ( c = getopt( argc, argv, "vdiHkPu:s:r:p:f:F:R:D:N:" ) ) != -1 )
   {
     switch( c )
       {
       case 'v': verbose=TRUE; break;
       case 'd': debug=TRUE; break;
       case 'i': ign_size=TRUE; break;
       case 'H': http_check=TRUE; ign_size=TRUE; break;
       case 'k': keepalive=TRUE; http_check=TRUE; ign_size=TRUE; break;
       case 'u': strcpy(url,optarg); break;
       case 'r': run_time=atoi(optarg); break;
       case 'p': port=atoi(optarg); break;
       case 'P': deflate=TRUE; break;
       case 's': strcpy(sync_host,optarg); use_sync = 1; break;
       case 'f': param_f=TRUE; ign_size=TRUE; filename=optarg;break;
       case 'F': param_F=TRUE; urlfile=optarg;break;
       case 'R': rlevel=atoi(optarg); break;
       case 'D': db_tnum=atoi(optarg); break;
       case 'N': db_num=atoi(optarg); break;
       case '?': errflag++; break;
       }
   }

 // printf("keepalive: %d\n", keepalive); 
 /* req'd arguments there? */
 if ( optind+2 != argc ) errflag++;


 if ( (rlevel>=0) && (param_F) ) {
   fprintf(stderr, "\nYou can only use \"-R\" OR \"-F\"\n\n");
   errflag++;
 }

 if ( errflag )
   {
     fprintf( stderr, "%s [options] server n_proc\n"
	      "\t[-v]\tverbose output\n"
	      "\t[-d]\tdebugging\n"
	      "\t[-i]\tignore page size\n"		 
	      "\t[-H]\tcheck HTTP status message (implies -i)\n"
	      "\t[-k]\tuse HTTP Keep-Alive requests (implies -i -H)\n"
	      "\t[-S]\tuse HTTPS\n" 
	      "\t[-R level]\trandomize pages in dir-hir\n"		 
	      "\t[-r s]\tset program run time in seconds\n"
	      "\t[-u url]\tset url to fetch\n"
	      "\t[-P]\tEnable Compression of HTTP-data (deflate)\n"
	      "\t[-p port]\tport to connect [80]\n"
	      "\t[-f file]\tread params from file\n"
	      "\t[-F file]\tread URLs from file (randomizing, implies -i)\n"
	      "\t[-s host]\tsync master host\n"
	      "\t[-D num]\tdo db test (total number of entries)\n"
	      "\t[-N num]\tdb test: number of entries (10)\n"
	      "\tn_proc: number of pocesses (ignored with -f)\n"
	      "\tFormat of parameter file:\n"
	      "\t\t[host] [port] [URL] [proc] [time] [rlevel]\n"
	      , argv[0] );
     return 1;
   }

 strcpy(host,  argv[optind++]);
 nr_procs = atoi(argv[optind++]);	/* parallel processes */
 if (optind != argc)
	 nr_reps  = atoi(argv[optind++]);     /* number of repetitions p.p. */
 
 if ( param_f ) {                     /* read params from file      */
   FILE *file;                        /* necessary for start via inetd*/
   file = fopen( filename, "r");  
   if (file == NULL) {  
     perror( filename); 
     return 1;
   }
   if ( fscanf ( file, "%s %i %s %i %i %i\n", 
		 host, &port, url, &nr_procs, &run_time, &rlevel) != 6 ) { 
     fprintf( stderr, "couldn't read params from %s\n", filename); 
     return 1;
   }
   if ( debug ) 
     printf ( "host:%s port:%i url:%s procs:%i time:%i rlevel:%i\n",
	      host, port, url, nr_procs, run_time, rlevel);
   fclose(file);
 }

 if ( param_F ) {                   /* read URLs from file */
   FILE *file;
   char ubuff[1024];
   char *nl=NULL;

   file = fopen( urlfile, "r");  
   if (file == NULL) {  
     perror( urlfile ); 
     return 1;
   }
   while ( fgets( ubuff, sizeof(ubuff)-1, file) ) {
     nl=strchr(ubuff, '\n'); 
     if (nl) *nl=0;
     if (verbose) fprintf( stderr, "Adding URL: %s\n", ubuff);
     urls = add_url ( urls, nr_urls, ubuff );
     if (!urls ) {
       fprintf( stderr, "error adding URL: %s", ubuff);
       exit (1);
     }
     nr_urls++;
   }    
   strcpy(url, urls[0]);
   fclose(file);
 }


 /*-- Built GET message --*/
 if (deflate)
	 sprintf( getme, gettext_def, url );
 else
	 sprintf( getme, gettext, url );

 if ( (rlevel >= 0) || (param_F)) {
   randomize(getme, url);     /* randomize handles keep alive too */
 } else if (keepalive) {
 	if (deflate){
   		sprintf( getme, gettext_ka_def, url );
	}else {
   		sprintf( getme, gettext_ka, url );
	}	
 } else if (db_tnum) { 
   int lower;
   // FIXME: DB test only if *not* keep alive
   lower = irand(db_tnum-db_num);
   if (deflate){
   	sprintf( dbget, gettext_def, url );
   } else {
   	sprintf( dbget, gettext, url );
   } 
   sprintf( getme, dbget, lower, lower+db_num);    
 } 
 if (verbose) fputs (getme, stderr);

 if ( verbose ) fprintf(stderr, "gethostbyname... (%s)\n", host );

 hp = gethostbyname (host);

 if (!hp)
   {
     fprintf( stderr, "gethostbyname (%s) failed\n", host );
     return 1;
   }


 /*-- Get one test page first --*/
 bzero ((char *) &s_in, sizeof (s_in));
 bcopy ((char *) hp->h_addr, (char *) &(s_in.sin_addr), hp->h_length);
 s_in.sin_family = hp->h_addrtype;
 s_in.sin_port = htons(port);

 if ( verbose ) 
   fprintf(stderr,  "\thost: %s, ip-address: %d.%d.%d.%d\n",
	   hp->h_name,
	   ((unsigned char*)&s_in.sin_addr.s_addr)[0],
	   ((unsigned char*)&s_in.sin_addr.s_addr)[1],
	   ((unsigned char*)&s_in.sin_addr.s_addr)[2],
	   ((unsigned char*)&s_in.sin_addr.s_addr)[3]);

 /* get one page to check size */
 siz_wanted = get_one_page(0);

 if ( siz_wanted < 0 ) {
   fprintf( stderr, "can't connect to server (not at all!), exit.\n");
   return 1;
 }
 if (http_check) {
   siz_wanted = 0; 
 }

 close(sock);
 sock = -1;

 printf( "URL: '%s', size: %d, %d processes running...\n", 
	 url, siz_wanted, nr_procs );
 fflush(stdout);

 {
     int fd;
     char zerobuff [4096] = { 0, };
     creat(".tmp_mmap", 0700);
     fd = open(".tmp_mmap", O_RDWR|O_CREAT|O_TRUNC);
     write (fd, zerobuff, 4096);
     results = (double *)mmap(0, 4096, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
     memset(results, 0, 4096);
 }

 if (use_sync) {
   do_sync(sync_host);
 }

 GET_TIME(start_time);
 stop_time = start_time + run_time*1E6;

 /* make <nr_procs> processes here, all doing this in parallel */
 n_proc=0;

 while( n_proc < (nr_procs-1) )
   {
     int p = fork();
     
     if ( p<0 ) { perror("fork"); return 9; }
     if ( p==0) break;	/* child no. n_proc */
     
     /* parent */
     if (debug) printf( "forked off child %d, pid %d\n", n_proc, p);

     n_proc++;
   }

#if 0
 sleep(20);
 stop_time = start_time + (run_time+20)*1E6;
#endif
 srand(start_time+n_proc);

 n_loop=0;
 t_err=0;	/* total errors */

 GET_TIME(curr_time);
 do  /*-------- Fetch Loop ------------*/
   {

     if ((rlevel >= 0)  || (param_F))    /* randomize URL */
       randomize(getme, url);
     else if (db_tnum) { 
       int lower;
       // FIXME: DB test only if *not* keep alive
       lower = irand(db_tnum-db_num);
       sprintf( dbget, gettext, url );
       sprintf( getme, dbget, lower, lower+db_num);    
     } 

     t_read = get_one_page(siz_wanted);

     if ( verbose ) 
       fprintf( stderr, "Proc %d, Loop %d: Total number of bytes read: %d\n", 
	       n_proc, n_loop, t_read );

     if (t_read < 0)      
       /* GET-error */
       {
	 if (verbose) 
	   fprintf( stderr, "Proc %d, Loop %d: connection error %d\n", 
		   n_proc, n_loop, t_read);
	 t_err++;
       }
     else if ( (!ign_size) && (abs(t_read-siz_wanted) > 5) && (!http_check) )  
       /* size-check wrong */
       /* FIXME: allowed 5 bytes off, accounts for changing dates,... */
       {
	 if (verbose) 
	   fprintf( stderr, "Proc %d, Loop %d: got unexpected size %d\n", 
		   n_proc, n_loop, t_read);
	 t_err++;
       }
     else if ((http_check) && (t_read != HTTP_OK) )
       {
	 if (verbose) 
	   fprintf( stderr, "Proc %d, Loop %d: got unexpected HTTP status %d\n", 
		   n_proc, n_loop, t_read);
	 t_err++;
       }
     else 
       {
	 n_loop++;      /* count it */
       }

     if (!(count & 0/*15*/))
	     GET_TIME(curr_time);
     count++;
   }
 while (
 ( run_time == 0 && n_loop+t_err < nr_reps ) ||
	 ( run_time >= 0 && ( curr_time < stop_time ) ) );

 secs = run_time;
 printf( "Proc %3d: %4d requests %2d errors %.0f seconds -> %1.1f Hps %.1f ms/H\n",
	 n_proc, n_loop, t_err, secs, n_loop/secs, (secs*1000.0)/n_loop );
 results[n_proc] = n_loop/secs;

/*
 * "master" parent process
 * wait for all children to gather
 */
if (n_proc == nr_procs-1) {
	double sum = 0.0;

	for (i = 0; i < nr_procs; i++) 
		wait(NULL);
	for (i = 0; i < nr_procs; i++) 
		sum += results[i];
	printf( "Summary: %1.1f Hps\n", sum);
}


 return 0;
}

