#!/usr/bin/perl

use Cwd;
use Cwd 'chdir';

my $readbuf;

#
# main

if ( $#ARGV < 2 ) {
  die "Usage: $0 <root-dir> <filenum> <num read> <[debug-flag>]\n",
  "\ndebug-flag: -s for sequential read, -v for verbose -p for print\n";
}

$root = $ARGV[0];
$maxnum = $ARGV[1];
$numread = $ARGV[2];
$debug = $ARGV[3];

chdir "./$root" or die "Can't chdir $root: $!\n";
srand();     # initialise random numbers

for ($i=0; $i < $numread; $i++) {
    $f = int rand($maxnum);
    if ($debug eq "-s") { 
	$f=$i; 
    } else { 
	$f = int rand($maxnum); 
    }
    open ( MYFILE, "< ./$f" ) || die("can't open file: $!");
    $readbuf = <MYFILE>;
    # trick copy on write
    for ($j = 0; $j < length($readbuf); $j+=512) {
	substr($readbuf, $j, 1, "X");
    }
    if ($debug eq "-v") {
	printf("./$f "); 
    }
    if ($debug eq "-p") {
	printf("$readbuf\n"); 
    }

}
