#!/usr/bin/perl
#
# Syntax: dirhir <root-dir> <Level> <size>
#
# creates a directory tree in <root-dir> with a depth of <level>.
# leafs are named [0-9].html, filled with random numbers, size is <size> KB
#
# Example:
# ./dirhir.pl rand2 2 4
# 
# creates 10^3 files of size 4 KB (example: rand2/0/1/2.html)
# 
# takes hours for N=5, see dirhirf.pl
#

use Cwd;
use Cwd 'chdir';

$dirmode = 0777;
$level = 0;

sub mkfile {
# Parameter: Dateiname

  my $fname = $_[0];
  my $j, $myrand;

  open ( MYFILE, ">./$fname");
  for ($j=0; $j<$size; $j++) {
    $myrand = int rand(10);
    print ( MYFILE "$myrand");
  }
  close ( MYFILE );
}	 



sub mklevel {
# Paramter: level = depth of level
# does recursiv calls to itself with (level-1)

  my $level = $_[0];
  my $i;
  my $aktdir = cwd();

  if ($level > 0) {
    # Directories erzeugen
    for ($i = 0; $i < 10; $i++) {
      my $newdir = "$aktdir/$i";
      mkdir $newdir, $dirmode or die "Can't mkdir $newdir: $!\n";
      chdir $newdir or die "Can't chdir $newdir: $!\n";
      mklevel($level-1);
      chdir "..";
    }
  } else {
    # Dateien erzeugen
    for ($i = 0; $i < 10; $i++) {
      mkfile("$i" . ".html");
    }
  }
}


#
# main
#
if ( $#ARGV < 2 ) {
  die "Usage: $0 <root-dir> <levels> <size>\n";
}

$root = $ARGV[0];
$levels = $ARGV[1];
$size = 1024 * $ARGV[2];

srand();     # initialise random numbers
mkdir "./$root", $dirmode or print "$root exists, using it\n";
chdir "./$root" or die "Can't chdir $root: $!\n";
mklevel($levels);
