/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: key.c 
 * Info: Routinen zum Einlesen der Taster
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <avr/io.h>
#include <avr/delay.h>
#include "key.h"
#include "led.h"
#include "tools.h"
#include "display.h"

//Liest alle Tasten aus. Wartet bis zu timeout und kehrt dann auch zurck, wenn keine nderung erfolgt ist.
char key_read(char timeout){
	char old_DDRD= DDRD;	// Alte Einstellungen sichern
	char old_PORTD= PORTD;
	
	char key,old,temp;	//Tastenpuffer
	char i,j,k;		//Zhler
	
	DDRD &= ~ KEY_ALL;	// All Key-Ports as Input	
	PORTD |= KEY_ALL;	// Alle Pullups an.

	key = PIND;			//  Einlesen 
	key &= KEY_ALL;		// und maskieren
	old=key;
	
	k=0; i=0;
	while ((old == key) & (i < timeout)){   // solange warten, bis Taste gedrckt
		
	 	k++;					// Innenzhler erhhen
	 	if (k==0) i++;			// jeden 8-Bit berlauf den aussen Zhler erhhen

		key = PIND;			// Neu Einlesen 
		key &= KEY_ALL;		// und maskieren

		for (j=0; j< 255; j++){}	// warten
		temp = PIND;			// zum entprellem nochmal lesen
		temp &= KEY_ALL;		// und maskieren
		
		if (key != temp)		// falls unterschiedliches gelesen, lauf wiederholen
			key=old;
	}
	
	DDRD= old_DDRD;		// wiederherstellen
	PORTD= old_PORTD;
	
	if (i == timeout) 
		return KEY_TIMEOUT;
	else
		return key;
}
