/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: adc.c 
 * Info: Routinen zum Einlesen der Analogeingnge
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <avr/io.h>
#include <avr/delay.h>
#include "adc.h"
#include "led.h"
#include "tools.h"
#include "display.h"

//Liest einen analogen kanal aus
//Der Parameter ist die Nummer des Pins (0x00 fr PA0; 0x01 fr PA1, ..)
int read_adc(char channel){
	int result = 0x00;
	char hex[3];
	char old_DDRA= DDRA;// Alte Einstellungen sichern
	char old_PORTA= PORTA;
	
	DDRA &= ~ (1<<channel);	// Pin als input
	PORTA &= ~ (1<<channel);	// Alle Pullups aus.
		
	ADMUX = 0x80+0x40;		// interne Refernzspannung, rechts Ausrichtung
	ADMUX |= channel;		// Und jetzt Kanal whlen
	
	ADCSRA= 
		(1<<ADPS2) + (1<<ADPS1)+	// prescale faktor = 64 ADC luft mit 14,7456MHz / 64 = 230,4 kHz 
		(1 << ADEN)+				// ADC an
		(1 << ADSC);				// Beginne mit der Konvertierung
			
	while ( (ADCSRA & (1<<ADSC)) != 0){} //Warten bis konvertierung beendet
	
	result= ADCL + (ADCH <<8);	// Ergebnis zusammenbauen
	
	DDRA= old_DDRA;		// wiederherstellen
	PORTA= old_PORTA;
	
	return result;
}
