using System;
using System.Diagnostics; 

namespace CSharpNETComponent
{
  public interface ICSharpNETServ
  {
    void IntParam(int Param1); 
    void NoParam();
    int IntVal { get;} 
    string StrVal {get;}
    void StrParam(string Param1);
    int ProcessID {get;} 
  }

  // Ableitung von MarshalByRefObject ist Voraussetzung fr Out of Proc-Aufruf (Remoting)
  public class CSharpNETServ : MarshalByRefObject, ICSharpNETServ
  {
    private int m_IntVal, Result;
    private string m_StrVal; 
    public void IntParam(int Param1)
    {
      m_IntVal = Param1; 
      Result = 0; 
    }
    public void NoParam() 
    {
      Result = 0; 
    }
    public int IntVal
    { 
      get 
      {
        Result = 0; 
        return m_IntVal; 
      }
    } 
    public string StrVal 
    { 
      get 
      {
        Result = 0; 
        return m_StrVal; 
      }
    } 

    public void StrParam(string Param1)
    {
      m_StrVal = Param1; 
      Result = 0; 
    }

    public int ProcessID
    {
      get
      {
        return Process.GetCurrentProcess().Id;
      }
    }
  }
  // fr Out of Proc-Geschichten
  public class CSharpNETServOutTCP : CSharpNETServ  {}
	public class CSharpNETServOutHTTP : CSharpNETServ	{}
	public class CSharpNETServOutCAO : CSharpNETServ	{}
}
