unit DelphiNetCSClient;

interface

uses
  Borland.Vcl.ComObj,
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.StdCtrls, System.ComponentModel, CS_DLLLib, CS_EXELib;

type
  TForm1 = class(TForm)
    bInProcEarly: TButton;
    bOutProcEarly: TButton;
    Memo1: TMemo;
    Label1: TLabel;
    procedure bInProcEarlyClick(Sender: TObject);
    procedure bOutProcEarlyClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation
const Msgs: Array[0..6] of String =
  ('Empty loop', 'NoParam', 'IntParam', 'StrParam', 'StrParam2', 'IntProp', 'StrProp');

{$R *.nfm}

procedure TForm1.bInProcEarlyClick(Sender: TObject);
var
  CT: CoCsDLLClass;
  x, BNum, Dummy: Integer;
  STime: System.DateTime;
  elapsed: System.TimeSpan;
begin
  Memo1.Lines.Add('*** Delphi.NET - early binding ***');
  STime := DateTime.Now;
  CT := CoCsDLLClass.Create;
  elapsed := DateTime.Now - STime;
  Memo1.Lines.Add(Format('Create (single): %.2f',[elapsed.TotalMilliseconds]));
  if GetCurrentProcessId = CT.ProcessID then Memo1.Lines.Add('in-process')
  else Memo1.Lines.Add('out-of-process');

  STime := DateTime.Now;
  for x := 1 to 100000 do
  begin
    CT := CoCsDLLClass.Create;
  end;
  elapsed := DateTime.Now - STime;
  Memo1.Lines.Add(Format('Create (100K): %.2f',[elapsed.TotalMilliseconds]));

  for BNum := 0 to 6 do
  begin
     Dummy := 0;
     STime := System.DateTime.Now;
     for x := 1 to 1000000 do // 1E6
       case BNum of
         0: Inc(Dummy, 1);
         1: CT.NoParam;
         2: CT.IntParam(4);
         3: CT.StrParam('Some string');
         4: CT.StrParam('Some String with twice as many characters');
         5: Dummy := CT.IntProp;
         6: if CT.StrProp <> '' then ;
       end;
      elapsed := DateTime.Now - STime;
      Memo1.Lines.Add(Format(Msgs[BNum] + ': %.2f',[elapsed.TotalMilliseconds]));
  end;
end;

procedure TForm1.bOutProcEarlyClick(Sender: TObject);
var
  CT: CsExeClass;
  x, BNum, Dummy: Integer;
  STime: System.DateTime;
  elapsed: System.TimeSpan;
begin
  Memo1.Lines.Add('*** Delphi.NET - early binding ***');
  STime := DateTime.Now;
  CT := CsExeClass.Create;
  elapsed := DateTime.Now - STime;
  Memo1.Lines.Add(Format('Create (single): %.2f',[elapsed.TotalMilliseconds]));
  if GetCurrentProcessId = CT.ProcessID then Memo1.Lines.Add('in-process')
  else Memo1.Lines.Add('out-of-process');

  STime := DateTime.Now;
  for x := 1 to 1000 do
  begin
    CT := CsExeClass.Create;
  end;
  elapsed := DateTime.Now - STime;
  Memo1.Lines.Add(Format('Create (100K): %.2f',[100*elapsed.TotalMilliseconds]));

  for BNum := 0 to 6 do
  begin
     Dummy := 0;
     STime := System.DateTime.Now;
     for x := 1 to 10000 do
       case BNum of
         0: Inc(Dummy, 1);
         1: CT.NoParam;
         2: CT.IntParam(4);
         3: CT.StrParam('Some string');
         4: CT.StrParam('Some String with twice as much characters');
         5: Dummy := CT.IntProp;
         6: if CT.StrProp <> '' then ;
       end;
      elapsed := DateTime.Now - STime;
      Memo1.Lines.Add(Format(Msgs[BNum] + ': %.2f',[100*elapsed.TotalMilliseconds]));
  end;
end;

end.
