using System;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Diagnostics; 
using System.Reflection; 

namespace CSharpCOMClient
{
  /// <summary>
  /// Zusammenfassung fr Form1.
  /// </summary>
  public class Form1 : System.Windows.Forms.Form
  {
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.Label label2;
    private System.Windows.Forms.TextBox textBox1;
    private System.Windows.Forms.Button bTypeEarly;
    private System.Windows.Forms.Button bNetOutEarly;
    private System.Windows.Forms.Button bNetOutLate;
    private System.Windows.Forms.Button bTypeLate;
    /// <summary>
    /// Erforderliche Designervariable.
    /// </summary>
    private System.ComponentModel.Container components = null;

    public Form1()
    {
      InitializeComponent();
    }
    protected override void Dispose( bool disposing )
    {
      if( disposing )
      {
        if (components != null) 
        {
          components.Dispose();
        }
      }
      base.Dispose( disposing );
    }

    #region Vom Windows Form-Designer generierter Code
    /// <summary>
    /// Erforderliche Methode fr die Designeruntersttzung. 
    /// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
    /// </summary>
    private void InitializeComponent()
    {
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.bTypeEarly = new System.Windows.Forms.Button();
			this.bTypeLate = new System.Windows.Forms.Button();
			this.bNetOutEarly = new System.Windows.Forms.Button();
			this.bNetOutLate = new System.Windows.Forms.Button();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(184, 56);
			this.label1.TabIndex = 0;
			this.label1.Text = "Laufzeitvergleiche fr Aufrufe minimalistischer Methoden. Bestimmend sollte das M" +
				"arshalling der Parameter sein. ";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 88);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(184, 80);
			this.label2.TabIndex = 1;
			this.label2.Text = "Bei spter Bindung und out-of-process-Servern wird der Zeitbedarf fr 1 Million A" +
				"ufrufe vom Programm hochgerechnet - sonst wrde es recht lange dauern";
			// 
			// bTypeEarly
			// 
			this.bTypeEarly.Location = new System.Drawing.Point(16, 224);
			this.bTypeEarly.Name = "bTypeEarly";
			this.bTypeEarly.Size = new System.Drawing.Size(160, 24);
			this.bTypeEarly.TabIndex = 5;
			this.bTypeEarly.Text = "InProcEarly";
			this.bTypeEarly.Click += new System.EventHandler(this.bInProcEarly_Click);
			// 
			// bTypeLate
			// 
			this.bTypeLate.Location = new System.Drawing.Point(16, 320);
			this.bTypeLate.Name = "bTypeLate";
			this.bTypeLate.Size = new System.Drawing.Size(160, 24);
			this.bTypeLate.TabIndex = 6;
			this.bTypeLate.Text = "InProcLate";
			this.bTypeLate.Click += new System.EventHandler(this.bInProcLate_Click);
			// 
			// bNetOutEarly
			// 
			this.bNetOutEarly.Location = new System.Drawing.Point(16, 256);
			this.bNetOutEarly.Name = "bNetOutEarly";
			this.bNetOutEarly.Size = new System.Drawing.Size(160, 24);
			this.bNetOutEarly.TabIndex = 7;
			this.bNetOutEarly.Text = "OutProcEarly";
			this.bNetOutEarly.Click += new System.EventHandler(this.bOutProcEarly_Click);
			// 
			// bNetOutLate
			// 
			this.bNetOutLate.Location = new System.Drawing.Point(16, 352);
			this.bNetOutLate.Name = "bNetOutLate";
			this.bNetOutLate.Size = new System.Drawing.Size(160, 24);
			this.bNetOutLate.TabIndex = 8;
			this.bNetOutLate.Text = "OutProcLate";
			this.bNetOutLate.Click += new System.EventHandler(this.bOutProcLate_Click);
			// 
			// textBox1
			// 
			this.textBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.textBox1.Location = new System.Drawing.Point(192, 16);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox1.Size = new System.Drawing.Size(224, 368);
			this.textBox1.TabIndex = 9;
			this.textBox1.Text = "";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(424, 397);
			this.Controls.Add(this.textBox1);
			this.Controls.Add(this.bNetOutLate);
			this.Controls.Add(this.bNetOutEarly);
			this.Controls.Add(this.bTypeLate);
			this.Controls.Add(this.bTypeEarly);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Name = "Form1";
			this.Text = "C# calls COM";
			this.ResumeLayout(false);

		}
    #endregion

    [STAThread]
    static void Main() 
    {
      Application.Run(new Form1());
    }


    string TestProcID(int pid)
    {
      if (pid == Process.GetCurrentProcess().Id)
        return "\r\nin-process";
      else 
        return "\r\n out-of-process";
    }


    string [] msgs = new string[] {"Empty loop", "NoParam", 
      "IntParam", "StrParam", "StrParam2", "IntProp", "StrProp"};

    private void bInProcEarly_Click(object sender, System.EventArgs e)
    {
      textBox1.Text += "\r\n*** COM, early binding ***"; 
      DateTime dtStart = DateTime.Now;
      CS_DLLLib.CoCsDLLClass CsDllObj = new CS_DLLLib.CoCsDLLClass(); 
      TimeSpan ts = DateTime.Now - dtStart; 
      textBox1.Text += TestProcID(CsDllObj.ProcessID); 
      textBox1.Text += "\r\nCreate (single): " + ts.TotalMilliseconds.ToString(); 
      textBox1.Refresh(); 

      dtStart = DateTime.Now; 
      for (int i = 0; i < 10000; i++)
      {
        CsDllObj = new CS_DLLLib.CoCsDLLClass(); 
      }
      ts = DateTime.Now - dtStart; 
      textBox1.Text += "\r\nCreate (100K): " + (10*ts.TotalMilliseconds).ToString("F"); 
      textBox1.Refresh(); 

      for(int i = 0; i < 7; i++)
      {
        dtStart = DateTime.Now; 
        for (int k = 0; k < 1000000; k++)
          switch(i)
          {
            case 0: break;
            case 1: CsDllObj.NoParam(); break;
            case 2: CsDllObj.IntParam(4); break;
            case 3: CsDllObj.StrParam("Some string"); break;
            case 4: CsDllObj.StrParam("Some string with twice as much characters"); break;
            case 5: int dummy = CsDllObj.IntProp; break;
            case 6: string d = CsDllObj.StrProp; break;
          }
        ts = DateTime.Now - dtStart; 
        textBox1.Text += "\r\n"+msgs[i]+": " + ts.TotalMilliseconds.ToString("F"); 
        textBox1.Refresh(); 
      }
    }


    private void bInProcLate_Click(object sender, System.EventArgs e)
    {
      textBox1.Text += "\r\n*** COM, late binding ***"; 
      DateTime dtStart = DateTime.Now;
      AppDomain ad = AppDomain.CurrentDomain;
      CS_DLLLib.CoCsDLLClass CsDllObj = (CS_DLLLib.CoCsDLLClass) ad.CreateInstanceAndUnwrap("Interop.CS_DLLLib","CS_DLLLib.CoCsDLLClass");
      TimeSpan ts = DateTime.Now - dtStart; 
      textBox1.Text += TestProcID(CsDllObj.ProcessID); 
      textBox1.Text += "\r\nCreate (single): " + ts.TotalMilliseconds.ToString(); 
      textBox1.Refresh(); 

      dtStart = DateTime.Now; 
      for (int i = 0; i < 100; i++)
      {
        ad.CreateInstance("Interop.CS_DLLLib","CS_DLLLib.CoCsDLLClass");
      }
      ts = DateTime.Now - dtStart; 
      textBox1.Text += "\r\nCreate (100K): " + (1000*ts.TotalMilliseconds).ToString("F"); 
      textBox1.Refresh(); 
      Type t = CsDllObj.GetType(); 
    
      for(int i = 0; i < 7; i++)
      {
        dtStart = DateTime.Now; 
        for (int k = 0; k < 100000; k++)
          switch(i)
          {
            case 0: break;
            case 1: t.InvokeMember("NoParam",BindingFlags.InvokeMethod, null, CsDllObj, null);
              break;
            case 2: t.InvokeMember("IntParam",BindingFlags.InvokeMethod, null, CsDllObj, new object[]{4}); 
                      break;
            case 3: t.InvokeMember("StrParam",BindingFlags.InvokeMethod, null, CsDllObj, new object[]{"Some string"}); 
                      break;
            case 4: t.InvokeMember("StrParam",BindingFlags.InvokeMethod, null, CsDllObj, new object[]{"Some string with twice as much characters"}); 
              break;
            case 5: t.InvokeMember("IntProp",BindingFlags.GetProperty, null, CsDllObj, null);
              break;
            case 6: t.InvokeMember("StrProp",BindingFlags.GetProperty, null, CsDllObj, null);
              break;
          }
        ts = DateTime.Now - dtStart; 
        textBox1.Text += "\r\n"+msgs[i]+": " + (10*ts.TotalMilliseconds).ToString("F"); 
        textBox1.Refresh(); 
      }
    }

    private void bOutProcEarly_Click(object sender, System.EventArgs e)
    {
      textBox1.Text += "\r\n*** COM, early binding ***"; 
      DateTime dtStart = DateTime.Now;
			CS_EXELib.CsExeClass CsExeObj = new CS_EXELib.CsExeClass();

      TimeSpan ts = DateTime.Now - dtStart; 
      textBox1.Text += TestProcID(CsExeObj.ProcessID); 
      textBox1.Text += "\r\nCreate (single): " + ts.TotalMilliseconds.ToString(); 
      textBox1.Refresh(); 

      dtStart = DateTime.Now; 
      for (int i = 0; i < 100; i++)
      {
        CsExeObj = new CS_EXELib.CsExeClass(); 
      }
      ts = DateTime.Now - dtStart; 
      textBox1.Text += "\r\nCreate (100K): " + (1000*ts.TotalMilliseconds).ToString("F"); 
      textBox1.Refresh(); 

      for(int i = 0; i < 7; i++)
      {
        dtStart = DateTime.Now; 
        for (int k = 0; k < 10000; k++)
          switch(i)
          {
            case 0: break;
            case 1: CsExeObj.NoParam(); break;
            case 2: CsExeObj.IntParam(4); break;
            case 3: CsExeObj.StrParam("Some string"); break;
            case 4: CsExeObj.StrParam("Some string with twice as much characters"); break;
            case 5: int dummy = CsExeObj.IntProp; break;
            case 6: string d = CsExeObj.StrProp; break;
          }
        ts = DateTime.Now - dtStart; 
        textBox1.Text += "\r\n"+msgs[i]+": " + (100*ts.TotalMilliseconds).ToString("F"); 
        textBox1.Refresh(); 
      }
    }

    private void bOutProcLate_Click(object sender, System.EventArgs e)
    {
      textBox1.Text += "\r\n*** COM, late binding ***"; 
      DateTime dtStart = DateTime.Now;
      AppDomain ad = AppDomain.CurrentDomain;
      CS_EXELib.CsExeClass CsExeObj = (CS_EXELib.CsExeClass) ad.CreateInstanceAndUnwrap("Interop.CS_EXELib","CS_EXELib.CsExeClass");
      TimeSpan ts = DateTime.Now - dtStart; 
      textBox1.Text += TestProcID(CsExeObj.ProcessID); 
      textBox1.Text += "\r\nCreate (single): " + ts.TotalMilliseconds.ToString(); 
      textBox1.Refresh(); 

      dtStart = DateTime.Now; 
      for (int i = 0; i < 100; i++)
      {
        ad.CreateInstanceAndUnwrap("Interop.CS_EXELib","CS_EXELib.CsExeClass");
      }
      ts = DateTime.Now - dtStart; 
      textBox1.Text += "\r\nCreate (100K): " + (1000*ts.TotalMilliseconds).ToString("F"); 
      textBox1.Refresh(); 
      Type t = CsExeObj.GetType(); 
    
      for(int i = 0; i < 7; i++)
      {
        dtStart = DateTime.Now; 
        for (int k = 0; k < 1000; k++)
          switch(i)
          {
            case 0: break;
            case 1: t.InvokeMember("NoParam",BindingFlags.InvokeMethod, null, CsExeObj, null);
              break;
            case 2: t.InvokeMember("IntParam",BindingFlags.InvokeMethod, null, CsExeObj, new object[]{4}); 
              break;
            case 3: t.InvokeMember("StrParam",BindingFlags.InvokeMethod, null, CsExeObj, new object[]{"Some string"}); 
              break;
            case 4: t.InvokeMember("StrParam",BindingFlags.InvokeMethod, null, CsExeObj, new object[]{"Some string with twice as much characters"}); 
              break;
            case 5: t.InvokeMember("IntProp",BindingFlags.GetProperty, null, CsExeObj, null);
              break;
            case 6: t.InvokeMember("StrProp",BindingFlags.GetProperty, null, CsExeObj, null);
              break;
          }
        ts = DateTime.Now - dtStart; 
        textBox1.Text += "\r\n"+msgs[i]+": " + (1000*ts.TotalMilliseconds).ToString("F"); 
        textBox1.Refresh(); 
      }
    }
  }

}
