#!/bin/bash

# Hier muss der DynDNS-Name hinein, fr das Beispiel im Aritkel
# DDHOST=trigger.dnsalias.net
DDHOST=

# Hier muss ein Port stehen, der in einer R-Tunnel-Definition
# auf dem Rechner im LAN auftritt
PORT=50080

# Alle Skripte aus dem Verzeichnis /etc/ppp/ip-up.d werden 
# aufgerufen, sobald die PPP-Verbindung steht.
# Wenn Sie dieses Skript in das
# Verzeichnis kopieren, setzt es bei jedem Verbindungs-
# aufbau die VPN-Verbindung zurck.
if [[ $0 == /etc/ppp/ip-up.d/* ]]
then
	ddclient -quiet -host "$DDHOST" -ip 127.0.0.1
else

	# Hier kommt der interaktive Aufruf	
	case "$1" in
		up|start|on)
			ddclient -quiet -host "$DDHOST"
			echo "Verbindung angestoen, bitte warten"
			until fuser -sn tcp "$PORT" 
			do
				echo -n .
				sleep 1
			done
			echo
		;;

		down|stop|off)
			ddclient -quiet -host "$DDHOST" -ip 127.0.0.1
			fuser -sk -n tcp "$PORT"
		;;

		status)
			if fuser -sn tcp "$PORT" 
			then
				echo VPN aufgebaut.
			else
				echo VPN nicht aufgebaut.
			fi
		;;

		*)
			echo "Aufruf: $0 [up|down|status]"
		;;
	esac
fi
