/* mt.h by Harald Bgeholz */

#define MT_MIN_STACKWORDS 22

#include "cdef.h"

typedef struct _MT_TCB /* thread control block */
{
  word sp;
  byte ticksleft;
  byte timeslice;
  struct _MT_TCB *next;
} MT_TCB;


/* ---- public interface ------------------------------------------- */
void MT_init(byte timeslice);
void MT_start_thread(MT_TCB *tcb, void (*function)(void), 
                     word timeslice, 
                     word *stack, word stackwords);
void MT_reschedule(void); /* give up the CPU */
void MT_killself(void);   /* nomen est omen */





