#!D:\perl\perl.exe
# $Id: pdf2smtp.pl,v 1.1 2004/02/27 07:59:10 felix Exp $
#
use strict;
use warnings;
use POSIX qw|strftime|;

my $file         = shift;
my $logfile      = 'C:\temp\pdf2smtp.log';
my $debug        = 0;
my $user         = $ENV{'REDMON_USER'};
my $host         = $ENV{'REDMON_MACHINE'};
my $job_id       = $ENV{'REDMON_JOB'};
   $host         =~ s|^\\*||;
my $mailserver   = 'mailserver.domain.tld';
my $domain       = 'domain.tld';
my $from_address = 'pdfmail@'.$domain;

my $docname      = defrag_docname($ENV{'REDMON_DOCNAME'});
my $GhostScript  = 'C:\gs\gs7.04\bin\gswin32c.exe';
my $Blat         = 'C:\gs\redmon\blat.exe';
my $tmp_dir      = "C:\\temp\\$user";
my $pdffile      = $tmp_dir."\\".$docname.".pdf";

mkdir ($tmp_dir);

# PDF mit ghostscript erzeugen
logger("Neue Session fr $user. Dokument '$file' => '$docname'");
logger("start /WAIT $GhostScript -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -dPDFSETTINGS=/default -dCompatibilityLevel=1.4 -sOutputFile=$pdffile \"$file\"")
	if ($debug);
system("start /WAIT $GhostScript -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -dPDFSETTINGS=/default -dCompatibilityLevel=1.4 -sOutputFile=$pdffile \"$file\"");
logger("Konvertierung abgeschlossen")
	if ($debug);

# Body fr email generieren
my $bodyfile = "C:\\temp\\$user\_$host\_$job_id.txt";
open (BODY,">$bodyfile") or logg( "Kann keine temporre Datei fr den email-Text anlegen ($bodyfile): $!");

print BODY "Hallo,\ndieses email wurde vom EDV-PDF-Service automatisch generiert und dient\n";
print BODY "der Auslieferung Ihres gewnschten Druckjobs als PDF-Datei. Anbei \n";
print BODY "finden Sie Ihr Dokument.\n\n\tBitte antworten Sie auf keinen Fall an diese Adresse!\n\n";
print BODY "Sollte der email kein Anhang beiliegen, so kann das daran liegen das sie, Sonderzeichen";
print BODY " im Dateinamen verwendet haben. Dieses wird nicht untersttzt.\n\n";
print BODY "Von Danksagungen bitten wir abzusehen :-)\n";

close BODY;

# PDF via BLAT versenden
logger("start /wait $Blat \"$bodyfile\" -server $mailserver -f $from_address -t $user\@$domain -s $docname -attach $pdffile");
system("start /wait $Blat \"$bodyfile\" -server $mailserver -f $from_address -t $user\@$domain -s $docname -attach $pdffile");

unlink($pdffile)  unless ($debug);
unlink($bodyfile) unless ($debug);
rmdir ($tmp_dir)  unless ($debug);

logger("Ende Session -----------------");

sub defrag_docname {
 # diverse strende Sonderzeichen/whitespacer durch
 # Unterstriche ersetzen
  my $filename = shift;
     $filename =~ s|[\s\\\/\&\$\%\@\(\)\{\}\[\]\=\'\,\;\:\#\+\~\>\<\|]+|_|g;
  return ($filename);
}

sub logger {
 # kleine log-routine
  my $message = shift;

  open (LOG, ">>$logfile") or warn "Konnte nicht an das logfile $logfile anhngen: $!";
  print LOG strftime("[%H:%M:%S %d.%m.%Y] ",localtime), $message,"\r\n";
  close LOG;

}