/***************************************************************************
* Titel        : RFHI.H
*
* Description  : Headerfile fr nRF2401
*
* Environment  : Anpassung auf MSP430
*
* Responsible  : J. Altenburg
*
* Guidelines   :
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  19.05.03 |J. Altenburg     | Ersterstellung
  --------------------------------------------------------------------------
           |                 |
  --------------------------------------------------------------------------
****************************************************************************/
/*
* Check if information are already included
*/
#ifndef RF433_H
#define RF433_H


#define MCUTYPE     MSP430F149          /* Spezifiziert den MCU-Type */
// #define MCUTYPE     M16C26


/***************************************************************************
* HEADER-FILES (Only those that are needed in this file)                   *
****************************************************************************/
/* System-headerfiles */
#include "cdef.h"                       /* General definitions and types */

#if       MCUTYPE == MSP430F149
 #include "msp430x14x.h"

#elif     MCUTYPE == M16C26
 #include "trallala.h"

#endif

/* Foreign headerfiles */


/***************************************************************************
* Defines und Makros fr externen Zugriff                                  *
****************************************************************************/

/***************************************************************************
* Typedefs                                                                 *
****************************************************************************/
typedef void (* fCallBackSmd)( void );  /* Callback-Funktion fr Empfangsroutine */




/***************************************************************************
*    Funktionsprototypen                                                   *
****************************************************************************/
void SMD_vInit  ( void );
void SMD_vStart ( fCallBackSmd,    /* Benachrichtigung */
                  byte,            /* Bewegungstyp, Halbschritt, Vollschritt */
                  word,            /* Hochlaufkurve */
                  int32            /* Schrittzahl, Vorzeichen = Drehrichtung */
                );

word SMD_wMove  ( void );          /* Bewegungserzeugung */
void SMD_vCritical( void );        /* Not-Aus */


/*
* End of check if information are already included
*/
#endif                                  /* ifndef */


/***************************************************************************
* EOF: SMD.H                                                              *
****************************************************************************/

