/***************************************************************************
* Titel        : CT03.C
*
* Description  : Beispiel zur Ansteuerung eines Schrittmotors
*
* Environment  :
*
* Responsible  : J. Altenburg
*
* Guidelines   :
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  13.12.03 |J. Altenburg     | Ersterstellung
  --------------------------------------------------------------------------
           |                 |
  --------------------------------------------------------------------------
****************************************************************************/

/***************************************************************************
* HEADER-FILES (Only those that are needed in this file)                   *
****************************************************************************/
/* System-headerfiles */
#include "cdef.h"                      /* General definitions and types */

#include "msp430x14x.h"
#include "msp430def.h"

/* Own headerfiles */


/* Foreign headerfiles */
#include "smd.h"

/***************************************************************************
* Defines und Makros Zugriff                                               *
****************************************************************************/

/* Prototyp fr Funktionspointer */
typedef void (* fLocalFunc)( void ); /* Funktionspointer */



/***************************************************************************
*    Variablen                                                             *
****************************************************************************/

byte bClick; /*
* Description : wird von der Timer-ISR gesetzt
*/

word wAdc0; /*
* Description : beinhaltet Analogwert
*/

word wAdc1; /*
* Description : 
*/

byte bJA;

/***************************************************************************
*    lokale Funktionsprototypen fr Funktionspointerliste                  *
****************************************************************************/
void vMessage( void );


/***************************************************************************
*    Funktion: Hardware-Initialisierung (Application Builder)              *
*                                                                          *
*    Autor:    Jens Altenburg                                              *
****************************************************************************/
void vClockInit( void ){
     word w;
     // DCOCTL  = 0x00;
     WDTCTL = WDTPW + WDTHOLD;     /* Watchdog deaktivieren */
#if 1
     P5DIR |= 0x10;                /* 8MHz-CLK am Pin 48 */
     P5SEL |= 0x10;
     P5DIR |= 0x20;                /* SMCLK an Pin 49 */
     P5SEL |= 0x20;
#endif
     BCSCTL1 &= ~XT2OFF;           /* Oszillator on */
     do  {
          IFG1 &= ~OFIFG;
          for(w = 0xff; w > 0; w--);
          }
     while((IFG1 & OFIFG) != 0);
     BCSCTL2 = 0x88;
//     BCSCTL2 |= SELM1 + SELS + DIVS0;   /* nun los */
     }

void vPortInit( void ){
     P1OUT   = 0x00;               /* Schrittmotor 1 */
     P1DIR   = 0x7F;
     P1IES   = 0x00;
     P1IE    = 0x00;
     P1SEL   = 0x00;

     P2OUT   = 0xFF;               /* LEDs */
     P2DIR   = 0xFF;
     P2IES   = 0x00;
     P2IE    = 0x00;
     P2SEL   = 0x00;

     P3OUT   = 0x00;               /* UART0, P3.4 output */
     P3DIR   = 0x10;
     P3SEL   = 0x30;

     P4OUT   = 0xFE;               /* CFG - Port */
     P4DIR   = 0x7f;
     P4SEL   = 0x00;
#if 0
     P5OUT   = 0x00;               /* not used */
     P5DIR   = 0x00;
     P5SEL   = 0x00;
#endif
     P6OUT   = 0x00;               /* not used */
     P6DIR   = 0x00;
     P6SEL   = 0x03;			   /* A/D-Wandler */
     }


void vTimeraInit( void ){
     TACTL = TASSEL1 + TACLR;      /* SMCLK, clear TAR */
     CCTL0 = CCIE;                 /* CCR0 interrupt enable */
     CCR0 = 20000;                 /* 2,5 ms Timer Click */
     TACTL |= MC0;                 /* Up-Mode */
     }


void vAdc12Init( void ){
	 ADC12CTL0  = ADC12ON + MSC + SHT0_8;
	 ADC12CTL1  = SHP + CONSEQ_3;
	 ADC12MCTL0 = INCH_0;
	 ADC12MCTL1 = INCH_1 + EOS;
	 ADC12IE    = 0x02;
	 ADC12CTL0 |= ENC;
#if 0
 	 ADC12CTL0  = 0x00;
 	 ADC12CTL1  = 0xF6;//ADC12DIV.2,ADC12DIV.1,ADC12DIV.0,ADC12SSEL.1,CONSEQ.1,CONSEQ.0
 	 ADC12IE    = 0x00;
 	 ADC12MCTL0 = 0x00;            /* A/D-Kanal 0 */
	 ADC12MCTL1 = 0x01;
	 ADC12CTL0  = 0x12;//ADC12ON,ADC12ENC
#endif
	 }


//call this routine to initialise all peripherals
void vInitDevices( void ){
     DINT();                       /* disable all interrupts */
//   ME1     = 0x00;               /* disable sfr peripherals */
//   ME2     = 0x00;               /* disable sfr peripherals */
//   IE1     = 0x00;               /* disable sfr interrupts */
//   IE2     = 0x00;               /* disable sfr interrupts */

//   WDTCTL  = 0x5A | 0x15;        /* watchdog initialisation including nmi function */

     vClockInit();                 /* initialise other peripherals */
     vPortInit();
     vTimeraInit();
	 vAdc12Init();

//   ME1     = 0xC0;               /* enable sfr peripherals */
//   ME2     = 0x00;               /* enable sfr peripherals */
//   IE1     = 0xC0;               /* enable sfr interrupts */
//   IE2     = 0x03;               /* disable sfr interrupts */
//   EINT();                       /* re-enable interrupts */
     }





/***************************************************************************
*    Funktion: Benachrichtigungsfunktion                                   *
*    Autor:    Jens Altenburg                                              *
****************************************************************************/
void vMessage( void ){
	 bClick = 1;     
	 }


/***************************************************************************
*    Main-Loop                                                             *
*    - initialisiert Module und Variable                                   *
*    - die stndig gerufenen Funktionen stehen in der Auftragsliste        *
*
****************************************************************************/
int main(void){
     byte i;
     word w = 0;
     int32 iSteps;
	 bClick = 0;
	 vInitDevices();
     SMD_vInit();
	 EINT();
	 ADC12CTL0 |= ADC12SC;            /* A/D-Wandler starten */ 
	 bClick = 1;
	 while(1){
	       if(bClick == 1){
 		        bClick = 0;
				while(P6IN & 0x80);   /* Taste abfragen */ 
				while(!(P6IN & 0x80));
				w = wAdc0 * 14;	   	  /* Motorgeschwindigkeit */
				iSteps = (int32)wAdc1 - 0x800; /* Drehrichtung, Schrittzahl */
				SMD_vStart ( vMessage, /* Benachrichtigung */
                  		   1,          /* Halbschritt */
                  		   w,          /* Maximalgeschwindigkeit */
                  		   iSteps      /* Schrittzahl, Vorzeichen = Drehrichtung */
                		   );		         
				}
		   }
	 return 1;                     	   /* unterdrckt Compilerwarnung */
     }


#pragma interrupt_handler timera_0_isr:TIMERA0_VECTOR
void timera_0_isr(void){
	 word w;
	 w = SMD_wMove();
     CCR0 = w;
     P2OUT ^= 0x80;	 	  /* P2.7 toggelt im Motortakt */
	 }

#pragma interrupt_handler adc12_isr:ADC_VECTOR
void adc12_isr(void){
	 wAdc0 = ADC12MEM0;
	 wAdc1 = ADC12MEM1;
	 }


/***************************************************************************
* EOF: UNI1.C
****************************************************************************/

