// Demonstriert mit dem UI-Thread synchronisierte Aufrufe aus 
// dem Hintergrund ber Control.Invoke()
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading; 

namespace InvokeControlDemo
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.TextBox textBox1;
		private System.ComponentModel.IContainer components;

		public Form1()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.button1 = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(8, 24);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(272, 32);
			this.button1.TabIndex = 0;
			this.button1.Text = "Starte ThreadPool-Thread";
			this.toolTip1.SetToolTip(this.button1, "startet Thread, der Invoke des Formulars ausfhrt");
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(8, 80);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.Size = new System.Drawing.Size(272, 176);
			this.textBox1.TabIndex = 1;
			this.textBox1.Text = "";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 270);
			this.Controls.Add(this.textBox1);
			this.Controls.Add(this.button1);
			this.Name = "Form1";
			this.Text = "Invoke - Control";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}


		string CRLF = "\r\n";

		// Worker Thread
		private void Worker(object o)
		{
				object[] args = new object[2] { 2, "gaga" };

			textBox1.AppendText("Worker ThreadID :" + AppDomain.GetCurrentThreadId().ToString()+CRLF); 
			// Synchroner Rckruf. Thread hngt hier bis zum Abschluss fest
			textBox1.AppendText(this.Invoke(new SynchDelegate(InvokeMethod))+CRLF);
			textBox1.AppendText("Worker: Rckmeldung erst nach Ende von Invoke()"+CRLF); 

			this.Invoke(new Sync2Del(Sync2), args);
			this.Invoke(new Sync2Del(Sync2), new object[2] { 4, "gaga" });
		}

		private delegate string Sync2Del(int x, string s);

		private string Sync2(int x, string s)
		{
			 return "gaga";
		}

	
		// Delegat fr Methode, die mit BeginInvoke ausgefhrt wird
		private delegate string SynchDelegate(); 

		// wird von Threadpool-Thread im Kontext des Haupt-Threads (synchronisiert) aufgerufen
		private string InvokeMethod()
		{
			textBox1.AppendText("InvokeMethod ThreadID :" + 
				  AppDomain.GetCurrentThreadId().ToString() + CRLF); 
			MessageBox.Show("InvokeMethod: synchronisierter Aufruf", "InvokeMethod"); 
			return "InvokeMethod: Fertig"; 
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			textBox1.AppendText("button1_Click: Haupt-ThreadID :" + 
				  AppDomain.GetCurrentThreadId().ToString() + CRLF); 
			ThreadPool.QueueUserWorkItem(new WaitCallback(Worker)); 
		}
	}
}
