// AsyncThread.cs - IAsyncResult-Implementation
//                  veranlasst den asynchronen Aufruf einer Methode
//                  mit generischem Prototyp als originrer Thread
using System;
using System.Threading; 

namespace AsyncClass
{
  public delegate object WorkDelegate (object o); 
  public class AsyncThread : IAsyncResult
  {
    private delegate void ReadyDelegate(object result); 
    private object asyncState; 
    private bool compl = false;
    public bool complSync = false;
    private ManualResetEvent wh; 
    public object AsyncResult; 
    private AsyncCallback clientCB; 

    // Hilfsklasse, verkapselt Parameter und Rckgabewert der
    // asynchron auszufhrenden Routine und startet diese gleich bei 
    // Konstruktion als Thread
    private class ThreadClass
    {
      private object param; 
      private WorkDelegate work; 
      private ReadyDelegate readyCB; 
      public ThreadClass(object _param, WorkDelegate _work,
                         ReadyDelegate _readyCB)
      {
        param = _param; 
        work = _work; 
        readyCB = _readyCB; 
        new Thread(new ThreadStart(exec)).Start(); 
      }
      // work-Routine ausfhren und Thread-Ende melden
      public void exec()
      {
        readyCB(work(param));
      }
    }

    // Konstruktor startet Thread durch Instanziierung von ThreadClass
    public AsyncThread(WorkDelegate worker, object param,
                       AsyncCallback _clientCB, object userData)
    {
      asyncState = userData;  // Daten fr Rckrufroutine des Clients
      clientCB = _clientCB; 
      wh = new ManualResetEvent(false); 
      ThreadClass Thd = new ThreadClass(param, worker, 
        new ReadyDelegate(ReadyCB)); 
    }

    // ruft Client zurck (asynchroner Vorgang)
    private void ReadyCB(object result)
    {
      AsyncResult = result; 
      compl = true; 
      wh.Set(); 
      if (clientCB != null)  
        clientCB(this); 
    }

    // Implementation der Schnittstelle
    public object AsyncState           { get { return asyncState; }}
    public bool IsCompleted            { get { return compl; }}
    public bool CompletedSynchronously { get { return complSync; }}
    public WaitHandle AsyncWaitHandle  { get { return wh; }}
  }
}
