// WaitOneDemo -- Demoprogramm fr Eventobjekte.
// -- Erster Thread wartet mit Timeout 5s auf Signalisierung durch 2. Thread
// -- Verwendung von Symbol WITHLOCK demonstriert, dass zweiter Thread 
//    durch lock() von erstem Thread ausgesperrt wird, bis timeout abgelaufen!
// -- WaitOne() gibt lock also nicht frei! D.h., es hilft nichts, Event-Objekt als
//    Synchronisationsobjekt fr lock() zu verwenden. 

//#define WITHLOCK
using System;
using System.Threading;

namespace WaitOneDemo
{
	class Class1
	{
		[STAThread]
		static void Main(string[] args)
		{
      Console.WriteLine("Starting first ThreadPool-Thread. Waits 5s to be signalled from 2nd");
      ThreadPool.QueueUserWorkItem(new WaitCallback(Exec1));
      Console.WriteLine("Press Enter to start second ThreadPool-Thread");
      Console.ReadLine();
			ThreadPool.QueueUserWorkItem(new WaitCallback(Exec2));
			Console.ReadLine();
		}

		static AutoResetEvent MyEvt = new AutoResetEvent(false);
		static void Exec1(object state)
		{
			lock(MyEvt)   // dieses Lock kann Erlsenden Thread aussperren und ist eigentlich unntig
                    // da die Synchronisation ja durch das Event-Objekt passiert
			{
				Console.WriteLine("Exec1: lock acquired ... waiting for signal");
				if (MyEvt.WaitOne(5000, true))
					Console.WriteLine("Exec1: signalled ... continuing");
				else 
					Console.WriteLine("Exec1: Timeout");
        Console.WriteLine("Exec1: release lock");
      }
		}

		static void Exec2(object state)
		{
#if WITHLOCK  
			Console.WriteLine("Exec2: trying to acquire lock");
      lock(MyEvt)   // verhindert die Erlsung des ersten Threads!
			{
				Console.WriteLine("Exec2: lock acquired");
				MyEvt.Set();
				Console.WriteLine("Exec2: Signal set");				
        Console.WriteLine("Exec2: release lock");
      }
#else
      MyEvt.Set();
      Console.WriteLine("Exec2: Signal set");				
#endif
    }

	}
}
