// Methodenimplementationsattributsdemonstrationsprogramm ;-)
// -- MethodImplOptions.Synchronized rahmt einzelne Methode mit 
//    Critical Section ein und macht sie so threadsicher.
// -- Asynchrone Timerthreads fhren die Methode (trotz Sleep) brav nacheinander aus,
//    erkennbar an der Ausgabe.

using System;
using System.Threading;
using System.Runtime.CompilerServices;

namespace SyncAttribute
{
	class Class1
	{
		[STAThread]
		static void Main(string[] args)
		{ 
			Timer t1 = new Timer(new TimerCallback(MySyncMethod), "Eins", 0, 350);
			Timer t2 = new Timer(new TimerCallback(MySyncMethod), "Zwei", 0, 350);
			Console.ReadLine();
		}

		static string MyObj;
		
    // Threadsichere Methode
    [MethodImpl(MethodImplOptions.Synchronized)]
		public static void MySyncMethod(object Context)
		{ 
			Console.Write(Context + ": Enter ");
			MyObj = (string)Context;
			Thread.Sleep(300);
			// Trotz Sleep DARF der andere Thread mittlerweile nicht zum Zuge
			// gekommen sein und MyObj verndert haben. Nachprfung...
			if (MyObj != (string)Context)
				throw new Exception("Synchronisation error!");
			Console.WriteLine(Context + ": Exit");
		}
	}
}
