// SemaDemoForm.CS - Implementation und Demo einer Semaphoren-Klasse
// Logik: 
//   -- Instanz von Semaphore wird mit dem Wert 2 angelegt
//   -- Button-Klicks legen neue Threads an, die Semaphore fr 2 Sekunden in Besitz nehmen (wollen)
//   -- Sind 2 Threads im Besitz der Semaphore, mssen weitere auf Freigabe warten.
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace SemaDemo
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button bNewThread;
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.Label label1;
		private System.ComponentModel.IContainer components;
    // Semphoreninstanz
    private Semaphore Sema = new Semaphore(2);

		public Form1()
		{
			InitializeComponent();
			this.toolTip1.SetToolTip(this.bNewThread,"Each new thread decrements sema count by one");
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.bNewThread = new System.Windows.Forms.Button();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.label1 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// bNewThread
			// 
			this.bNewThread.Location = new System.Drawing.Point(8, 16);
			this.bNewThread.Name = "bNewThread";
			this.bNewThread.Size = new System.Drawing.Size(80, 23);
			this.bNewThread.TabIndex = 0;
			this.bNewThread.Text = "bNewThread";
			this.bNewThread.Click += new System.EventHandler(this.bNewThread_Click);
			// 
			// listBox1
			// 
			this.listBox1.Location = new System.Drawing.Point(8, 64);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(200, 212);
			this.listBox1.TabIndex = 1;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(104, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(112, 48);
			this.label1.TabIndex = 2;
			this.label1.Text = "Semaphore Count: 2 Click three times or more";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(224, 293);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.listBox1);
			this.Controls.Add(this.bNewThread);
			this.Name = "Form1";
			this.Text = "Semaphore Demo";
			this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

    // unterscheidet die Threads in Meldungen
		private int GlobalThreadID;  
		private void Log(int ThreadID, string Msg)
		{
			listBox1.Items.Add(ThreadID.ToString()+ ": "+ Msg);
		}

    // Fordert die Semaphore an, behlt sie 2 Sekunden,
		// gibt sie wieder ab, und endet dann
		private void ThreadProc()
		{ int LocalThreadID = GlobalThreadID;
			DateTime STime = DateTime.Now;
			Log(LocalThreadID, "Waiting");
			Sema.WaitOne();
			Log(LocalThreadID, "Acquired after (ms) "+ 	
				(DateTime.Now - STime).TotalMilliseconds.ToString());
			Thread.Sleep(2000);
			Sema.ReleaseSemaphore();
			Log(LocalThreadID, "Released");
		}

		private void bNewThread_Click(object sender, System.EventArgs e)
		{ 
			GlobalThreadID++;
			(new Thread(new ThreadStart(ThreadProc))).Start();
			Thread.Sleep(0);
		}
	}

	// Eine mgliche Implementation der Klasse Semaphore
	public class Semaphore
	{
		private int Count;
		public Semaphore(int _Count)
		{
			Count=_Count;
		}
		public void WaitOne()
		{
			lock(this)
			{
				while(Count==0)
				{
					Monitor.Wait(this);
				}
				Count--;
			}
		}
		public void ReleaseSemaphore()
		{
			lock(this)
			{
				Count++;
				Monitor.Pulse(this);
			}
		} 
	}
}
