using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace FinalizeCB
{
	


  public class Form1 : System.Windows.Forms.Form
  {
    private System.Windows.Forms.Button bCreateThread;
    private System.Windows.Forms.Button bEndThread;
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.Label lActiveThreads;
    private System.Windows.Forms.ListBox listBox1;
    private System.Windows.Forms.Button bAbort1000;
    private System.Windows.Forms.Button bTerminate1000;
    private System.Windows.Forms.Button bCreate1000;
    private System.ComponentModel.Container components = null;

    public Form1()
    {
      InitializeComponent();
    }

    protected override void Dispose( bool disposing )
    {
      if( disposing )
      {
				
        if (components != null) 
        {
          components.Dispose();
        }
      }
      base.Dispose( disposing );
    }

		#region Vom Windows Form-Designer generierter Code
    /// <summary>
    /// Erforderliche Methode fr die Designeruntersttzung. 
    /// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
    /// </summary>
    private void InitializeComponent()
    {
      this.bCreateThread = new System.Windows.Forms.Button();
      this.bEndThread = new System.Windows.Forms.Button();
      this.label1 = new System.Windows.Forms.Label();
      this.lActiveThreads = new System.Windows.Forms.Label();
      this.listBox1 = new System.Windows.Forms.ListBox();
      this.bCreate1000 = new System.Windows.Forms.Button();
      this.bAbort1000 = new System.Windows.Forms.Button();
      this.bTerminate1000 = new System.Windows.Forms.Button();
      this.SuspendLayout();
      // 
      // bCreateThread
      // 
      this.bCreateThread.Location = new System.Drawing.Point(24, 24);
      this.bCreateThread.Name = "bCreateThread";
      this.bCreateThread.Size = new System.Drawing.Size(104, 23);
      this.bCreateThread.TabIndex = 0;
      this.bCreateThread.Text = "bCreate 1 Thread";
      this.bCreateThread.Click += new System.EventHandler(this.bCreateThread_Click);
      // 
      // bEndThread
      // 
      this.bEndThread.Location = new System.Drawing.Point(152, 24);
      this.bEndThread.Name = "bEndThread";
      this.bEndThread.Size = new System.Drawing.Size(96, 23);
      this.bEndThread.TabIndex = 1;
      this.bEndThread.Text = "bEnd 1 Thread";
      this.bEndThread.Click += new System.EventHandler(this.bEndThread_Click);
      // 
      // label1
      // 
      this.label1.Location = new System.Drawing.Point(40, 64);
      this.label1.Name = "label1";
      this.label1.TabIndex = 2;
      this.label1.Text = "Active Threads:";
      // 
      // lActiveThreads
      // 
      this.lActiveThreads.Location = new System.Drawing.Point(160, 64);
      this.lActiveThreads.Name = "lActiveThreads";
      this.lActiveThreads.TabIndex = 3;
      this.lActiveThreads.Text = "0";
      // 
      // listBox1
      // 
      this.listBox1.Location = new System.Drawing.Point(32, 112);
      this.listBox1.Name = "listBox1";
      this.listBox1.Size = new System.Drawing.Size(232, 121);
      this.listBox1.TabIndex = 4;
      // 
      // bCreate1000
      // 
      this.bCreate1000.Location = new System.Drawing.Point(8, 256);
      this.bCreate1000.Name = "bCreate1000";
      this.bCreate1000.Size = new System.Drawing.Size(80, 23);
      this.bCreate1000.TabIndex = 5;
      this.bCreate1000.Text = "bCreate1000";
      this.bCreate1000.Click += new System.EventHandler(this.bCreate1000_Click);
      // 
      // bAbort1000
      // 
      this.bAbort1000.Location = new System.Drawing.Point(104, 256);
      this.bAbort1000.Name = "bAbort1000";
      this.bAbort1000.TabIndex = 6;
      this.bAbort1000.Text = "bAbort1000";
      this.bAbort1000.Click += new System.EventHandler(this.bAbort1000_Click);
      // 
      // bTerminate1000
      // 
      this.bTerminate1000.Location = new System.Drawing.Point(208, 256);
      this.bTerminate1000.Name = "bTerminate1000";
      this.bTerminate1000.TabIndex = 7;
      this.bTerminate1000.Text = "bTerminate1000";
      this.bTerminate1000.Click += new System.EventHandler(this.bTerminate1000_Click);
      // 
      // Form1
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(292, 301);
      this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                  this.bTerminate1000,
                                                                  this.bAbort1000,
                                                                  this.bCreate1000,
                                                                  this.listBox1,
                                                                  this.lActiveThreads,
                                                                  this.label1,
                                                                  this.bCreateThread,
                                                                  this.bEndThread});
      this.Name = "Form1";
      this.Text = "Thread.OnTerminate";
      this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
      this.Closed += new System.EventHandler(this.Form1_Closed);
      this.ResumeLayout(false);

    }
		#endregion

    [STAThread]
    static void Main() 
    {
      Application.Run(new Form1());
    }

    ArrayList ActiveThreads = new ArrayList();
    int ThreadIDCounter;

    private void bCreateThread_Click(object sender, System.EventArgs e)
    {
      MyThread NewThread = new MyThread();
      // MyThreadSync NewThread = new MyThreadSync(this);

      NewThread.OnWork = new ThreadCB(OnThreadWork);
      NewThread.Terminating += new ThreadCB(OnThreadTerminateSync);
      NewThread.SomeValue = ++ThreadIDCounter;
      NewThread.Suspended = false;
      lock(ActiveThreads)
      {
        ActiveThreads.Add(NewThread);
        lActiveThreads.Text = ActiveThreads.Count.ToString();
      }
    }

    private void OnThreadWorkSync(BaseThread Sender)
    {
        MyThread CurThread = (MyThread)Sender;

      listBox1.Items.Add("BG Thread: "+CurThread.SomeValue.ToString());
    }

    private void OnThreadWork(BaseThread Sender)
    {
        ThreadCB OnTWS = new ThreadCB(OnThreadWorkSync);

      this.Invoke(OnTWS, new object[] { Sender });
    }


    private void OnThreadTerminate(BaseThread Sender)
    {
      Invoke(new ThreadCB(OnThreadTerminateSync), new object[] { Sender });
    }

    private void OnThreadTerminateSync(BaseThread Sender)
    {
        MyThread CurThread;

      lock(ActiveThreads)
      { 
        CurThread = (MyThread)Sender;
        listBox1.Items.Add("Removing Thread "+CurThread.SomeValue.ToString());
        ActiveThreads.Remove(Sender);	
        lActiveThreads.Text = ActiveThreads.Count.ToString();
      }
    }

    private void bEndThread_Click(object sender, System.EventArgs e)
    {
        MyThread CurThread;

      lock(ActiveThreads)
      {
        for (int x = 0; x < ActiveThreads.Count; x++)
        {
          CurThread = (MyThread)ActiveThreads[x];
          if (!CurThread.Terminated)
          {
            listBox1.Items.Add("Terminating Thread "+CurThread.SomeValue.ToString());						
            CurThread.Terminate();
            break;
          }
        }
      }
    }

    private void Form1_Closed(object sender, System.EventArgs e)
    {
      // MessageBox.Show("Closed");
    }

    private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
    {
      // Threads erschlagen
      lock(ActiveThreads)
      {
        for (int x = 0; x < ActiveThreads.Count; x++)
          ((BaseThread)ActiveThreads[x]).Terminate();
      }	
    }

    private void bCreate1000_Click(object sender, System.EventArgs e)
    {
        MyThread NewThread;
      for (int x = 0; x < 1000; x++)
      {
        NewThread = new MyThread();
        NewThread.Suspended = false;
        lock(ActiveThreads)
        {
          ActiveThreads.Add(NewThread);
        }
      }
		
      lActiveThreads.Text = ActiveThreads.Count.ToString();		  
    }

    private void bAbort1000_Click(object sender, System.EventArgs e)
    {
        MyThread CurThread;
		
      for (int x = 0; x < ActiveThreads.Count; x++)
      {
        CurThread = (MyThread)ActiveThreads[x];
        CurThread.Abort();
      }

      lock(ActiveThreads)
      {
        ActiveThreads.Clear();
      }
      lActiveThreads.Text = ActiveThreads.Count.ToString();		  
    }

    private void bTerminate1000_Click(object sender, System.EventArgs e)
    {
      MyThread CurThread;
      for (int x = 0; x < ActiveThreads.Count; x++)
      {
        CurThread = (MyThread)ActiveThreads[x];
        CurThread.Terminate();
      }

      lock(ActiveThreads)
      {
        ActiveThreads.Clear();
      }
      lActiveThreads.Text = ActiveThreads.Count.ToString();		  
    }
    public class MyThread : BaseThread
    {
      public int SomeValue;
      public ThreadCB OnWork;

      public MyThread() : base(true){} 

      protected override void Execute()
      {
        try
        {
          while (!Terminated)
          {
            Thread.Sleep(2000);
            if (OnWork != null)
              OnWork(this);
          }
        }
        finally
        {
          //Aufrumcode, falls erforderlich
        }
      }
    }

    public class MyThreadSync : MyThread
    {
      Control ClientControl; 
      public MyThreadSync(Control cc) 
      { ClientControl = cc; }
 
      // synchronisierter Aufruf 
      protected override void OnTerminate(BaseThread sender)
      {
        ClientControl.Invoke(new ThreadCB(Frame), 
          new object[] {sender});
      }
      // muss leider sein, weil base.OnTerminate direkt nicht funzt 
      void Frame(BaseThread sender)
      {
        base.OnTerminate(sender);
      }
    }
  }
}

