#!/bin/sh
#########################################################################
# LIDS Config Skript
# Autor: Benjamin Benz
# Getestet Auf SuSE 9.0 Pro
# Achtung mit LIDS geben manche der SuSE Startskripte beim booten "failed" 
# aus, obwohl die Dienste laufen.
# rc_status aus /etc/rc.status arbeitet nicht korrekt, wenn lids lauft.
#
# Nicht vergessen nach Abschluss des Bootprozesses als letztes Program in 
# z.B. /etc/rc.d/rc3.d ein skript zu starten, das lidsadm -I aufruft.
#########################################################################

# Switches to turn on/off features of this script
USE_LOGIN=yes		# Login Binary
USE_GETTY=yes		# Local Login	
USE_SSH=yes		# SSH-Server for remote Login
USE_SU=yes		# SU - Switch User command
USE_CRON=yes		# Cron Server
USE_DHCPCLIENT=yes	# Get Dynamic IP
USE_APACHE=yes		# Apache Webserver
USE_SAMBA=yes		# Samba Fileserver
USE_NAMED=yes		# Bind Nameserver
USE_INETD=yes		# Inet- Super Server
USE_POP3=yes		# Pop3 Server
USE_IMAP=yes		# IMAP Server
USE_SCANLOG=yes		# Port Scan Detector
USE_FTP=yes		# FTP Server
USE_POSTFIX=yes		# Mailserver
USE_X11=no		# X-Server (No KDE!)

###########################################################################
### 1. Declarations
###########################################################################
LIDS=/sbin/lidsconf			# lidsconf-Binary

# Bootmanager
BOOTMANAGER_CONF=/etc/grub.conf		# if you use grub
#BOOTMANAGER_CONF=/etc/lilo.conf	# if You use lilo

# Crom daemn
CRON=/usr/sbin/cron			# Binary to cron deamn
CRON_CONF=/etc/crontab			# Conf for cron deamn

# Apache Webserver stuff
APACHE=/usr/sbin/httpd			# The apache binary
APACHE_ROOT=/srv/www			# Path to Server root
APACHE_CONF=/etc/httpd			# Path to apache conf files
APACHE_LOG=/var/log/httpd		# Path to apache log files
APACHE_START=/usr/sbin/rcapache		# At SuSE 9.0 the startscript produces logs, too
APACHE_LIB=/var/lib/httpd		# At SuSE 9.0 this is the place where semaphores are beeing created

# SSH Server
SSH=/usr/sbin/sshd			# SSH-Server Binary
SSH_CONF=/etc/ssh			# config of ssh-server

# Samba Fileserver
SMBD=/usr/sbin/smbd			# Samba binary 1
NMBD=/usr/sbin/nmbd			# Samba binary 2
SAMBA_CONF=/etc/samba			# Samba Config
SAMBA_RUN=/var/run/samba		# Samba Runtime logs
SAMBA_VAR=/var/lib/samba		# Samba Runtime data

# Nameserver (DNS)
NAMED=/usr/sbin/named			# Bind Nameserver Binary
NAMED_CONF=/etc/named.conf		# Main Config File of Named
NAMED_CONF_2=/etc/named.conf.include	# SuSE specific includes
NAMED_CONF_3=/etc/named.d		# SuSE specific includes
NAMED_ZONES=/var/lib/named		# Zone Files of named

# Inet Super Server
INETD=/usr/sbin/xinetd			# inetd- Binary
INETD_CONF=/etc/xinetd.conf		# main config
INETD_CONF_2=/etc/xinetd.d		# SuSE addon config
	
# Postfix Mailserver
POSTFIX=/usr/sbin/postfix		# Postfix Binary
POSTFIX_MASTER=/usr/lib/postfix/master	# Postfix Master-Process Binary
POSTFIX_DROP=/usr/sbin/postdrop		# Postfix Postdrop Binary
POSTFIX_CONF=/etc/postfix		# Postfix config
POSTFIX_SPOOL=/var/spool/postfix	# Postfix Spool

# Some more Programs
MINGETTY=/sbin/mingetty			# Local Login
LOGIN=/bin/login			# Login Binary
SU=/bin/su				# SU Binary
DHCPCLIENT=/sbin/dhcpcd			# DHCP-Client
SYSLOGD=/sbin/syslogd			# Syslogd Binary
KLOGD=/sbin/klogd			# Klogd Binary
POP3D=/usr/sbin/ipop3d			# POP3 Server binary
IMAPD=/usr/sbin/imapd			# POP3 Server binary
SCANLOGD=/usr/sbin/scanlogd		# Scanlogd Binary
FTPD=/usr/sbin/vsftpd			# FTP Server Binary
XSERVER=/usr/X11R6/bin/X		# Binary of the X-Server


###########################################################################
echo "### Cleanig old lids.conf"
###########################################################################
$LIDS -Z
$LIDS -Z BOOT
$LIDS -Z POSTBOOT
$LIDS -Z SHUTDOWN

###########################################################################
echo "### Protect LIDS itself"
###########################################################################
$LIDS -A -o /etc/lids                   -j DENY

###########################################################################
echo "### Protect binaries and libraries"
###########################################################################
$LIDS -A -o /bin                        	-j READONLY	# Binaries
$LIDS -A -o /usr/bin                   	 	-j READONLY		
$LIDS -A -o /usr/local/bin              	-j READONLY		

$LIDS -A -o /sbin                       	-j READONLY	# Superuser Binaries
$LIDS -A -o /usr/sbin                   	-j READONLY		
$LIDS -A -o /usr/local/sbin             	-j READONLY	

$LIDS -A -o /usr/X11R6/bin			-j READONLY	# X11 Binaries

$LIDS -A -o /lib                        	-j READONLY	# Libraries
$LIDS -A -o /usr/lib                    	-j READONLY		
$LIDS -A -o /usr/local/lib              	-j READONLY		

$LIDS -A -o /etc/init.d				-j READONLY	# Protect Start scripts
$LIDS -A -o /etc/sysconfig/network/scripts 	-j READONLY	

$LIDS -A -o /boot           			-j READONLY	# Protect the Kernelfiles


###########################################################################
echo "### Protecting System Configuration files"
###########################################################################

$LIDS -A -o /etc/shadow                         -j DENY
$LIDS -A -o $BOOTMANAGER_CONF                   -j DENY

# Protect root's home dir, but allow bash history
$LIDS -A -o /root                               -j READONLY
$LIDS -A -s /bin/bash -o /root/.bash_history    -j WRITE

###########################################################################
echo "### Protect Logs "
###########################################################################
$LIDS -A POSTBOOT -o /var/log                   -j APPEND

###########################################################################
echo "### Allow Startup/Shutdown of System"
###########################################################################

# Startup
$LIDS -A BOOT -o /etc/adjtime       			-j READONLY
$LIDS -A BOOT -s /sbin/hwclock -o /etc/adjtime  	-j WRITE

# Shutdown
$LIDS -A SHUTDOWN -s /sbin/init -o CAP_KILL_PROTECTED   -j GRANT
$LIDS -A SHUTDOWN -s /sbin/init -o CAP_KILL             -j GRANT

# Give the following init script the proper privileges to kill processes and
# unmount the file systems.  However, anyone who can execute these scripts
# by themselves can effectively kill your processes.  It's better than
# the alternative, however.
$LIDS -A SHUTDOWN -s /etc/rc.d/halt -o CAP_KILL_PROTECTED	-i 1 -j GRANT
$LIDS -A SHUTDOWN -s /etc/rc.d/halt -o CAP_KILL 		-i 1 -j GRANT
$LIDS -A SHUTDOWN -s /etc/rc.d/halt -o CAP_NET_ADMIN 		-i 1 -j GRANT
$LIDS -A SHUTDOWN -s /etc/rc.d/halt -o CAP_SYS_ADMIN 		-i 1 -j GRANT

$LIDS -A POSTBOOT -s /sbin/init -o /var/log/wtmp         	-j WRITE
$LIDS -A POSTBOOT -s /sbin/init -o /var/log/lastlog      	-j WRITE
$LIDS -A POSTBOOT -s /sbin/halt -o /var/log/wtmp         	-j WRITE
$LIDS -A POSTBOOT -s /sbin/halt -o /var/log/lastlog      	-j WRITE

###########################################################################
echo "### Take care of some programms"
###########################################################################

# Enable system authentication
if [ "$USE_LOGIN" = yes ]; then
	echo "# Login-Binary"
	$LIDS -A -s $LOGIN -o /etc/shadow           	-j READONLY
	$LIDS -A -s $LOGIN -o CAP_SETGID            	-j GRANT
	$LIDS -A -s $LOGIN -o CAP_FSETID            	-j GRANT
	$LIDS -A -s $LOGIN -o CAP_SYS_TTY_CONFIG       	-j GRANT
	$LIDS -A -s $LOGIN -o CAP_CHOWN 	     	-j GRANT
	$LIDS -A -s $LOGIN -o CAP_SETUID	      	-j GRANT
	$LIDS -A -s $LOGIN -o CAP_FOWNER	    	-j GRANT
	$LIDS -A POSTBOOT -s $LOGIN -o /var/log/wtmp    -j WRITE
	$LIDS -A POSTBOOT -s $LOGIN -o /var/log/lastlog -j WRITE
fi

# Enable the Getty (Login in on local Terminal
if [ "$USE_GETTY" = yes ]; then
	echo "# Getty-Terminal Login"
	$LIDS -A -s $MINGETTY -o CAP_SYS_TTY_CONFIG 	-j GRANT
	$LIDS -A -s $MINGETTY -o CAP_FSETID            	-j GRANT
	$LIDS -A -s $MINGETTY -o CAP_CHOWN	 	-j GRANT
fi

# Enable the SSH-Login
if [ "$USE_SSH" = yes ]; then
	echo "# SSH-Server"
	$LIDS -A POSTBOOT -o $SSH_CONF 			-j DENY	
	$LIDS -A POSTBOOT -s $SSH -o $SSH_CONF 		-j READONLY	

	$LIDS -A -s $SSH -o /etc/shadow	 		-j READONLY
	$LIDS -A POSTBOOT -s $SSH -o /var/log/wtmp     	-j WRITE
	$LIDS -A POSTBOOT -s $SSH -o /var/log/lastlog  	-j WRITE

	$LIDS -A -s $SSH -o CAP_SETGID            	-j GRANT
	$LIDS -A -s $SSH -o CAP_SETUID            	-j GRANT
	$LIDS -A -s $SSH -o CAP_SYS_TTY_CONFIG       	-j GRANT
	$LIDS -A -s $SSH -o CAP_FOWNER		       	-j GRANT
	$LIDS -A -s $SSH -o CAP_CHOWN		       	-j GRANT
	$LIDS -A -s $SSH -o CAP_NET_BIND_SERVICE 22    	-j GRANT
	$LIDS -A -s $SSH -o CAP_SYS_CHROOT       	-j GRANT
	$LIDS -A -s $SSH -o CAP_SYS_RESOURCE       	-j GRANT
	$LIDS -A -s $SSH -o CAP_DAC_OVERRIDE       	-j GRANT
	
	$LIDS -A -s $SSH -o CAP_HIDDEN			-j GRANT	# Hide sshd from ps table
	
fi

# Ennable su command
if [ "$USE_SU" = yes ]; then
	echo "# SU-Command"
	$LIDS -A -s $SU -o /etc/shadow              	-j READONLY
	$LIDS -A -s $SU -o CAP_SETUID               	-j GRANT
	$LIDS -A -s $SU -o CAP_SETGID               	-j GRANT
fi

# CRON
if [ "$USE_CRON" = yes ]; then
	echo "# CRON"
	$LIDS -A -s $CRON -o CAP_SETUID				-j GRANT	# Allow Cron to setuid
	$LIDS -A -s $CRON -o CAP_SETGID				-j GRANT	# Allow Cron to setgid

	$LIDS -A -s $CRON -o CAP_HIDDEN -i -1			-j GRANT	# Hide Cron from ps table

	$LIDS -A POSTBOOT -o $CRON_CONF 			-j DENY		# protect crontab
	$LIDS -A POSTBOOT -s $CRON -o $CRON_CONF		-j READONLY	# allow cron to acces crontab

	$LIDS -A POSTBOOT -o /etc/cron.d 			-j DENY		# protect crontabs
	$LIDS -A POSTBOOT -s $CRON -o /etc/cron.d -i -1		-j READONLY	# allow cron to acces crontabs

	$LIDS -A POSTBOOT -o /etc/cron.daily 			-j DENY		# protect crontabs
	$LIDS -A POSTBOOT -s $CRON -o /etc/cron.daily -i -1	-j READONLY	# allow cron to acces crontabs

	$LIDS -A POSTBOOT -o /etc/cron.hourly			-j DENY		# protect crontabs
	$LIDS -A POSTBOOT -s $CRON -o /etc/cron.hourly -i -1	-j READONLY	# allow cron to acces crontabs

	$LIDS -A POSTBOOT -o /etc/cron.monthly			-j DENY		# protect crontabs
	$LIDS -A POSTBOOT -s $CRON -o /etc/cron.monthly -i -1	-j READONLY	# allow cron to acces crontabs

	$LIDS -A POSTBOOT -o /etc/cron.weekly			-j DENY		# protect crontabs
	$LIDS -A POSTBOOT -s $CRON -o /etc/cron.weekly -i -1	-j READONLY	# allow cron to acces crontabs
fi

## Enable the DCHP-Client
if [ "$USE_DHCPCLIENT" = yes ]; then
	echo "# DCHP-Client"
	$LIDS -A -s $DHCPCLIENT -o CAP_NET_ADMIN 	-j GRANT
	$LIDS -A -s $DHCPCLIENT -o CAP_HIDDEN -i -1 	-j GRANT
fi


# Enable Apache
if [ "$USE_APACHE" = yes ]; then
	echo "# Apache - Webserver"
	# Config files
	$LIDS -A POSTBOOT -o $APACHE_CONF                       -j DENY
	$LIDS -A POSTBOOT -s $APACHE -o $APACHE_CONF            -j READONLY

	# Server Root
	$LIDS -A POSTBOOT -o $APACHE_ROOT                   	-j DENY
	$LIDS -A POSTBOOT -s $APACHE -o $APACHE_ROOT            -j READONLY

	# Log Files
	$LIDS -A POSTBOOT -s $APACHE -o $APACHE_LOG             -j APPEND
	$LIDS -A POSTBOOT -s $APACHE_START -o $APACHE_LOG	-j WRITE

	$LIDS -A POSTBOOT -o $APACHE_LIB			-j READONLY
	$LIDS -A POSTBOOT -s $APACHE -o $APACHE_LIB             -j WRITE
	$LIDS -A POSTBOOT -s $APACHE_START -o $APACHE_LIB	-j WRITE
	
	$LIDS -A -s $APACHE -o CAP_SETUID              		-j GRANT
	$LIDS -A -s $APACHE -o CAP_SETGID               	-j GRANT
	$LIDS -A -s $APACHE -o CAP_NET_BIND_SERVICE 80  	-j GRANT
	$LIDS -A -s $APACHE -o CAP_NET_BIND_SERVICE 443	 	-j GRANT
	$LIDS -A -s $APACHE -o CAP_KILL -i 5			-j GRANT

	$LIDS -A -s $APACHE -o CAP_HIDDEN -i -1			-j GRANT	# Hide Apache and its children
fi

# Samba-File-Server
if [ "$USE_SAMBA" = yes ]; then
	echo "# Samba"
	$LIDS -A POSTBOOT -o $SAMBA_CONF		-j DENY		# Protect config
	$LIDS -A POSTBOOT -o $SAMBA_RUN	 		-j READONLY	# Protect Runlogs

	$LIDS -A POSTBOOT -o $SAMBA_VAR 		-j DENY		# Protect runtime data
	$LIDS -A POSTBOOT -s $SMBD -o $SAMBA_VAR 	-j WRITE
	$LIDS -A POSTBOOT -s $NMBD -o $SAMBA_VAR 	-j WRITE
	
	
	$LIDS -A -s $SMBD -o /etc/shadow 		-j READONLY

	$LIDS -A POSTBOOT -s $SMBD -o $SAMBA_CONF 	-j WRITE	# Access to config
	$LIDS -A POSTBOOT -s $NMBD -o $SAMBA_CONF 	-j READONLY
	
	$LIDS -A -s $SMBD -o CAP_SETGID 		-j GRANT	# Hide Samba Server
	$LIDS -A -s $SMBD -o CAP_SETUID 		-j GRANT

	$LIDS -A -s $SMBD -o CAP_HIDDEN  		-j GRANT
	$LIDS -A -s $NMBD -o CAP_HIDDEN 		-j GRANT
	
fi


# Name-Server
if [ "$USE_NAMED" = yes ]; then
	echo "# Nameserver"
	$LIDS -A POSTBOOT -o $NAMED_CONF		-j DENY		# Protect config
	$LIDS -A POSTBOOT -o $NAMED_CONF_2		-j DENY	
	$LIDS -A POSTBOOT -o $NAMED_CONF_3		-j DENY
	$LIDS -A POSTBOOT -o $NAMED_ZONES		-j DENY

	$LIDS -A POSTBOOT -s $NAMED -o $NAMED_CONF	-j READONLY	# Access config
	$LIDS -A POSTBOOT -s $NAMED -o $NAMED_CONF_2	-j READONLY	
	$LIDS -A POSTBOOT -s $NAMED -o $NAMED_CONF_3	-j READONLY
	$LIDS -A POSTBOOT -s $NAMED -o $NAMED_ZONES	-j READONLY
	
	$LIDS -A POSTBOOT -s $NAMED -o CAP_HIDDEN 	-j GRANT	# Hide Nameserver
fi

# INETD
if [ "$USE_INETD" = yes ]; then
	echo "# INETD"
	$LIDS -A POSTBOOT -o $INETD_CONF		-j DENY		# Protect config
	$LIDS -A POSTBOOT -o $INETD_CONF_2		-j DENY	

	$LIDS -A POSTBOOT -s $INETD -o $INETD_CONF	-j READONLY	# Access config
	$LIDS -A POSTBOOT -s $INETD -o $INETD_CONF_2	-j READONLY	

	$LIDS -A -s $INETD -o CAP_SETGID		-j GRANT	
	$LIDS -A -s $INETD -o CAP_SETUID		-j GRANT
	$LIDS -A -s $INETD -o CAP_HIDDEN -i -1		-j GRANT	# Hide Inetd
fi

# pop3-Server
if [ "$USE_POP3" = yes ]; then
	echo "# Pop3-Server"
	$LIDS -A -s $POP3D -o /etc/shadow	 		-j READONLY
	$LIDS -A -s $POP3D -o CAP_SETGID	-j GRANT
	$LIDS -A -s $POP3D -o CAP_SETUID	-j GRANT	
fi

# imap-Server
if [ "$USE_IMAP" = yes ]; then
	echo "# IMAP-Server"
	$LIDS -A -s $IMAPD -o /etc/shadow	 		-j READONLY
	$LIDS -A -s $IMAPD -o CAP_SETGID	-j GRANT
	$LIDS -A -s $IMAPD -o CAP_SETUID	-j GRANT	
fi

#  FTP Server
if [ "$USE_FTP" = yes ]; then
	echo "# FTP-Server"
	$LIDS -A -s $FTPD -o /etc/shadow	-j READONLY
	$LIDS -A -s $FTPD -o CAP_SETGID		-j GRANT
	$LIDS -A -s $FTPD -o CAP_SETUID		-j GRANT	
	$LIDS -A -s $FTPD -o CAP_SYS_CHROOT	-j GRANT	
fi

# Scanlogd 
if [ "$USE_SCANLOG" = yes ]; then
	echo "# Scanlog"
	$LIDS -A -s $SCANLOGD -o CAP_HIDDEN 	-j GRANT
fi

# Postfix Mailserver
if [ "$USE_POSTFIX" = yes ]; then
	echo "# Postfix Mailserver"
	$LIDS -A POSTBOOT -o $POSTFIX_CONF 			-j DENY
	$LIDS -A POSTBOOT -o $POSTFIX_SPOOL 			-j DENY
	$LIDS -A POSTBOOT -o /etc/aliases.db 			-j READONLY

	$LIDS -A POSTBOOT -s $POSTFIX -o $POSTFIX_CONF 	 	-i 4	-j READONLY
	$LIDS -A POSTBOOT -s $POSTFIX -o $POSTFIX_SPOOL 	-i 4	-j WRITE

	$LIDS -A POSTBOOT -s $POSTFIX_MASTER -o $POSTFIX_CONF  	-i 4	-j READONLY
	$LIDS -A POSTBOOT -s $POSTFIX_MASTER -o $POSTFIX_SPOOL 	-i 4	-j WRITE
	$LIDS -A POSTBOOT -s $POSTFIX_MASTER -o /etc/aliases.db	-i 4	-j READONLY

	$LIDS -A POSTBOOT -s $POSTFIX_DROP -o $POSTFIX_CONF 	-j READONLY	
	$LIDS -A POSTBOOT -s $POSTFIX_DROP -o $POSTFIX_SPOOL 	-j WRITE	
	
	$LIDS -A -s $POSTFIX_MASTER -o CAP_SETGID	-i 1	-j GRANT
	$LIDS -A -s $POSTFIX_MASTER -o CAP_SETUID	-i 1 	-j GRANT	
	$LIDS -A -s $POSTFIX_MASTER -o CAP_DAC_OVERRIDE	-i 1	-j GRANT	
	$LIDS -A -s $POSTFIX_MASTER -o CAP_SYS_CHROOT	-i 1	-j GRANT	
	$LIDS -A -s $POSTFIX_MASTER -o CAP_KILL 		-j GRANT	
	$LIDS -A -s $POSTFIX_MASTER -o CAP_NET_BIND_SERVICE 25	-j GRANT	
	
	$LIDS -A -s $POSTFIX -o CAP_HIDDEN 		-i 1	-j GRANT	
	$LIDS -A -s $POSTFIX_MASTER -o CAP_HIDDEN 	-i 1	-j GRANT	
	$LIDS -A -s $POSTFIX_DROP -o CAP_HIDDEN 		-j GRANT	
	
fi


# X-Server
if [ "$USE_X11" = yes ]; then
	echo "# X-Server"
	$LIDS -A -s $XSERVER -o CAP_SYS_RAWIO 			-j GRANT
fi

###########################################################################
echo "### Protecting Config and Hide some System Progs"
###########################################################################

# Protect System Config
$LIDS -A POSTBOOT -o /etc               -j READONLY

# Hide Some System programs
$LIDS -A -s $SYSLOGD -o CAP_HIDDEN	-j GRANT		# Hide Syslogd from ps-table
$LIDS -A -s $KLOGD -o CAP_HIDDEN	-j GRANT		# Hide klogd from ps-table

###########################################################################
echo "### Protecting Software install directories"
###########################################################################

# Protect software
$LIDS -A POSTBOOT -o /usr                        -j READONLY
$LIDS -A POSTBOOT -o /opt                        -j READONLY

