<?php
/* Dieses Skript hat zwei Funktionen: Wenn es mit dem Parameter url
	aufgerufen wird, erzeugt es eine Playlist, die alle darin
	angegebenen Dateien als vollstndige URLs enthlt. Dazu dient
	der obere Teil.
	Ohne den Parameter erzeugt es ein ein Verzeichnis-Listing, in dem
	jede Datei so verlinkt ist, dass ein Klick ber den Aufruf des
	Skripts eine Playlist erzeugt.
*/

// Falls der Parameter url vorhanden ist..
if($urls= $_GET['url']){
	// gib den richtigen MIME-Typ und Dateinamen im Header an den Browser
	header("Content-type: audio/x-mpegurl");
	header("Content-Disposition: attachment; filename=playlist.m3u");

	/* Die URLs, die in der Playlist stehen sollen, erhlt das Skript als
		Semikolon-separierte Liste
	*/
	// Jede URL der Liste abarbeiten
	foreach( explode(';', $urls) as $u){
		$path='';
		// Die Pfad-Komponenten trennen...
		foreach( explode('/',  $u) as $i)
			// und einzeln URL-kodieren, wegen Leer- und Sonderzeichen
			$path[]=rawurlencode($i);
		
		// Jede URL erzeugen und ausgeben, die Dateien liegen auf demselben Server
		echo "http://" . $_SERVER['HTTP_HOST'] . implode( "/", $path) . "\n";
	} // foreach
}
else{
//	Falls der Parameter url fehlt, ist das Verzeichnislisting gefragt
?>
<HTML>
<HEAD>
<TITLE>Filme</TITLE>
<style type="text/css">
<!-- Fernseherfreundlich: Sehr gro hell auf dunkel
body{background-color:black; }
a,li{ color:yellow;
	font-size:41px; font-family:Helvetica,Arial,sans-serif;
	text-decoration:none}
-->
</style>
</HEAD>

<BODY>
<UL>

<?php
// Die Playlist erzeugt dasselbe Skript, daher muss sein Name in jeden Link
$pls_script = $PHP_SELF;
/* In welchem Verzchnis sind wir gerade? Durch diese Abfrage ist es mglich,
	in jedes Unterverzeichnis dasselbe Skript zu legen, unter Unix mittels
	Hard-Link (ln /pfad/zum/index.php . )
*/
$this_dir = dirname($_SERVER['PHP_SELF']) . '/';

// Das Verzeichnis lesen
if ($handle = opendir('.')) {
    $files=$directories=array();

	// Jede Datei behandeln
	while (false !== ($file = readdir($handle))) 
		// Einfache Dateien bekommen spter den Playlist-Link
		if(  is_file($file) && $file != basename( $_SERVER['PHP_SELF']))
			$files[] = $file;
		// Verzeichnisse werden getrennt in die Seite eingebaut
		elseif( is_dir($file) && $file != '.' && $file != '..')
			$directories[] = $file;

	closedir($handle);
}

// Als erstes ein Link nach oben
echo '<LI><A HREF="../">' ."Ein Verzeichnis hoch</A></LI>\n";

// Dann Links zu allen Unterverzeichnissen
if($directories){
	sort($directories);
	foreach($directories as $dir)
		echo '<LI><A HREF="' . $dir . '/">'.  "$dir</A></LI>\n";
}

// Jetzt kommen die Dateien
if($files){
	// Die Liste soll sortiert erscheinen
	sort($files);
	/* Auerdem bekommen Dateinamen, die sich nur in Ziffern unterscheiden,
		insgesamt nur einen Link, denn Sie gehren zu demselben Film:
		Filmtitel_CD1.avi, Filmtitel_CD2.av oder so hnlich.	
	*/
	$url=$last_nonum='';
	foreach($files as $file){
		// Alle Ziffern rauswerfen
		$nonum=ereg_replace("[0-9]", "", $file);
		if( $nonum==$last_nonum)
			/* Wenn der Name dann so ist, wie der der vorigen Datei, ists derselbe Film
				und auch diese Datei landet in derselben Playlist.
			*/
			$url .= rawurlencode( ";$this_dir$file");
		else{
			// Andernfalls gehrt die Datei nicht mehr zum vorigen Film daher...
			// ...erstmal den vorige Playlist-Link auswerfen
			if($url)
				echo $url . '">' . $last_nonum . "</a></li>\n";
			// .. und einen neuen anfangen
			$last_nonum=$nonum;
			$url =  '<LI><A HREF="' . $pls_script . '?url='
				. rawurlencode( "$this_dir$file");
		} // if...else
	} // foreach
	// Den letzen Link ausgeben
	if($url) echo $url . '">' . $last_nonum . "</a></li>\n";
}
// Und die Seite anschlieen
echo "</UL>\n</BODY>\n</HTML>";
}
?>
