import mx.controls.Alert;	//Alert-Klasse einbinden

ctXML_xml.trigger(); 			//Externes XML-File fr Databinding laden

//Beim Klick auf den Button Wetter-Alert-Box anzeigen
wetter_btn.onRelease = function()
{
	// Wurde der Service noch nicht gestartet?
	if (ctwetterservice == undefined)	{
		var mein_xml = new XML(ctXML_xml.results);	// XML einlesen

		//WSDL-URL aus der XML-Datei lesen
		var meinWSDL = mein_xml.childNodes[0].attributes.wetterwsdl;

		// WebService-Objekt mit der entsprechenden WSDL-Information anlegen
		_global.ctwetterservice = new mx.services.WebService(meinWSDL);
	}

	// Je nach Einstellung getTemperature oder getHumidity aufrufen
	if (modus_cmb.value == "Temperature") {
		var wetter = ctwetterservice.getTemperature(airport_cmb.value);
	}	else {
		var wetter = ctwetterservice.getHumidity(airport_cmb.value);
	}

	// Handler fr die erfolgte Temperaturrckgabe
	wetter.onResult = function(airportWetter) {
		// Zu zeigenden Text zusammensetzen
		var endtext_txt = airportWetter + "\n\nProgramm Schliessen?";

		Alert.yesLabel 	= "Ja";						//Text fr den Yes-Button ndern
		Alert.noLabel 	= "Nein";					//Text fr den No-Button ndern

		// Alert-Box mit dem bersetzten Text anzeigen
		Alert.show (
			endtext_txt,										// bersetzter Text
			"Aktuelles Wetter", 						// berschrift
			Alert.YES | Alert.NO,						// vorhandene Buttons
			_root,													// Parent fr die Positionierung
			KlickHandler,										// Handlerfunktion fr Buttonklicks
			"meinIcon"											// Identifier fr das Icon (optional)
		);
	};
};

// Handlerfunktion fr Buttonklicks
KlickHandler = function (welcherButton) {
	switch (welcherButton.detail)	{ 		// Diese Property enthlt den geklickten Button
		case Alert.YES:										// Ja-Button
			fscommand("quit", "");					// Flash-Player schliessen
			break;
		case Alert.NO:										// Nein-Button
			Selection.setFocus("text_txt");	// Focus auf das Textfeld setzen
			break;
	}
}

