<?xml version="1.0" encoding="iso8859-1" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" encoding="iso8859-1"/>

  <xsl:template match="/Musikstck-Sortiment">
    <html>
      <body background="Himmel.jpg">
        <h1>
          Tontrger:
        </h1>
        <table border="3" width="100%" bgcolor="#FFD0B0">
          <xsl:apply-templates select="Medium"/>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="Medium">
    <tr>
      <value-of select="."/>
      <xsl:apply-templates select="Cover"/>
      <td>
        <xsl:apply-templates select="Titel"/>
        <xsl:apply-templates select="Interpret"/>
      </td>
      <td row-span="20">
        <table border="1">
          <xsl:apply-templates select="/Musikstck-Sortiment/Musikstck/Satz"/>
        </table>
      </td>
    </tr>
    <xsl:apply-templates select="Label"/>
    <xsl:apply-templates select="Erscheinungsdatum"/>
    <xsl:apply-templates select="Kommentar"/>
  </xsl:template>

  <xsl:template match="Cover">
    <td>
      <img>
        <xsl:attribute name="src">
        <xsl:value-of select="."/>                             
        </xsl:attribute>
      </img>
    </td>
  </xsl:template>

  <xsl:template match="Titel">
    <p><b>
      <xsl:value-of select="."/>
    </b></p>
  </xsl:template>

  <xsl:template match="Interpret">
    <p>
      <xsl:value-of select="."/>
    </p>
  </xsl:template>  

  <xsl:template match="Musikstck-Sortiment/Musikstck/Satz">
    <tr>
      <td>
      <xsl:value-of select="Track-Nr."/>
      </td>
      <td>
      <xsl:value-of select="../Titel"/>
      </td>
    <td>
      <xsl:value-of select="Lnge"/>
    </td></tr>
  </xsl:template>

  <xsl:template match="Label">
    <tr>
      <td>
        <b>Label:</b>
      </td>
      <td>
        <xsl:value-of select="."/>
      </td>
      <xsl:apply-templates select="CD-Nr."/>
    </tr>
  </xsl:template>

  <xsl:template match="CD-Nr.">
      <td>
        <b>CD-Nr.:</b>
      </td>
      <td>
        <xsl:value-of select="."/>
      </td>
  </xsl:template>

  <xsl:template match="Erscheinungsdatum">
    <tr>
      <td>
        <b>erschienen:</b>
      </td>
      <td colspan="3">
        <xsl:value-of select="."/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="Kommentar">
    <tr>
      <td>
        <b>Kommentar:</b>
      </td>
      <td colspan="3">
        <xsl:value-of select="."/>
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>