package de.ct.refactoring;
import java.util.Arrays;

/**
 * Schritt 3: Methode sortedSubStrings() extrahieren 
 */
public class RefactoringExample4 {
	public static String longestRepeatingSubstring(String string) {
		String[] substrings = sortedSubstrings(string);
		
		int maxlen=0;
		int imax=-1;
		 
		for (int index = 0; index < string.length() - 1; index++) {
			final int currentLength = matchLength(substrings[index],substrings[index + 1]);
			if(currentLength > maxlen) {
				maxlen = currentLength;
				imax=index;
			}
		}
		  
		if (imax == -1){
			return "";
		} else {
				return substrings[imax].substring(0, maxlen);
		}
	}

	private static String[] sortedSubstrings(String string) {
		String[] substrings=new String[string.length()];
		for(int index = 0; index < string.length(); index++) {
			substrings[index]=string.substring(index,string.length());
		}
		Arrays.sort(substrings);
		
		return substrings;
	}

	private static int matchLength(String string1,String string2) {
		final int minLength = Math.min(string1.length(), string2.length());
		for(int index = 0; index < minLength; index++) {
			if(string1.charAt(index) != string2.charAt(index)) {
				return(index);
			}
		}
			return minLength;
		}	
}
