package com.objectfab.ctarticle;

import junit.framework.TestCase;

public class SampleClass3Test extends TestCase {
	SampleClass3 sample = null;

	public SampleClass3Test(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		sample = new SampleClass3();
	}

	protected void tearDown() throws Exception {
    sample = null;
  }

  public void testGetRightAlignedIntString() {
		assertEquals("          0", sample.getRightAlignedIntString(11, 0));
		assertEquals("          1", sample.getRightAlignedIntString(11, 1));
		assertEquals("          2", sample.getRightAlignedIntString(11, 2));
		assertEquals("         10", sample.getRightAlignedIntString(11, 10));
		assertEquals("        100", sample.getRightAlignedIntString(11, 100));
		assertEquals("       1000", sample.getRightAlignedIntString(11, 1000));
		assertEquals("         -1", sample.getRightAlignedIntString(11, -1));
		assertEquals("       -999", sample.getRightAlignedIntString(11, -999));
		assertEquals(" 2147483647", sample.getRightAlignedIntString(11, Integer.MAX_VALUE));
		assertEquals("-2147483648", sample.getRightAlignedIntString(11, Integer.MIN_VALUE));

		assertEquals(   "    1",  sample.getRightAlignedIntString( 5,   1));
		assertEquals("     -10",  sample.getRightAlignedIntString( 8, -10));

		try {
      String buffer=sample.getRightAlignedIntString(10, Integer.MIN_VALUE );
      fail("Es sollte eine Exception geworfen werden (buffer="+buffer+")");
		} catch (IllegalArgumentException e) {
		 // Alles in Ordnung
		}
	}

}
