package com.objectfab.ctarticle;

/*
 * Warum ausgerechnet ein TestCase pro Klasse, ein Test pro Methode?
 *
 * Das ist kein Dogma, sondern eine Richtung fuer die, die bisher gar
 * nicht getestet haben. Natuerlich kann man auch die verschiedenen Aspekte
 * einer Methode in getrennten Testmethoden abpruefen, oder die Tests
 * generell von den Methoden loesen und stattdessen an Funktionalitaeten
 * ausrichten. Bei gutem OO-Design ist aber das oft kein grosser Unterschied.
 * Die Anwendungsstruktur bietet eine gute Basis fuer die Ordnung der
 * Unittests. Das bedeutet aber auch, dass man genauso Tests braucht, die
 * mehrere Klassen einbeziehen. Auch sie koennen mit dem JUnit-Framework
 * realisiert werden.
 */

/**
 * Eine Klasse, deren Methoden getestet werden sollen.
 */
public class SampleClass1 {
  /**
   * Eine erste zu testende Methode:
   * Wieviel Stellen braucht eine Dezimalzahl?
   *
   * @param a die Zahl, deren Stellenzahl zu ermitteln ist
   * @return  die Anzahl der Dezimalstellen
   */
  public int numOfDecimalDigits(int a) {
    int digits = 0;
	  a = Math.abs(a);

    /* Das ist wirklich nicht clever. ;-) */
    do {
      digits++;
      a = a/10;
    } while (a != 0);

    return digits;
  }

  /**
   * Bringt eine Dezimalzahl rechtsbuendig in einer
   * Zeichenkette konstanter Laenge unter.
   *
   * @param a  die darzustellende Zahl
   * @return der rechtsbuendig formatierte String
   */
  public String getRightAlignedIntString(int a) {
	  StringBuffer sb = new StringBuffer();
	  int numDigits   = numOfDecimalDigits(a);
	  int numSign     = (a < 0) ? 1 : 0;
	  int numSpaces   = 11 - numDigits - numSign;

    for (int i = 0; i < numSpaces; i++) {
    	sb.append(" ");
	  }

	  sb.append(a);
	  return sb.toString();
	}
}
