var myapp_bundle;
var checkLoadUriPref = null;

// getPref() und setPref() ndern mit Hilfe der XPCOM-Komponente
// "preferences" die Browser-Einstellungen
function getPref(aPrefString) {
  if(!aPrefString) {
  	return false;
  }
  
  var nsIPref = Components.interfaces.nsIPref;
  var pref = Components.classes["@mozilla.org/preferences;1"].
                          createInstance(nsIPref);

  return pref.GetBoolPref(aPrefString)
}

function setPref(aPrefString, aInBool) {
  if(!aPrefString) {
    return false;
  }
  
  var nsIPref = Components.interfaces.nsIPref;
  var pref = Components.classes["@mozilla.org/preferences;1"].
                          createInstance(nsIPref);
  pref.SetBoolPref(aPrefString, aInBool)
  return true;
}

// init() schaltet den Zugriff auf lokale Dateien ein
function init() {
  myapp_bundle = document.getElementById("bundle_myapp");
  if (checkLoadUriPref == null) {
      checkLoadUriPref = getPref("security.checkloaduri");
  }
  setPref("security.checkloaduri", false);
  centerWindowOnScreen();
}

function exit() {
  setPref("security.checkloaduri", checkloaduripref);
}

// load() ldt die HTML-Seite mit der "Hallo Welt"-Nachricht
function Load() {
  document.getElementById("vb").setAttribute("style", "");
  document.getElementById("content").setAttribute("src",
  						"chrome://myapp/locale/myapp.html");
}

// open() ffenet einen Dateiauswahl-Dialog und stellt die
// gewhlte HTML-Seite im Browser dar.
function Open() {
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"]
  						   .createInstance(nsIFilePicker);
  
  // Die Funktion initialisiert den Dialog mit dem Titel-String
  // aus der Properties-Datei.
  fp.init( this.mDialog,
           myapp_bundle.getString("OpenTitle"),
           nsIFilePicker.modeOpen );

  fp.appendFilter( "HTML", "*.html" );
  fp.appendFilter( "HTM", "*.htm" );
  fp.appendFilters( nsIFilePicker.filterAll );

  if ( fp.show() == nsIFilePicker.returnOK && fp.file ) {
    document.getElementById("vb").setAttribute("style", "");
    document.getElementById("content")
            		  .setAttribute("src", fp.fileURL.spec);
  }
}

function Clear() {
  document.getElementById("content").setAttribute("src", "");
  document.getElementById("vb").setAttribute(
  							 "style", "visibility: hidden;");
}

function Exit() {
  close();
}