unit motinter;
(**********************************)
(* motinter.pas			  *)
(*				  *)
(* c't/Andreas  Stiller           *)
(* (C) 2002                       *)
(* www.heise.de/ct		  *)
(**********************************)

interface
uses windows,messages;
Function MotorInit(ahandle:Thandle):boolean;
Function MotorExit:boolean;
Function Interpret (s:shortstring; var answer:shortstring):boolean;

const WM_Motor = WM_USER + $400;

const
(*** Konstanten, die von mothost.ini berschrieben werden knnen ***)
MOTOR_OFF:byte   = $A; {P1.1=1, P1.3=1}
MOTOR_Left:byte  = $2; {P1.1=1, P1.3=0}
MOTOR_Right:byte = $8; {P1.1=0, P1.3=1}

//Endabschaltung
const MaxRight:byte=255;
const MaxLeft:byte=0;
const checklimits:boolean=true;


const invertADC:boolean=true;
const invertDir:boolean=false;

//Drehzahlregelubg durch Puls/Pause
const withpulses:boolean=true;
const Runsleeptime:integer=50; //in ms
const Stopsleeptime:integer=0; //Startwert bei Fullspeed in ms
const speeddiff=5;            //Pro Schieberintervall in ms;


// falls beispielsweise ein Vollkreis von 360 genau einem ADC-Wert von =255 entspricht:
const KalibrierungsWinkel:integer=360;
const KalibrierungsADCwert:integer=255;

const maxbremsweg:integer=3;
const minstops:integer=3;



var Uebersetzung:real;
var ToSend:String;
var maxwinkel,minwinkel:integer;

(**********************************************************************)

implementation
uses USB,sysutils;

const USBok:boolean=false;
const motorstatus:char='S';
const Than:Longword=0;
const Threadstop:boolean=false;

var Tid:Longword;
var sollwert:integer; // in 
var master:Thandle;

Function Getpos (var Winkel:integer):boolean;
var ADCValue:Byte;
begin
 Getpos:=USBReadPort(0, ADCValue);
 if InvertADC then ADCValue:= not ADCValue;
 Winkel:=round(ADCvalue*uebersetzung);
end;

Procedure Send (ist,soll:integer;status:char);
begin
 ToSend:='#'+inttostr(ist)+','+inttostr(soll);
 postmessage (master,WM_Motor,byte(status),longword(@ToSend));
end;


Function Stop:boolean;
var Control:byte;
begin
Stop:=false;
If not USBReadPort(1, control) then exit;
Stop:=USBWritePort (1,(control and $F5) or MOTOR_OFF);
Motorstatus:='S';
end;


Function GotoRight: boolean;
var Control:byte;
begin
 GotoRight:=false;
 If not USBReadPort(1, control) then exit;

 if invertdir then control:=(control and $F5) or MOTOR_Left
 else control:=(control and $F5) or MOTOR_Right;

 GotoRight:=USBWritePort (1,control); // 0101
 Motorstatus:='R';
end;

Function GotoLeft: boolean;
var Control:byte;
begin
 GotoLeft:=false;
 If not USBReadPort(1, control) then exit;
 if invertdir then control:=(control and $F5) or MOTOR_Right
 else control:=(control and $F5) or MOTOR_Left;
 GotoLeft:=USBWritePort (1,control);
 Motorstatus:='L';
end;

Function motorthread (pByte:Pointer):integer;
var p,altp:integer;
var runtime:longword;
var stopcount:integer;
var bremsweg:integer;
begin
 Threadstop:=false;
 Motorstatus:='S';
 stopcount:=0;
 runtime:=runsleeptime;
 getpos(altp);
 case stopsleeptime of
  0:  begin bremsweg:=maxbremsweg;  end;
  10: begin bremsweg:=2;  end;
  else begin bremsweg:=1; end;
 end;
 repeat
  if not getpos (p) then p:=180;  { Mittelstellung, falls Poti nicht lesbar }
  if ((p < sollwert) or (not Checklimits and (p=MaxWinkel))) and (Motorstatus <> 'R') then  GotoRight;
  if ((p > sollwert) or (not Checklimits and (p=MinWinkel)))  and (Motorstatus <> 'L') then  GotoLeft;
  if checklimits then
   begin
   if (Motorstatus='R') and (p >=maxWinkel) then begin stop; Motorstatus:='r'; break end;
   if (Motorstatus='L') and (p <=minWinkel)  then begin stop; motorstatus:='l'; break end;
   // rechtzeitig bremsen //
   if abs (p-sollwert)<= bremsweg then
    begin
     stop;
     Motorstatus:='B';
     inc (stopcount);
    if stopcount > minstops then break;
    end;
  end;

 if Threadstop then stop;
 if Motorstatus='S' then break;
 if (master <> 0) and (p <> altp) then send(p,sollwert,motorstatus);
 sleep (runtime);
 if stopsleeptime <> 0 then
  begin
  stop;
  sleep (stopsleeptime);
  end;
 altp:=p;
until false;
if (master <> 0) then send (p,sollwert,motorstatus);
motorthread:=0;
end;

Function MotorInit(ahandle:Thandle):boolean;
 begin
 USBok:=USBOpenDriver;
 master:=ahandle;
 MotorInit:=USBok;
 Uebersetzung:=KalibrierungsWinkel/KalibrierungsADCwert;
 MaxWinkel:=round(MaxRight*Uebersetzung);
 MinWinkel:=round(MaxLeft*Uebersetzung);
 end;

Function MotorExit:boolean;
 begin
 Stop;
 MotorExit:=USBClosedriver;
 end;

Procedure Stopthread;
var threadstatus:longword;
begin
 {mglicherweise laufenden MotorThread erst einmal freundlich abbrechen }
 if Than <> 0 then
 begin
 Threadstop:=true;
  repeat
   if not GetExitCodeThread(Than,Threadstatus) then break;
  until Threadstatus<> STILL_ACTIVE;
  Than:=0;
 end;
end;

Procedure Startnewthread (awert:integer);
begin
 sollwert:=awert;

 if not USBok // fr Debugzwecke, meldet pos 77 zurck
  then
   begin
   if sollwert >128 then postmessage (master,WM_Motor,77+sollwert shl 8,byte('R'))
   else postmessage (master,WM_Motor,77+sollwert shl 8,byte('L'))
   end

  else
    begin
    StopThread;
    Than:=BeginThread (Nil,0,@MotorThread,@sollwert,0,Tid);
    end;
end;


Procedure setspeed (x:integer);
begin
if not withpulses then exit; // Pulsbetrieb berhaupt erlaubt?
stopsleeptime:=x*speeddiff;
end;

Function Interpret (s:shortstring; var answer:shortstring):boolean;
var res:integer;
var p:integer;
var validpos:boolean;
var aktstat:char;
var value:integer;
var valuestr:shortstring;
var isGrad:boolean;
begin
answer:='';
valuestr:=copy(s,2,255);
value:=0;
Interpret:=false;
if Valuestr <>'' then
 begin
 isGrad:= Valuestr[length(Valuestr)]='';
 if isGrad then delete(Valuestr,length(Valuestr),1);
 val (Valuestr,value,res);
 if res <>0 then
  begin
  answer:=s+' huch, wat dat';
  exit;
  end;
 end;

aktstat:=Motorstatus;

case upcase(s[1]) of
 'R': begin    //nach Rechts, maximal bis Anschlag
      answer:='ok, Rechts';
      if valuestr <>'' then setspeed (value);
      startnewthread (MaxWinkel);
      end;
 'L': begin  //nach Links, maximal bis Anschlag
      answer:='ok, Links';
      if valuestr <>'' then setspeed (value);
      startnewthread (MinWinkel);
      end;
 'N': begin //neue Position bis Winkel
      if valuestr='' then begin answer:='pos fehlt'; exit end;
      answer:='ok Goto '+valuestr;
      startnewthread(value);
      end;
 'V': begin // Drehzahlregelung durch Pulse, falls zugelassen
      if valuestr <> '' then setspeed (value);
      end;
 'P': begin
      validpos:=getpos(p);
      send (p,sollwert,'?');
      end;
 'S': begin
      Stopthread;

      sleep (100); // bichen warten
      validpos:=getpos(p);
      If Stop then answer:='ok, Stop '+aktstat +inttostr(p);
      send (p,sollwert,'S');
      end;

  else answer:='??';
 end;
 Interpret:=true;
end;

end.
