unit hostmain;
{$H+}
interface
(**********************************)
(* hostmain.pas		  *)
(*				  *)
(* c't/Andreas  Stiller           *)
(* (C) 2002                       *)
(* www.heise.de/ct		  *)
(**********************************)


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Buttons, ScktComp, ExtCtrls, ComCtrls,iniFiles,Motinter;

type
  TMotorForm = class(TForm)
    MainMenu1: TMainMenu;
    Verbindung: TMenuItem;
    Exit1: TMenuItem;
    ListenItem: TMenuItem;
    StatusBar1: TStatusBar;
    Bevel1: TBevel;
    Panel1: TPanel;
    Memo2: TMemo;
    N1: TMenuItem;
    Disconnect1: TMenuItem;
    ServerSocket: TServerSocket;
    bStop: TButton;
    eSoll: TEdit;
    eIst: TEdit;
    Label1: TLabel;
    lSoll: TLabel;
    TrackBar1: TTrackBar;
    bLinks: TButton;
    bRechts: TButton;
    Optionen1: TMenuItem;
    ADC: TMenuItem;
    invADC: TMenuItem;
    invDir: TMenuItem;
    Changes: TMenuItem;

    procedure ListenItemClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ServerSocketError(Sender: TObject; Number: Smallint;
      var Description: string; Scode: Integer; const Source,
      HelpFile: string; HelpContext: Integer; var CancelDisplay: Wordbool);
    procedure Disconnect1Click(Sender: TObject);
    procedure ServerSocketClientRead(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ServerSocketAccept(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ServerSocketClientConnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ServerSocketClientDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure Listen;
    procedure ClrScr;
    procedure WriteLn (s:string);  // kann mich nich nicht von trennen ...
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure bStopClick(Sender: TObject);
    procedure eSollKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure AppMessage(var Msg: TMsg; var Handled: Boolean);
    procedure TrackBar1Change(Sender: TObject);
    procedure bRechtsClick(Sender: TObject);
    procedure bLinksClick(Sender: TObject);
    procedure InterpretIni;
    procedure Edit1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ADCClick(Sender: TObject);
    Procedure ShowIstundSoll(ist,soll:integer);
    procedure invADCClick(Sender: TObject);
    procedure invDirClick(Sender: TObject);
    procedure ChangesClick(Sender: TObject);

  protected
    hasConnection: Boolean;
    IsLogin:Boolean;
    answer:shortstring;
    Mypath:string;
    Inidat:Tinifile;
    editok:boolean;
    isGrad:boolean;
    ADCist,ADCsoll:integer;
  end;

var
  MotorForm: TMotorForm;
  Server: String;

//*********** neu aus  motorhost.ini ********//
const maxlines:integer=25;
const password:string='*';
//******************************************//

implementation

{$R *.DFM}


const sema:boolean=false;

Function ShowError (x:string):integer;
begin
 Showerror:=application.messagebox(pchar(x),'Error',MB_OK or MB_ICONERROR);
 halt(1);
end;

Procedure TmotorForm.ShowIstundSoll(ist,soll:integer);
begin
  IsGrad:=not ADC.checked;
  ADCist:=round(ist/uebersetzung);
  ADCsoll:=round(soll/uebersetzung);
  if IsGrad then
   begin
     eIst.text :=inttostr (ist)+'';
     eSoll.text:=inttostr (soll)+'';
   end
   else
   begin
     eIst.text :=inttostr (ADCist);
     eSoll.text:=inttostr (ADCsoll);
   end
end;

procedure TMotorForm.AppMessage(var Msg: TMsg; var Handled: Boolean);
var ToSend,iststr,sollstr:shortstring;
var status:char;
var ist,soll,res1,res2:integer;
var k:integer;
begin
  if Msg.message = WM_MOTOR then
  begin
  //Writeln ('Message: '+inttostr(lo(Msg.wparam))+' '+inttostr(hi(Msg.wparam))+ ' '+char(lo(Msg.lparam)));
    ToSend:=string(pointer(Msg.lparam)^);
    Status:=char(lo(Msg.wparam));
    If Status='S' then
     begin
      status:='S';
     end;
    if (ToSend <>'') then
      begin
      if ToSend[1]='#' then //Positionsbermittlung #ist,soll in 
       begin
       k:=pos(',',ToSend);
       iststr:= copy (Tosend,2,k-2);
       sollstr:=copy (Tosend,k+1,255);
       val (iststr,ist,res1);
       val (sollstr,soll,res2);
       if (res1=0) and (res2=0) then
         begin
         ShowIstundSoll (ist,soll);
         if IsLogin and (Changes.checked or not (Status in ['R','L'])) then
          begin
          Writeln (ToSend);
          ServerSocket.Socket.Connections[0].SendText(ToSend);
          end;
        end;
       end
       else if IsLogin then
        begin
        Writeln (ToSend);
        ServerSocket.Socket.Connections[0].SendText(ToSend);
        end;
      end;
     Statusbar1.Panels[1].Text := status;
    Handled := True;
  end;
end;

Procedure TmotorForm.ClrScr;
begin
memo2.Lines.clear;
end;

Procedure TmotorForm.WriteLn (s:string);
begin
if memo2.Lines.count >= maxLines then memo2.lines.delete(0);
memo2.Lines.add(s)
end;

Procedure TMotorForm.Listen;
begin
 hasConnection:=false;
 IsLogin:=false;
 ServerSocket.Active := True;
 Statusbar1.Panels[0].Text := 'Listening...';
end;

procedure TMotorForm.ListenItemClick(Sender: TObject);
begin
  hasConnection:=false;
  ListenItem.Checked := not ListenItem.Checked;
  if ListenItem.Checked then Listen
  else
  begin
    if ServerSocket.Active then  ServerSocket.Active := False;
    Statusbar1.Panels[0].Text := '';
  end;
end;

procedure TMotorForm.Exit1Click(Sender: TObject);
begin
  ServerSocket.Close;
  Close;
end;

Procedure TMotorform.InterpretIni;
 begin
  // Auch wenns Microsoft nicht mag, ich mag lokale INI-Dateien


 Mypath:=ExtractFilePath(ParamStr(0));
 Inidat:=Tinifile.Create(mypath+'motorhost.ini');
 With Inidat do
  begin
   If not FileExists (Filename) then Writeln (Filename+ ' nicht gefunden, nehme Defaultwerte');
   Writeln (Filename);
   Serversocket.port:=ReadInteger ('IP','PORT',ServerSocket.port);
   Password:=ReadString('IP','Password',Password);

   If Password='*' then
     begin
     Password:='';
     if InputQuery( 'Passwort eingeben', 'Passwort:', Password) then
       WriteString ('IP','Password',Password)
     end;
   Changes.checked:=Readbool('IP','SendChanges',Changes.checked);
   MOTOR_OFF:=ReadInteger  ('MOTOR','MOTOR_OFF',MOTOR_OFF);
   MOTOR_Left:=ReadInteger ('MOTOR','MOTOR_Left',MOTOR_Left);
   MOTOR_Right:=ReadInteger('MOTOR','MOTOR_Right',MOTOR_Right);

   MaxRight:=ReadInteger('MOTOR','MaxRight',MaxRight);
   MaxLeft :=ReadInteger('MOTOR','MaxLeft',MaxLeft);
   checklimits:=ReadBool    ('MOTOR','checklimits',checklimits);

   invertADC:=ReadBool     ('MOTOR','invertADC',InvertADC);
   invADC.checked:=InvertADC;
   invertDir:=ReadBool     ('MOTOR','invertDir',InvertDir);
   invDir.checked:=invertDir;

   RunSleepTime:=ReadInteger('MOTOR','Run',RunSleeptime);
   StopSleepTime:=ReadInteger('MOTOR','Stop',StopSleepTime);
   withpulses:=ReadBool     ('MOTOR','WithPulses',withpulses);

   Kalibrierungswinkel:= ReadInteger('MOTOR','Winkel',Kalibrierungswinkel);
   KalibrierungsADCwert:= ReadInteger('MOTOR','ADCwert',KalibrierungsADCwert);

   maxbremsweg:=ReadInteger ('MOTOR','MaxBremsWeg',maxbremsweg);
   minstops:=ReadInteger ('MOTOR','MinStops',minstops);

  end;

 end;

procedure TMotorForm.FormCreate(Sender: TObject);
begin
  InterpretIni;
  Application.OnMessage := AppMessage;
  Trackbar1.enabled:=withpulses;

  if Motorinit(self.handle) then

    begin
    WriteLN ('ok, Motortreiber geladen');
    Interpret ('P',answer);
    ListenItemClick(nil);
    end
    else WriteLN (' Mist, kann den Motortreiber nicht laden - Modul-USB-Treiber da? Motor angeschlossen?');
end;


procedure TMotorForm.ServerSocketError(Sender: TObject; Number: Smallint;
  var Description: string; Scode: Integer; const Source, HelpFile: string;
  HelpContext: Integer; var CancelDisplay: Wordbool);
begin
  ShowMessage(Description);
end;

procedure TMotorForm.Disconnect1Click(Sender: TObject);
begin
  Writeln ('Disconnect clicked');
  ListenItemClick(nil);
end;

procedure TMotorForm.ServerSocketClientRead(Sender: TObject;
  Socket: TCustomWinSocket);
  var Command:Shortstring;
begin
  command:=Socket.ReceiveText;
  WriteLn (Command);
  If not IsLogin then
   begin
   IsLogin:=Command=Password;
   If IsLogin then  ServerSocket.Socket.Connections[0].SendText('ok, Zugang erlaubt')
   else ServerSocket.Socket.Connections[0].SendText('kein Zugang erlaubt')
   end
  else
   begin
   answer:='ok';
   if command='SendChanges' then Changes.checked:=true
   else if Command='NoChanges' then Changes.checked:=false
    else Interpret(Command,answer);
   SendMessage (Self.handle,WM_Motor,byte('A'),longword(@answer));
   end;
end;

procedure TMotorForm.ServerSocketAccept(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  hasConnection := True;
  Statusbar1.Panels[0].Text := 'Connected to: ' + Socket.RemoteAddress;
end;

procedure TMotorForm.ServerSocketClientConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Memo2.Lines.Clear;
end;

procedure TMotorForm.ServerSocketClientDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Writeln ('ServerSocketClientDisconnect');
  Listen;
end;





procedure TMotorForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
MotorExit;
end;


procedure TMotorForm.bStopClick(Sender: TObject);
begin
interpret ('S',answer);
Writeln (answer);
end;

procedure TMotorForm.eSollKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var soll:integer;
var res:integer;
begin
if key=VK_Return then
 begin
  if ADC.checked then
   begin
    val (eSoll.text,ADCsoll,res);
    soll:=Round(ADCsoll*uebersetzung);
    interpret('N'+inttostr(soll)+'',answer);
   end
   else interpret('N'+eSoll.text,answer);
  Writeln (answer);
 end;
end;

procedure TMotorForm.TrackBar1Change(Sender: TObject);
begin
  with Trackbar1 do interpret ('V'+inttostr(position),answer);
  Writeln (answer);
end;

procedure TMotorForm.bRechtsClick(Sender: TObject);
begin
interpret ('R',answer);
Writeln (answer);
end;

procedure TMotorForm.bLinksClick(Sender: TObject);
begin
interpret ('L',answer);
Writeln (answer);
end;

procedure TMotorForm.Edit1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if Key=13 then editok:=true;
end;

procedure TMotorForm.ADCClick(Sender: TObject);
begin
ADC.Checked:=not ADC.Checked;
showIstundSoll(round(ADCist*Uebersetzung),round(ADCsoll*Uebersetzung));
end;

procedure TMotorForm.invADCClick(Sender: TObject);
begin
invADC.checked:=not invadc.checked;
InvertADC:=invADC.checked;
inidat.WriteBool('MOTOR','InvertADC',InvertADC);
end;

procedure TMotorForm.invDirClick(Sender: TObject);
begin
invDir.checked:=not invDir.checked;
InvertDir:=invDir.checked;
inidat.WriteBool('MOTOR','InvertDir',InvertDir);
end;

procedure TMotorForm.ChangesClick(Sender: TObject);
begin
changes.checked:=not changes.checked;
end;



end.
