/***
 * c't Motorsteuerung
 * usb.c
 *
 * Kommunikation mit dem USB-Baustein
 *
 * (c) 2002 Redaktion c't, Hannover
 *          Kai-Uwe Mrkor / Herbert Schmid
 ***/

#include <stdio.h>
#include <conio.h>
#include <windows.h>

#include "usb.h"

/* alle Funktionen liefern bei Erfolg 0, im Fehlerfalle einen Wert ungleich 0 */


/* vom USB-Treiber verwendeter Steuercode */
#define COMPULAB_IOCTL 4

/* Handle auf GerteTreiber */
HANDLE  hgDriver = INVALID_HANDLE_VALUE; 

/***
 * USB-Treiber ffnen
 ***/
BOOL USBOpenDriver()
{
  
  /* Treiber bereits geffnet? */	
  if(hgDriver != INVALID_HANDLE_VALUE)
	/* dann zur Fehlerbehandlung erneut ffnen */
    USBCloseDriver();
	
  /* Gertetreiber mit passenden Dateinamen ffnen */
  hgDriver = CreateFile("\\\\.\\CompuLABusb_0",	GENERIC_WRITE || GENERIC_READ, 
						 FILE_SHARE_WRITE || FILE_SHARE_READ,	NULL, OPEN_EXISTING, 0, 0); 

  return hgDriver == INVALID_HANDLE_VALUE;
}

/***
 * USB-Treiber schlieen 
 ***/
BOOL USBCloseDriver()
{
  BOOL ret=CloseHandle(hgDriver);
  hgDriver = INVALID_HANDLE_VALUE;

  return !ret;
}


/***
 * Port setzen              
 *							
 * Port:  zu setzender Port (0,1)  
 * Value: auszugebender Wert 
 ***/
BOOL USBWritePort(unsigned char Port, unsigned char Value)
{
  DWORD		command, inDummy, count;
  
  /* Befehl fr Treiber berechnen: */
  /* 21: Port setzen */
  command = (Value<<16) + Port * 256 + 21;   
  inDummy = 0;

  /* Ausgabe */
  return !DeviceIoControl(hgDriver, COMPULAB_IOCTL, &command, sizeof(command), 
							&inDummy, sizeof(inDummy), &count, NULL); 
  
}

/***
 * Port auslesen            
 *							
 * Port:  zu lesender Port (0,1)  
 * Value: nimmt den Wert auf
 ***/
BOOL USBReadPort(unsigned char Port, unsigned char *Value)
{
 DWORD	command, count;
 BOOL ok;
 unsigned char	inBytes[2];
 
 /* Befehl fr den Treiber berechnen */
 /* 20: Port auslesen */
 command = 20 + Port*256; 
 
 ok = DeviceIoControl(	hgDriver, COMPULAB_IOCTL, &command, sizeof(command), 
							&inBytes, sizeof(inBytes), &count, NULL); 
 if ( ok )
   *Value=(unsigned char)inBytes[1];

 return !ok;
}
