' ****************************************************************
' Funktion:      Schreibt die Namen gedroppter MP3-Dateien in eine
'                temporre Playliste (M3U-Datei) und spielt diese
'                mit Hilfe des Windows Media Players ab.
'
' Erfordert:    - Windows Scripting Host 2.0
'               - DlgTools.ocx
'               - Windows Media Player 6.0
' 
' Copyright (C) 2001 Ralf Nebelo
' ****************************************************************

Option Explicit

Dim objShell
Dim objFS
Dim objDlgTools
Dim strM3UDateiname
Dim objM3UDatei
Dim objDatei
Dim intI
Dim strArg


On Error Resume Next

Set objShell = WScript.CreateObject("WScript.Shell")
Set objFS = WScript.CreateObject("Scripting.FileSystemObject")

If Wscript.Arguments.Count = 0 Then
    MsgBox "Keine Dateien oder Ordner gedroppt.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

Set objDlgTools = WScript.CreateObject("DesktopSkripte.DlgTools")
If objDlgTools Is Nothing Then
    MsgBox "DlgTools.ocx ist nicht installiert.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

strM3UDateiname = objDlgTools.DlgOpenSaveFile(2, "MediaPlayer-Abspiellisten", "*.m3u", "Playlist1.m3u", "", "Abspielliste speichern unter")
If strM3UDateiname > "" Then
    Set objM3UDatei = objFS.OpenTextFile(strM3UDateiname, 2, True)
    With objM3UDatei
        For intI = 0 To WScript.Arguments.Count - 1
            strArg = WScript.Arguments(intI)
            If objFS.FolderExists(strArg) = True Then
                For Each objDatei In objFS.GetFolder(strArg).Files
                    If LCase(Right(objDatei.Name, 4)) = ".mp3" Then
                        .WriteLine objDatei.Path
                    End If
                Next
            Else
                .WriteLine strArg
            End If
        Next
        .Close
    End With
    
    objShell.Run "MPlayer2.exe " & strM3UDateiname
End If
