' ****************************************************************
' Funktion:      Schreibt ein Dateininhaltsverzeichnis des 
'                gedroppten Ordners in ein neues Word-Dokument.
'
' Erfordert:    - Windows Scripting Host 2.0
'               - Word ab Version 97
' 
' Copyright (C) 2001 Ralf Nebelo
' ****************************************************************

Option Explicit

Dim objFS
Dim objFolder
Dim objWD
Dim objSubFolder
Dim objFile
Dim intCount
Dim lngSize

'Word-Konstanten
Const wdAlignTabRight = 2
Const wdAlignTabLeft = 0
Const wdTabLeaderDots = 1
Const wdTabLeaderSpaces = 0


On Error Resume Next

Set objFS = WScript.CreateObject("Scripting.FileSystemObject")

Set objFolder = objFS.GetFolder(WScript.Arguments(0))
If objFolder Is Nothing Then
    MsgBox "Kein Ordner gedroppt.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

Set objWD = WScript.CreateObject("Word.Application")
If objWD Is Nothing Then
    MsgBox "Word kann nicht gestartet werden.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

With objWD
    .Visible = True
    .Documents.Add

    With .Selection
        .TypeText "Inhalt von " & objFolder.Path & vbCR
        
        With .ParagraphFormat.TabStops
            .ClearAll
            .Add objWD.CentimetersToPoints(0.5), wdAlignTabLeft, wdTabLeaderSpaces
            .Add objWD.CentimetersToPoints(7), wdAlignTabLeft, wdTabLeaderDots
            .Add objWD.CentimetersToPoints(12), wdAlignTabRight, wdTabLeaderDots
            .Add objWD.CentimetersToPoints(16), wdAlignTabRight, wdTabLeaderDots
        End With
        
        For Each objSubFolder In objFolder.SubFolders
            .TypeText vbTab & UCase(objSubFolder.Name) _
            & vbTab & "<Verz>" _            
            & vbTab & FormatNumber(objSubFolder.Size, 0, , , True) & " Bytes" _
            & vbTab & objFolder.DateLastModified & vbCR
            intCount = intCount + 1
            lngSize = lngSize + objSubFolder.Size
        Next

        For Each objFile In objFolder.Files
            .TypeText vbTab & LCase(objFile.Name) _
            & vbTab & vbTab & FormatNumber(objFile.Size, 0, , , True) & " Bytes" _
            & vbTab & objFile.DateLastModified & vbCR
            intCount = intCount + 1
            lngSize = lngSize + objFile.Size
        Next

        .TypeText intCount & " Eintrge, " & FormatNumber(lngSize, 0, , , True) & " Bytes"
    End With
End With
