Attribute VB_Name = "OL_Vorlesen"
Option Explicit

'Standardmodul OL_Vorlesen
' 2001, Ralf Nebelo

'*******************************************************************
'Makros
'*******************************************************************

Sub MarkierteElementeVorlesen()
    Dim objItem As Object
    
    On Error Resume Next
    
    'Alle markierten Explorer-Elemente vorlesen
    For Each objItem In ActiveExplorer.Selection
        Call ItemRead(objItem)
    Next
End Sub

Sub UngeleseneNachrichtenVorlesen()
   Dim intUngelesenTotal As Integer
    Dim objNameSpace As NameSpace
    Dim objPosteingang As MAPIFolder
    Dim objUnterordner As MAPIFolder
    Dim objNachricht As Object

    Set objNameSpace = Application.GetNamespace("MAPI")
    Set objPosteingang = objNameSpace.GetDefaultFolder(olFolderInbox)
    
    intUngelesenTotal = objPosteingang.UnReadItemCount
    For Each objUnterordner In objPosteingang.Folders
        intUngelesenTotal = intUngelesenTotal + _
        objUnterordner.UnReadItemCount
    Next
    
    If intUngelesenTotal > 0 Then
        With frmVorlesen
            .Caption = CStr(intUngelesenTotal) & _
            " ungelesene Nachricht(en)"
            .wspMund.SetText "Sie haben " & IIf(intUngelesenTotal _
            <> 1, CStr(intUngelesenTotal) &  _
            " ungelesene Nachrichten: ",  _
            "eine ungelesene Nachricht: ")
            .Show
        End With
        
        If objPosteingang.UnReadItemCount > 0 Then
            Set ActiveExplorer.CurrentFolder = objPosteingang
            For Each objNachricht In objPosteingang.Items
                If objNachricht.UnRead = True Then
                    Call ItemRead(objNachricht)
                    objNachricht.UnRead = False
                End If
            Next
        End If
    
        For Each objUnterordner In objPosteingang.Folders
            If objUnterordner.UnReadItemCount > 0 Then
                Set ActiveExplorer.CurrentFolder = objUnterordner
                For Each objNachricht In objUnterordner.Items
                    If objNachricht.UnRead = True Then
                        Call ItemRead(objNachricht)
                        objNachricht.UnRead = False
                    End If
                Next
            End If
        Next
    Else
        With frmVorlesen
            .Caption = "Keine ungelesenen Nachrichten"
            .wspMund.SetText  _
            "Sie haben keine ungelesenen Nachrichten."
            .Show
        End With
    End If
End Sub

Sub FlligeAufgabenVorlesen()
    Dim objNameSpace As NameSpace
    Dim objAufgabenordner As MAPIFolder
    Dim objFlligeAufgaben As Items
    Dim objAufgabe As TaskItem

    Set objNameSpace = Application.GetNamespace("MAPI")
    Set objAufgabenordner = objNameSpace.GetDefaultFolder(olFolderTasks)
    
    'Aufgaben rausfiltern, die heute fllig und nicht erledigt sind
    Set objFlligeAufgaben = objAufgabenordner.Items.Restrict("[DueDate] = '" & Date & "' And [Status] <> 2")
    'Wenn Anzahl solcher flligen Aufgaben grer Null, dann...
    If objFlligeAufgaben.Count > 0 Then
        '... Anzahl vorlesen
        With frmVorlesen
            .Caption = CStr(objFlligeAufgaben.Count) & " Aufgabe(n) fllig"
            .wspMund.SetText "Sie sollten heute " & IIf(objFlligeAufgaben.Count <> 1, CStr(objFlligeAufgaben.Count) & " Aufgaben erledigen: ", "die folgende Aufgabe erledigen: ")
            .Show
        End With
    
        'Aufgaben-Ordner zum aktiven Ordner machen
        Set ActiveExplorer.CurrentFolder = objAufgabenordner
        'Alle flligen Aufgaben vorlesen
        For Each objAufgabe In objFlligeAufgaben
            Call ItemRead(objAufgabe)
        Next
    Else
        With frmVorlesen
            .Caption = "Keine Aufgaben fllig"
            .wspMund.SetText "Heute sind keine Aufgaben fllig."
            .Show
        End With
    End If
End Sub

Sub FlligeTermineVorlesen()
    Dim objNameSpace As NameSpace
    Dim objTerminordner As MAPIFolder
    Dim objTermin As AppointmentItem
    Dim intCount As Integer

    Set objNameSpace = Application.GetNamespace("MAPI")
    Set objTerminordner = objNameSpace.GetDefaultFolder(olFolderCalendar)
    
    'Alle Termine durchlaufen
    For Each objTermin In objTerminordner.Items
        'Termine rausfiltern, die heute anstehen
        If CDate(Format(objTermin.Start, "short date")) <= Date And CDate(Format(objTermin.End, "short date")) >= Date Then
            'Vor dem Vorlesen des ersten Termins ...
            If intCount = 0 Then
                '... Ankndigung vorlesen
                With frmVorlesen
                    .Caption = "Fllige Termine"
                    .wspMund.SetText "Sie sollten heute folgende Termine wahrnehmen: "
                    .Show
                End With
                
                'Termin-Ordner zum aktiven Ordner machen
                Set ActiveExplorer.CurrentFolder = objTerminordner
            End If
            
            'Termin vorlesen
            Call ItemRead(objTermin)
            'Zhler erhhen
            intCount = intCount + 1
        End If
    Next

    'Wenn keine flligen Termine anstehen, dann...
    If intCount = 0 Then
        '... entsprechende Nachricht vorlesen
        With frmVorlesen
            .Caption = "Keine Termine fllig"
            .wspMund.SetText "Heute sind keine Termine fllig."
            .Show
        End With
    End If
End Sub

Sub OptionenFestlegen()
    'Userform-Dialogfeld frmVorlesenOptionen aufrufen
    frmVorlesenOptionen.Show
End Sub

'*******************************************************************
'Hilfsroutinen
'*******************************************************************

Private Sub ItemRead(objItem As Object)
    'Liest den Inhalt eines Outlook-Elements vor
    Dim strCaption As String
    Dim strText As String

    'Nach Klasse des Outlook-Elements unterscheiden
    Select Case objItem.Class
    'Element ist eine Nachricht
    Case olMail
        'Titelzeile des frmVorlesen-Dialogfelds festlegen
        strCaption = "Nachricht von " & objItem.SenderName
        'Vorzulesenden Text festlegen
        strText = "Nachricht von " & objItem.SenderName & _
        ": Betreff: " & objItem.Subject & _
        " : : " & objItem.Body
    'Element ist eine Aufgabe
    Case olTask
        'Titelzeile des frmVorlesen-Dialogfelds festlegen
        strCaption = "Aufgabe: " & objItem.Subject
        'Vorzulesenden Text festlegen
        strText = objItem.Subject & _
        " : Fllig am " & Format(objItem.DueDate, "dd. mmmm yyyy") & " : Status: "
        Select Case objItem.Status
        Case olTaskComplete
            strText = strText & " Erledigt."
        Case olTaskDeferred
            strText = strText & " Zurckgestellt."
        Case olTaskInProgress
            strText = strText & " In Bearbeitung."
        Case olTaskNotStarted
            strText = strText & " Nicht begonnen."
        Case olTaskWaiting
            strText = strText & " Wartet auf jemand anderen."
        End Select
    'Element ist eine Notiz
    Case olNote
        'Titelzeile des frmVorlesen-Dialogfelds festlegen
        strCaption = "Notiz: " & objItem.Subject
        'Vorzulesenden Text festlegen
        strText = objItem.Subject
    'Element ist ein Kontakt
    Case olContact
        'Titelzeile des frmVorlesen-Dialogfelds festlegen
        strCaption = "Kontakt: " & objItem.Subject
        'Vorzulesenden Text festlegen
        strText = objItem.Subject & _
        IIf(objItem.BusinessTelephoneNumber > "", _
        " : Telefon: " & objItem.BusinessTelephoneNumber, "") & _
        IIf(objItem.MailingAddressStreet > "", _
        " : Adresse: " & objItem.MailingAddressStreet, "") & _
        IIf(objItem.MailingAddressCity > "", _
        " : " & objItem.MailingAddressCity, "")
    'Element ist ein Termin
    Case olAppointment
        'Titelzeile des frmVorlesen-Dialogfelds festlegen
        strCaption = "Termin: " & objItem.Subject
        'Vorzulesenden Text festlegen
        strText = objItem.Subject & _
        " : Start am " & Format(objItem.Start, "dd. mmmm yyyy") & IIf(objItem.AllDayEvent = False, " um " & Format(objItem.Start, "short time") & " Uhr", "") & _
        " : Ende am " & Format(objItem.End, "dd. mmmm yyyy") & IIf(objItem.AllDayEvent = False, " um " & Format(objItem.End, "short time") & " Uhr", "")
    'Element ist unbekannt
    Case Else
        'Titelzeile des frmVorlesen-Dialogfelds festlegen
        strCaption = "Outlook-Element: " & objItem.Subject
        'Vorzulesenden Text festlegen
        strText = objItem.Subject
    End Select

    'Wenn Elementffnen-Option gesetzt, dann...
    If CBool(GetSetting(APPNAME:="VBAMakros", Section:="OL_Vorlesen", Key:="Elementffnen", Default:="Falsch")) = True Then
        '... vorzulesendes Element ffnen
        objItem.Display
    End If
    
    'Userform frmVorlesen zum Vorlesen des Textes aufrufen
    With frmVorlesen
        .Caption = strCaption
        .wspMund.SetText strText
        .Show
    End With
End Sub
