// PLZ-Hack 
// tauscht Postleitzahl und Ort im Adrebuch
// in Palm OS 3.5 and 4.0
//
#include <PalmOS.h> // standard Palm OS Header

// Creator-ID fr PLZ-Hack (bei Palm registriert)
#define CREATORID 'plzH'
// Hacks sind Resource-Datenbanken mit Type 'HACK'
#define HACKTYPE 'HACK' 

// dieses Feature wird vom Hack-Manager
// mit der ursprnglichen Adresse belegt
#define ftrOldTrapAddress 1000 

// Funktionspointer fr DmGetResource
typedef MemHandle (*DmGetResourceP)(DmResType type, DmResID id);

// Prototyp Deklaration
MemHandle MyDmGetResource(DmResType  type, DmResID id);

// Forward-Deklarationen von Hilfsfunktionen
static Boolean isAddressBook();

/**
 * Eigene Version von DmGetResource.
 *
 * Die zu patchende Funktion mu die erste Funktion 
 * in der Source-Datei sein. Sie hat dieselbe Signatur
 * wie die entsprechende Betriebssystemfunktion.
 */
MemHandle MyDmGetResource(DmResType  type, DmResID id)
{
// hole Pointer der ursprnglichen Funktion
DmGetResourceP OriginalDmGetResource;
FtrGet(CREATORID,ftrOldTrapAddress,(UInt32*)&OriginalDmGetResource); //get old trap address from HackMaster

// Die Adrebuch-Anwendung ruft DmGetResource mit ID 1000
// ersetze durch eigene Version dieser Resource
if(type=='fmap' && id==1000 && isAddressBook())
	{
	MemHandle h;
	// ffne eigene Datenbank, so da eigene fmap-Resource geffnet werden kann
	DmOpenRef dbhack=DmOpenDatabaseByTypeCreator(HACKTYPE,CREATORID,dmModeReadOnly);
	// DmGet1Resource sucht nach einer Resource in der zuletzt geffneten
	// Datenbank, also unserem Hack
	h=DmGet1Resource(type,id); 
	DmCloseDatabase(dbhack);
	return h; // gib handle zur Resource zurck
	}
// in allen anderen Fllen, rufe Original-Funktion auf
return OriginalDmGetResource(type,id);
}

/**
 * Hilfsfunktion, gibt true zurck, 
 * falls die aktuelle Anwendung das Adrebuch ist
 */ 
static Boolean isAddressBook()
{
UInt16 cardNo;
LocalID	dbID;
UInt32 creator;
// SysCurAppDatabase gibt Card und local ID der aktuellen Anwendung zurck
if(SysCurAppDatabase(&cardNo,&dbID))
	return false;
// bestimme Creator aus Card und local ID	
if(DmDatabaseInfo(cardNo, dbID,
	NULL,NULL,NULL,
	NULL,NULL,NULL,
	NULL,NULL,
	NULL,NULL,&creator))
	return false;
// gib true zurck, falls creator = Adrebuch ist
return (creator==sysFileCAddress);
}
