' wordeigenedateien.vbs
' Ordnerinhalt dokumentieren
' Ausgabe erfolgt in Word-Tabellen
' (C) Tobias Weltner, c't 13/2001

'SYS: Skript Anfang
const wdCell = 12
const wdAutoFitFixed = 0
const wdWord9TableBehavior = 1
const wdPaneNone = 0
const wdNormalView = 1
const wdPageFitBestFit = 2
const wdSortFieldNumeric = 1
const wdSortFieldAlphanumeric = 0
const wdSortOrderAscending = 0

' Gre der leeren Tabelle
spalten = 3
zeilen = 1

' true = Ordnergren werden ermittelt (dauert lange!)
' false = Ordnergren werden NICHT ermittelt

zeigeordnergroesse = True

' Zugriff auf das Dateisystem herstellen:
'SYS: Microsoft (r) Script Runtime
Set fs = CreateObject("Scripting.FileSystemObject")
' Zugriff auf Word herstellen
'SYS: 
Set Word = CreateObject("Word.Application")

' Word sichtbar machen und leeres Dokument anlegen
Word.Visible = True
Set newdoc = Word.Documents.Add

' Rechtschreibprfung ausschalten und in Normalsicht schalten
newdoc.ShowGrammaticalErrors = False
newdoc.ShowSpellingErrors = False
If Word.ActiveWindow.View.SplitSpecial = wdPaneNone Then
   Word.ActiveWindow.ActivePane.View.Type = wdNormalView
Else
   Word.ActiveWindow.View.Type = wdNormalView
End If
Word.ActiveWindow.ActivePane.View.Zoom.PageFit = wdPageFitBestFit

' Ordner Eigene Dateien dokumentieren
set wshshell = CreateObject("WScript.Shell")
eigenedateien = wshshell.SpecialFolders("MyDocuments")
MsgBox "Dokumentiere den Ordner """ & eigenedateien & """"

FillFolder eigenedateien

Sub FillFolder(foldername)
   ' auf Ordner zugreifen
   Set folder = fs.GetFolder(foldername)
   
   ' Ordnerinfo ausgeben
   with Word.Selection
   .Style = newdoc.Styles("berschrift 1")
   .TypeText UCase(foldername)
   .TypeParagraph
   .Style = newdoc.Styles("berschrift 2")
   On Error Resume Next
   ' Gre des Ordners bestimmen
   ' kann schiefgehen, deshalb Fehlerhandling abschalten
   If zeigeordnergroesse Then
      ordnergroesse = folder.Size
   Else
      Err.Raise 1000
   End If
   
   If Err.number = 0 Then
      .TypeText "Gesamtgre: " & FormatNumber(ordnergroesse/1024^2,1) & " MB."
   Else
      .TypeText "Gesamtgre: nicht ermittelbar"
   End If
   On Error Goto 0
   
   ' Neue Zeile
   .TypeParagraph
   
   ' Neue Tabelle anlegen, 3x1
   newdoc.Tables.Add .Range, zeilen, spalten, wdWord9TableBehavior, wdAutoFitFixed
   ' Tabelle automatisch formatieren
   .Tables(1).AutoFormat 1, True, True, True, True, True, False, True, False, True
   
   ' erste Zeile der Tabelle ausfllen (berschrift)
   .TypeText "Datei/Ordner"
   .MoveRight wdCell
   .TypeText "Letzter Zugriff"
   .MoveRight wdCell
   .TypeText "Gre (MB)"
   
   ' alle Unterordner dieses Ordners eintragen
   For each subfolder in folder.SubFolders
      anzahl = anzahl + 1
      .MoveRight wdCell
      
      ' Ordnernamen in eckigen Klammern und Grobuchstaben
      .TypeText UCase("[" & subfolder.Name & "]")
      .MoveRight wdCell
      ' Datum des letzten Zugriffs ermitteln
      ' kann schiefgehen, weil nicht immer vorhanden
      ' deshalb Fehlerhandling ausschalten
      letzterzugriff = "[unbekannt]"
      On Error Resume Next
      letzterzugriff = CStr(subfolder.DateLastAccessed)
      On Error Goto 0
      .TypeText letzterzugriff
      .MoveRight wdCell
      
      ' Ordnergre ermitteln
      If zeigeordnergroesse Then
         .TypeText FormatNumber(subfolder.Size/1024^2,1)
      Else
         .TypeText "Gre wird nicht ermittelt."
      End If
   Next
   
   ' dasselbe mit den Dateien des Ordners machen
   For each file in folder.Files
      .MoveRight wdCell
      ' Dateinamen in Kleinbuchstaben
      .TypeText LCase(file.Name)
      .MoveRight wdCell
      letzterzugriff = "[unbekannt]"
      On Error Resume Next
      letzterzugriff = CStr(file.DateLastAccessed)
      On Error Goto 0
      .TypeText letzterzugriff
      .MoveRight wdCell
      
      .TypeText FormatNumber(file.Size/1024^2,1)
   Next
   
   ' Tabelle sortieren
   ' leere Tabellen verusachen einen Fehler, deshalb Fehlerhandling abschalten
   On Error Resume Next
   .Sort True, "Spalte1", wdSortFieldAlphanumeric, wdSortOrderAscending, _
   "Spalte3", wdSortFieldNumeric, wdSortOrderAscending
   On Error Goto 0
   ' neue Zeile
   .MoveDown 5,1
   .TypeParagraph
End with

' alle Unterordner dieses Ordners rekursiv aufrufen
' so werden alle Unterordner ebenfalls dokumentiert
For each subfolder in folder.SubFolders
   FillFolder subfolder.Path
Next
End Sub
