' exceladsi.vbs
' Gibt alle Kennwrter eines Rechners bersichtlich 
' in einer Excel-Tabelle aus
' (C) Tobias Weltner, c't 13/2001

Set fs = CreateObject("Scripting.FileSystemObject")
Set wshshell = CreateObject("WScript.Shell")
Set net = CreateObject("WScript.Network")

' welcher Computer soll untersucht werden?
computer = net.ComputerName
computer = InputBox("Bitte geben Sie den Computernamen an!",,computer)

Set obj = GetObject("WinNT://" & computer & ",computer")

' Excel Spreadsheet vorbereiten
Set objXL = CreateObject("Excel.Application")
objXL.Visible = True
objXL.Workbooks.Add
objXL.Columns(1).ColumnWidth = 30
objXL.Columns(2).ColumnWidth = 20
objXL.Columns(3).ColumnWidth = 50

objXL.Cells(1, 1).Value = "Kontoname"
objXL.Cells(1, 2).Value = "Kennwortalter"
objXL.Cells(1, 3).Value = "Letzte Benutzung"

objXL.Range("A1:C1").Select
objXL.Selection.Font.Bold = True
objXL.Selection.Interior.ColorIndex = 1
objXL.Selection.Interior.Pattern = 1 	'xlSolid
objXL.Selection.Font.ColorIndex = 2

' Daten beginnen in zweiter Zeile (erste Zeile ist berschrift)
intIndex = 2

' nur Gruppen-Objekte anzeigen
obj.Filter = Array("User")

For each benutzer in obj
   GetInfo(benutzer)
Next

MsgBox "Fertig.",vbInformation + vbSystemModal


Sub GetInfo(user)
   On Error Resume Next
   ' Alter des Kontos ermitteln:
   alter = user.Get("PasswordAge")
   If Err.number = 0 Then
     ' Zeitangabe ist in Sekunden, in Tage verwandeln
      tage = Fix(alter/60/60/24)
   Else
      tage = "[neu, unbenutzt]"
   End If
   err.clear
   ' Letzte Benutzung herausfinden
   alter = user.Get("LastLogin")
   If Err.number = 0 Then
      ' DateDiff ermittelt den Unterschied in Tagen zwischen zwei Daten
      ' now liefert die aktuelle Systemzeit
      benutzung = alter & " (vor " & DateDiff("d", alter, now) & " Tagen)."
   Else
      benutzung = "[noch nie benutzt]"
   End If

   On Error Goto 0

   objXL.Cells(intIndex, 1).Value = user.Name
   objXL.Cells(intIndex, 2).Value = tage
   objXL.Cells(intIndex, 3).Value = benutzung
   intIndex = intIndex + 1
End Sub

