(* Pascal/Delphi constants and function definitions for VC1.DLL *)

unit VC1;

{$A-}

interface

uses wintypes
  , winprocs
  , messages { hint: delete 'messages' for Pascal up to 7.x }
  ;


type
  bool       = longbool;
  TChar      = char;
  pTChar     = pChar;
  pTRect     = ^TRECT;

(* type declarations *)

  LPCTSTR                        = ^TCHAR;
  PSCEVENT                       = ^scEvent;
  PSCPROCESSINFO                 = ^scProcessInfo;

  scProcessInfo = record
     _nscProcessInfoVersion: cardinal;
     _nThreadID: cardinal;
     _szModule: array[0..35] of char;
	 _szPath: array[0..260] of char;
     end;

  scEvent = record
     _nscEventVersion: cardinal;
     _nUserParam: cardinal;
     _Process: scProcessInfo;
     _szDLL: array[0..8+1+3] of char;
     _nEvent: longint;
     _szParameter: array[0..260] of char;
     end;

const
  VC_VERSION_MAJOR               = 1;
  VC_VERSION_MINOR               = 2;
  VC_QUEST_CHECKPROCESS          = 1;
  VC_EVENT_EXECUTE		     	 = 10;
  VC_EVENT_CREATEOBJECT          = 11;
  VC_EVENT_CREATEFILE            = 12;
  VC_EVENT_FILE                  = 13;
  VC_EVENT_REGKEY                = 14;
  VC_EVENT_REGVALUE              = 15;
  VC_EVENTMASK                   = $00000fff;

  VC_EVENTTYPE_READ			     = $00001000;
  VC_EVENTTYPE_WRITE			 = $00002000;
  VC_EVENTTYPE_ENUM			     = $00004000;
  VC_EVENTTYPE_DELETE		     = $00008000;
  VC_EVENTTYPEMASK			     = $000ff000;

function   VcGetVersion
	(nType:                          integer
	): cardinal;
   stdcall;

function   VcInstall
	(hWnd:                           HWND;
	 nUserParam:                     longint
	): integer;
   stdcall;

procedure  VcUninstall;
   stdcall;

procedure  VcEnable
	(bEnable:                        bool
	);
   stdcall;


implementation

function   VcGetVersion;                   external 'VC1.DLL' name '_VcGetVersion@4';
function   VcInstall;                      external 'VC1.DLL' name '_VcInstall@8';
procedure  VcUninstall;                    external 'VC1.DLL' name '_VcUninstall@0';
procedure  VcEnable;                       external 'VC1.DLL' name '_VcEnable@4';

begin
end.
