unit frmMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Menus, StdCtrls, ExtCtrls, framEvent, vc1, Rules,
  ImgList, ActnList, ToolWin;

type
  TvcMainForm = class(TForm)
    MainMenu: TMainMenu;
    mnuFile: TMenuItem;
    FileNew: TMenuItem;
    FileOpen: TMenuItem;
    FileSave: TMenuItem;
    FileSaveAs: TMenuItem;
    FileDelim1: TMenuItem;
    FileExit: TMenuItem;
    mnuEdit: TMenuItem;
    EditNew: TMenuItem;
    EditDelete: TMenuItem;
    EditCut: TMenuItem;
    EditCopy: TMenuItem;
    EditPaste: TMenuItem;
    EditDelim1: TMenuItem;
    mnuHelp: TMenuItem;
    HelpAbout: TMenuItem;
    TreeRules: TTreeView;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Panel1: TPanel;
    Label1: TLabel;
    edtRuleName: TEdit;
    frameEventData1: TframeEventData;
    Label2: TLabel;
    cmbAction: TComboBox;
    Label3: TLabel;
    btnSaveRule: TButton;
    btnNewRule: TButton;
    btnDeleteRule: TButton;
    Options: TMenuItem;
    OptionsLog: TMenuItem;
    OptionsIntercept: TMenuItem;
    ImageList1: TImageList;
    FileSaveLog: TMenuItem;
    FileDelim2: TMenuItem;
    lstLog: TListView;
    OptionsDelim1: TMenuItem;
    OptionsLogOnlyDenied: TMenuItem;
    ImageList2: TImageList;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ActionList1: TActionList;
    New: TAction;
    Open: TAction;
    Save: TAction;
    SaveAs: TAction;
    SaveLog: TAction;
    ClearLog: TAction;
    Quit: TAction;
    Cut: TAction;
    Copy1: TAction;
    Paste: TAction;
    PasteBefore: TAction;
    NewRule: TAction;
    Delete: TAction;
    Intercept: TAction;
    Log: TAction;
    ShortLog: TAction;
    About: TAction;
    ToolButton10: TToolButton;
    EditPasteBefore: TMenuItem;
    Protokolllschen1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FileOpenClick(Sender: TObject);
    procedure FileSaveClick(Sender: TObject);
    procedure FileSaveAsClick(Sender: TObject);
    procedure FileExitClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FileNewClick(Sender: TObject);
    procedure TreeRulesChange(Sender: TObject; Node: TTreeNode);
    procedure TreeRulesChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure btnSaveRuleClick(Sender: TObject);
    procedure OnRuleChange(Sender: TObject);
    procedure EditNewRuleClick(Sender: TObject);
    procedure EditDeleteRuleClick(Sender: TObject);
    procedure WMCopyData(var msg: TMessage); message WM_COPYDATA;
    procedure OptionsInterceptClick(Sender: TObject);
    procedure OptionsLogClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpAboutClick(Sender: TObject);
    procedure FileSaveLogClick(Sender: TObject);
    procedure OptionsLogOnlyDeniedClick(Sender: TObject);
    procedure DoIdle(Sender: TObject; var Done: Boolean);
    procedure EditCopyClick(Sender: TObject);
    procedure EditPasteClick(Sender: TObject);
    procedure EditCutClick(Sender: TObject);
    procedure FileClearLogClick(Sender: TObject);

  private
    Rules : TStringList;
    RootRule : TRule;
    FileDirty, RuleDirty : Boolean;
    DoIntercept, DoLog, DoShortLog : Boolean;
    MyFileName : String;
    MyClipFmt: Word;
    procedure ClearRuleSet;
    procedure CreateRootRule;
    procedure LoadRuleSet(FileName: string);
    procedure SaveRuleSet(FileName: string);
    procedure FillTree;
    function CheckFileDirty : Boolean;
    function CheckRuleDirty : Boolean;
    function AskForInterception(evt, askingRule: TRule;
      var added: Boolean) : Integer;
    function FindRuleInTree(rule: TRule) : TTreeNode;
    procedure AddLogEntry(evt, rule: TRule; outcome: Integer);
    function FindUniqueName(base: String) : String;
  public
    { Public-Deklarationen }
  end;

var
  vcMainForm: TvcMainForm;

implementation

uses Clipbrd, frmAlert, About;

{$R *.DFM}

resourcestring
  SAppName = 'Virtual Cage';
  SBadFile      = 'Inkonsistente Datei';
  SQSaveChanges = 'Sollen nderungen gespeichert werden?';
  SQSaveRule    = 'Sollen nderungen an dieser Regel bernommen werden?';
  SQDeleteRule  = 'Regel und alle Unterregeln lschen?';
  SDupRule      = 'Doppelter Regelname.';
  STooManyChildren = 'Zu viele Unterregeln.';
  SFaultyTree   = 'Inkonsistenter Regelbaum.';
  SCantDelRoot  = 'Die erste Regel kann nicht gelscht werden.';
  SNameNewRule  = 'Name fr die neue Regel:';
  SRuleFilter   = 'VC-Regelstze (*.vc1)|*.vc1|Alle Dateien (*.*)|*.*';
  SLogFilter    = 'Textdateien (*.txt)|*.txt|Alle Dateien (*.*)|*.*';

////////////////////////////////////////////////////////////////////////////////
// Private Funktionen

procedure TvcMainForm.ClearRuleSet;
var idx : Integer;
    r: TRule;
begin
  for idx := 0 to Rules.Count - 1 do
  begin
    r := TRule(Rules.Objects[idx]);
    r.Free;
  end;
  Rules.Clear;
  TreeRules.Items.Clear;
  RootRule := nil;
end;

procedure TvcMainForm.CreateRootRule;
var node1: TTreeNode;
begin
  RootRule := TRule.Create;
  RootRule._rule._name := 'Leer';
  Rules.AddObject(RootRule._rule._name, RootRule);
  with TreeRules.Items do
  begin
    Clear;
    node1 := Add(nil, RootRule._rule._name);
    node1.Data := RootRule;
  end;
  node1.Expand(false);
  TreeRules.Selected := node1;
end;

procedure TvcMainForm.LoadRuleSet(FileName: string);
var f: File of vcRule;
    r, rp: TRule;
    idx: Integer;
    error : Boolean;
begin
  error := false;
  ClearRuleSet;
  AssignFile(f, FileName);
  Reset(f);
  while not (Eof(f) or error) do
  begin
    r := TRule.Create;
    Read(f, r._rule);
    with r._rule do
    begin
      Rules.AddObject(_name, r);
      Rules.Sort;
      _numChildren := 0;
      if (Rules.Count > 1) and Rules.Find(_parentName, idx) then
      begin
        rp := TRule(Rules.Objects[idx]);
        rp._children[rp._rule._numChildren] := r;
        Inc(rp._rule._numChildren);
      end
      else
        if Rules.Count > 1 then
        begin
          MessageDlg(SBadFile, mtError, [mbOK], 0);
          error := True;
        end
        else
          RootRule := r;
    end;
  end;
  CloseFile(f);

  if error then
    ClearRuleSet
  else
    FillTree;

  FileDirty := false;
end;

procedure TvcMainForm.SaveRuleSet(FileName: string);
var f: File of vcRule;

  procedure SaveRulesRecurse(r: TRule);
  var idx: Integer;
  begin
    Write(f, r._rule);
    for idx := 0 to r._rule._numChildren - 1 do
      SaveRulesRecurse(r._children[idx]);
  end;

begin // SaveRuleSet
  AssignFile(f, FileName);
  Rewrite(f);
  SaveRulesRecurse(RootRule);
  CloseFile(f);

  FileDirty := false;
end;

procedure TvcMainForm.FillTree;
  procedure FillNode(t: TTreeNode; r: TRule);
  var idx: Integer;
      t1: TTreeNode;
      r1: TRule;
  begin
    for idx := 0 to r._rule._numChildren - 1 do
    begin
      r1 := r._children[idx];
      t1 := TreeRules.Items.AddChildObject(t, r1._rule._name, r1);
      t1.ImageIndex := Integer(r1._rule._action);
      t1.SelectedIndex := Integer(r1._rule._action);
      FillNode(t1, r1);
    end;
  end;

var t: TTreeNode;
// Assuming TreeRules is empty and root rule is in Rules[0]
begin // FillTree
  if (Rules.Count > 0) and (TreeRules.Items.Count = 0) then
  begin // FillTree
    t := TreeRules.Items.Add(nil, RootRule._rule._name);
    t.ImageIndex := Integer(RootRule._rule._action);
    t.SelectedIndex := Integer(RootRule._rule._action);
    t.Data := RootRule;
    FillNode(t, RootRule);
    t.Expand(false);
    TreeRules.Selected := t;
  end;
end;

function TvcMainForm.CheckFileDirty : Boolean;
var answer : Integer;
begin
  result := CheckRuleDirty;
  if result and FileDirty then
  begin
    answer := MessageDlg(SQSaveChanges, mtConfirmation,
                         mbYesNoCancel, 0);
    if answer = IDYES then
    begin
      FileSaveClick(nil);
      result := not FileDirty;
    end
    else if answer = IDCANCEL then
      result := false;
  end;
end;

function TvcMainForm.CheckRuleDirty : Boolean;
var answer : Integer;
begin
  result := true;
  if RuleDirty then
  begin
    answer := MessageDlg(SQSaveRule, mtConfirmation,
                         mbYesNoCancel, 0);
    if answer = IDYES then
    begin
      btnSaveRuleClick(nil);
      result := not RuleDirty;
    end
    else if answer = IDCANCEL then
      result := false;
  end;
end;

function TvcMainForm.AskForInterception(evt, askingRule: TRule;
                                        var added: Boolean): Integer;
var answer: Integer;
    t, t1: TTreeNode;
    newName: String;
    hFG: HWnd;
begin
  hFG := GetForegroundWindow();
  SetForegroundWindow(Handle);
  vcAlertForm.frameEventData1.SetEvent(evt);
  vcAlertForm.chkSave.Checked := false;
  vcAlertForm.chkSave.Enabled :=
                     (evt._rule._numChildren < MAX_CHILDREN_PER_RULE);
  answer := vcAlertForm.ShowModal;
  added := false;
  if answer = mrYes then
    Result := 0
  else
    Result := 1;
  if vcAlertForm.chkSave.Checked then
  begin
    newName := FindUniqueName(askingRule._rule._name);
    if InputQuery(SAppName, SNameNewRule, newName) then
    begin
      vcAlertForm.frameEventData1.GetEvent(evt);
      StrPCopy(evt._rule._name, newName);
      evt._rule._parentName := askingRule._rule._name;
      askingRule._children[askingRule._rule._numChildren] := evt;
      Inc(askingRule._rule._numChildren);
      Rules.AddObject(newName, evt);
      Rules.Sort;
      t := FindRuleInTree(askingRule);
      t1 := TreeRules.Items.AddChildObject(t, newName, evt);
      t1.ImageIndex := Integer(evt._rule._action);
      t1.SelectedIndex := Integer(evt._rule._action);
      if Visible then
        TreeRules.Selected := t1;
      added := true;
      FileDirty := true;
    end;
  end;
  SetForegroundWindow(hFG);
end;

function TvcMainForm.FindRuleInTree(rule: TRule) : TTreeNode;
var idx: Integer;
begin
  idx := 0;
  Result := nil;
  while (Result = nil) and (idx < TreeRules.Items.Count) do
    if TreeRules.Items[idx].Data = rule then
      Result := TreeRules.Items[idx]
    else
      Inc(idx);
end;

procedure TvcMainForm.AddLogEntry(evt, rule: TRule; outcome: Integer);
var t: TListItem;
    action: string;
    img: Integer;
begin
  img := 0;
  case rule._rule._action of
    vcAllow:
      begin
        img := 0;
        action := 'Erlaubt';
      end;
    vcDeny:
      begin
        img := 1;
        action := 'Unterdrckt';
      end;
    vcAsk:
      begin
        action := 'Auf Nachfrage ';
        if outcome = 0 then
        begin
          img := 4;
          action := action + 'erlaubt';
        end
        else
        begin
          img := 5;
          action := action + 'unterdrckt';
        end;
      end;
  end;
  t := lstLog.Items.Insert(lstLog.Items.Count);
  with t, evt._rule._event do
  begin
    ImageIndex := img;
    Caption := _Process._szModule;
    SubItems.Append(_Process._szPath);
    SubItems.Append(_szDLL);
    SubItems.Append(StringFromEvent(_nEvent));
    SubItems.Append(StringFromEventType(_nEvent));
    SubItems.Append(_szParameter);
  end;
  with t, rule._rule do
  begin
    SubItems.Append(action);
    SubItems.Append(_name);
  end;
end;

function TvcMainForm.FindUniqueName(base: String) : String;
var num, dummy: Integer;
begin
  if not Rules.Find(base, dummy) then
    result := base
  else
  begin
    num := 1;
    while Rules.Find(base + IntToStr(num), dummy) do
      Inc(num);
    result := base + IntToStr(num);
  end;
end;

//////////////////////////////////////////////////////////////////////
// Ereignisbehandlung

procedure TvcMainForm.FormCreate(Sender: TObject);
var sFmt: array[0..10] of Char;
    par: Integer;
    sPar: string;
begin
  Rules := TStringList.Create;

  MyFileName := '';
  FileDirty := false;
  RuleDirty := false;
  DoIntercept := false;
  DoLog := true;
  DoShortLog := false;
  Application.OnIdle := DoIdle;

  CreateRootRule;

  MyClipFmt := RegisterClipboardFormat(StrPCopy(sFmt, 'VCRule'));

  for par := 1 to ParamCount do
  begin
    sPar := ParamStr(par);
    if sPar[1] in ['-', '/'] then
    begin
      sPar := Copy(sPar, 2, length(sPar));
      if CompareStr(sPar, 'on') = 0 then
        DoIntercept := true
      else if CompareStr(sPar, 'off') = 0 then
        DoIntercept := false
      else if CompareStr(sPar, 'log') = 0 then
        DoLog := true
      else if CompareStr(sPar, 'nolog') = 0 then
        DoLog := false
    end
    else
      MyFileName := sPar;
  end;
  if MyFileName <> '' then
  begin
    LoadRuleSet(MyFileName);
    self.Caption := SAppName + ' - ' + ExtractFileName(MyFileName);
  end;

  VcInstall(self.Handle,0);
  if not DoIntercept then
    VcEnable(false);
end;

procedure TvcMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if CheckFileDirty then
    Action := caFree
  else
    Action := caNone;
end;

procedure TvcMainForm.FormDestroy(Sender: TObject);
begin
  VcEnable(FALSE);
  VcUninstall;
end;

procedure TvcMainForm.TreeRulesChange(Sender: TObject; Node: TTreeNode);
var r: TRule;
begin
  r := TRule(Node.Data);
  edtRuleName.Text := r._rule._name;
  frameEventData1.SetEvent(r);
  cmbAction.ItemIndex := Integer(r._rule._action);
  RuleDirty := false;
end;

procedure TvcMainForm.TreeRulesChanging(Sender: TObject; Node: TTreeNode;
  var AllowChange: Boolean);
begin
  AllowChange := CheckRuleDirty;
end;

procedure TvcMainForm.OnRuleChange(Sender: TObject);
begin
  RuleDirty := TRUE;
end;

procedure TvcMainForm.DoIdle(Sender: TObject; var Done: Boolean);
begin
  SaveLog.Enabled := (lstLog.Items.Count <> 0);
  ClearLog.Enabled := SaveLog.Enabled;
  Cut.Enabled := (TRule(TreeRules.Selected.Data) <> RootRule);
  Delete.Enabled := EditCut.Enabled;
  Paste.Enabled := Clipboard.HasFormat(MyClipFmt);
  PasteBefore.Enabled := (Cut.Enabled and Paste.Enabled);
  Intercept.Checked := DoIntercept;
  if DoIntercept then
    Intercept.ImageIndex := 8
  else
    Intercept.ImageIndex := 7;
  Log.Checked := DoLog;
  ShortLog.Enabled := DoLog;
  ShortLog.Checked := (DoLog and DoShortLog);
end;

///// Hier ist der Einstiegspunkt fr die DLL /////
procedure TvcMainForm.WMCopyData(var msg: TMessage);
var pCDS: PCOPYDATASTRUCT;
    pEvent: PSCEVENT;
    evt, activeRule: TRule;
    dontDelete: Boolean;
begin
  msg.Result := 0;
  dontDelete := false;
  pCDS := PCOPYDATASTRUCT(msg.lParam);
  if pCDS^.dwData = 0 then
  begin
    pEvent := PSCEVENT(pCDS^.lpData);
    evt := TRule.Create;
    evt._rule._event := pEvent^;
    activeRule := RootRule;
    case RootRule.GetAnswer(evt, activeRule) of
      vcDeny:
        msg.Result := 1;
      vcAllow:
        msg.Result := 0;
      vcAsk:
        msg.Result := AskForInterception(evt, activeRule, dontDelete);
    end;
    if DoLog then
      if (not DoShortLog) or (msg.Result <> 0) then
        AddLogEntry(evt, activeRule, msg.Result);
    if not dontDelete then
      evt.Free;
  end;
end;

//////////////////////////////////////////////////////////////////////
// Men und Knpfe

procedure TvcMainForm.FileNewClick(Sender: TObject);
begin
  if not CheckFileDirty then
    Exit;
  ClearRuleSet;
  MyFileName := '';
  Caption := SAppName;
  FileDirty := false;
  RuleDirty := false;
  CreateRootRule;
end;

procedure TvcMainForm.FileOpenClick(Sender: TObject);
begin
  if not CheckFileDirty then
    Exit;
  with OpenDialog1 do
  begin
    Filter := SRuleFilter;
    Options := [ofHideReadOnly, ofFileMustExist, ofEnableSizing];
    if Execute then
    begin
      LoadRuleSet(FileName);
      MyFileName := FileName;
      self.Caption := SAppName + ' - ' + ExtractFileName(MyFileName);
    end;
  end;
end;

procedure TvcMainForm.FileSaveClick(Sender: TObject);
begin
  if MyFileName = '' then
    FileSaveAsClick(Sender)
  else
    SaveRuleSet(MyFileName);
end;

procedure TvcMainForm.FileSaveAsClick(Sender: TObject);
begin
  with SaveDialog1 do
  begin
    Filter := SRuleFilter;
    DefaultExt := 'vc1';
    Options := [ofHideReadOnly, ofPathMustExist, ofEnableSizing, ofOverwritePrompt];
    if Execute then
    begin
      SaveRuleSet(FileName);
      MyFileName := FileName;
      self.Caption := SAppName + ' - ' + ExtractFileName(MyFileName);
    end;
  end;
end;

procedure TvcMainForm.FileSaveLogClick(Sender: TObject);
var f: TextFile;
    s: String;
    r, c: Integer;
begin
  vcEnable(false); // Keine Ahnung, warum das hier sein muss und ein paar Zeilen hher nicht
  with SaveDialog1 do
  begin
    Filter := SLogFilter;
    FileName := 'vclog.txt';
    Options := [ofHideReadOnly, ofPathMustExist, ofEnableSizing, ofOverwritePrompt];
    if Execute then
    begin
      AssignFile(f, FileName);
      Rewrite(f);
      with lstLog do
        for r := 0 to Items.Count - 1 do
          with Items[r] do
          begin
            s := Caption;
            for c := 0 to SubItems.Count - 1 do
              s := s + #9 + SubItems[c];
            WriteLn(f, s);
          end;
      CloseFile(f);
    end;
  end;
  vcEnable(DoIntercept);
end;

procedure TvcMainForm.FileClearLogClick(Sender: TObject);
begin
  lstLog.Items.Clear;
end;

procedure TvcMainForm.FileExitClick(Sender: TObject);
begin
  Close;
end;

procedure TvcMainForm.EditCutClick(Sender: TObject);
begin
  EditCopyClick(Sender);
  EditDeleteRuleClick(Sender);
end;

procedure TvcMainForm.EditCopyClick(Sender: TObject);
var t: TTreeNode;
    r: TRule;
    strm: TMemoryStream;
    rCount: Integer;
    h: THandle;
    p: Pointer;

  procedure CopyRulesRecurse(r: TRule);
  var idx: Integer;
  begin
    Inc(rCount);
    strm.Write(r._rule, SizeOf(vcRule));
    for idx := 0 to r._rule._numChildren - 1 do
      CopyRulesRecurse(r._children[idx]);
  end;

begin // EditCopyClick
  if not CheckRuleDirty then
    Exit;
  t := TreeRules.Selected;
  r := TRule(t.Data);
  strm := TMemoryStream.Create;
  rCount := 0;
  strm.Write(rCount, SizeOf(rCount)); // placeholder
  CopyRulesRecurse(r);
  strm.Seek(0, soFromBeginning);
  strm.Write(rCount, SizeOf(rCount));
  h := GlobalAlloc(GMEM_MOVEABLE or GMEM_DDESHARE, strm.Size);
  p := GlobalLock(h);
  Move(strm.Memory^, p^, strm.Size);
  with Clipboard do
  begin
    Open;
    Clear;
    SetAsHandle(MyClipFmt, h);
    Close;
  end;
  GlobalUnlock(h);
  strm.Free;
end;

procedure TvcMainForm.EditPasteClick(Sender: TObject);
var t: TTreeNode;
    r: TRule;
    strm: TMemoryStream;
    siz, rPos: Integer;
    h: THandle;
    p: Pointer;
    newName: String;

  procedure PasteRulesRecurse(rParent: TRule; tParent: TTreeNode; pos: Integer);
  var idx, rCount: Integer;
      t1: TTreeNode;
      r1: TRule;
  begin
    r1 := TRule.Create;
    strm.Read(r1._rule, SizeOf(vcRule));
    newName := FindUniqueName(r1._rule._name);
    StrPCopy(r1._rule._name, newName);
    r1._rule._parentName := rParent._rule._name;
    if pos = -1 then
    begin
      rParent._children[rParent._rule._numChildren] := r1;
      t1 := TreeRules.Items.AddChildObject(tParent, newName, r1);
    end
    else
    begin
      for idx := rParent._rule._numChildren downto pos+1 do
        rParent._children[idx] := rParent._children[idx-1];
      rParent._children[pos] := r1;
      t1 := tParent.getFirstChild;
      for idx := 1 to pos do
        t1 := tParent.GetNextChild(t1);
      t1 := TreeRules.Items.InsertObject(t1, newName, r1);
    end;
    Inc(rParent._rule._numChildren);
    Rules.AddObject(newName, r1);
    Rules.Sort;
    t1.ImageIndex := Integer(r1._rule._action);
    t1.SelectedIndex := Integer(r1._rule._action);
    rCount := r1._rule._numChildren;
    r1._rule._numChildren := 0;
    for idx := 0 to rCount - 1 do
      PasteRulesRecurse(r1, t1, -1);
  end;

begin // EditPasteClick
  if not Clipboard.HasFormat(MyClipFmt) then
    exit;
  t := TreeRules.Selected;
  r := TRule(t.Data);
  if Sender = PasteBefore then
  begin
    t := t.Parent;
    rPos := 0;
    while (TRule(t.Data)._children[rPos] <> r) and (rPos < MAX_CHILDREN_PER_RULE) do
      Inc(rPos);
    r := TRule(t.Data);
  end
  else
    rPos := -1;
  if r._rule._numChildren < MAX_CHILDREN_PER_RULE then
  begin
    strm := TMemoryStream.Create;
    with Clipboard do
    begin
      Open;
      h := GetAsHandle(MyClipFmt);
      p := GlobalLock(h);
      Move(p^, siz, SizeOf(Integer));
      siz := sizeof(Integer) + siz * sizeof(vcRule);
      strm.SetSize(siz);
      Move(p^, strm.Memory^, siz);
      GlobalUnlock(h);
      Close;
    end;
    strm.Seek(SizeOf(Integer), soFromBeginning);
    PasteRulesRecurse(r, t, rPos);
    if not t.Expanded then
      t.Expand(false);
    FileDirty := true;
  end
  else
    MessageDlg(STooManyChildren, mtWarning, [mbOK], 0);
end;

procedure TvcMainForm.EditNewRuleClick(Sender: TObject);
var t, t1: TTreeNode;
    r, r1: TRule;
    newName: String;
begin
  if not CheckRuleDirty then
    Exit;
  t := TreeRules.Selected;
  r := TRule(t.Data);
  if r._rule._numChildren < MAX_CHILDREN_PER_RULE then
  begin
    newName := FindUniqueName(t.Text);
    r1 := TRule.Create;
    r1._rule._event := r._rule._event;
    StrPCopy(r1._rule._name, newName);
    r1._rule._parentName := r._rule._name;
    case r._rule._action of
      vcAllow:
        r1._rule._action := vcDeny;
      vcDeny:
        r1._rule._action := vcAllow;
      vcAsk:
        r1._rule._action := vcAsk;
    end;
    r._children[r._rule._numChildren] := r1;
    Inc(r._rule._numChildren);
    Rules.AddObject(newName, r1);
    Rules.Sort;
    t1 := TreeRules.Items.AddChildObject(t, newName, r1);
    t1.ImageIndex := Integer(r1._rule._action);
    t1.SelectedIndex := Integer(r1._rule._action);
    TreeRules.Selected := t1;
    FileDirty := true;
    edtRuleName.SetFocus;
  end
  else
    MessageDlg(STooManyChildren, mtWarning, [mbOK], 0);
end;

procedure TvcMainForm.EditDeleteRuleClick(Sender: TObject);

  procedure DeleteChildRules(r: TRule; t: TTreeNode);
  var t1: TTreeNode;
      r1: TRule;
      ridx, tidx, didx: Integer;
  begin
    for ridx := 0 to r._rule._numChildren - 1 do
    begin
      r1 := r._children[ridx];
      tidx := 0;
      while (tidx < t.Count) and (t.Item[tidx].Data <> r1) do
        Inc(tidx);
      if tidx < t.Count then
      begin
        t1 := t.Item[tidx];
        DeleteChildRules(r1, t1);
        TreeRules.Items.Delete(t1);
      end
      else
      begin
        MessageDlg(SFaultyTree, mtWarning, [mbOK], 0);
        break;
      end;
      didx := Rules.IndexOfObject(r1);
      r1.Free;
      Rules.Delete(didx);
    end;
  end;

var t, t1: TTreeNode;
    r, r1: TRule;
    idx, pidx, answer: Integer;
begin // EditDeleteRuleClick
  t := TreeRules.Selected;
  r := TRule(t.Data);
  if r <> RootRule then
  begin
    answer := IDYES;
    if (t.Count > 0) and (Sender = Delete) then
      answer := MessageDlg(SQDeleteRule, mtConfirmation, [mbYes, mbNo], 0);
    if answer = IDYES then
    begin
      RuleDirty := false;
      DeleteChildRules(r, t);
      t1 := t.Parent;
      TreeRules.Items.Delete(t);
      Rules.Find(r._rule._parentName, pidx);
      r1 := TRule(Rules.Objects[pidx]);
      idx := 0;
      with r1._rule do
      begin
        while (idx < _numChildren) and (r1._children[idx] <> r) do
          Inc(idx);
        while idx < _numChildren do
        begin
          r1._children[idx] := r1._children[idx + 1];
          Inc(idx);
        end;
        Dec(_numChildren);
      end;
      idx := Rules.IndexOfObject(r);
      r.Free;
      Rules.Delete(idx);
      TreeRules.Selected := t1;
      FileDirty := true;
    end;
  end
  else
    MessageDlg(SCantDelRoot, mtWarning, [mbOK], 0);
end;

procedure TvcMainForm.btnSaveRuleClick(Sender: TObject);
var t: TTreeNode;
    r, r1: TRule;
    idx: Integer;
    error: Boolean;
begin
  if RuleDirty then
  begin
    error := false;
    t := TreeRules.Selected;
    r := TRule(t.Data);
    if Rules.Find(edtRuleName.Text, idx) then
    begin
      r1 := TRule(Rules.Objects[idx]);
      if r1 <> r then
      begin
        MessageDlg(SDupRule, mtWarning, [mbOK], 0);
        error := true;
      end;
    end;
    if not error then
    begin
      t.Text := edtRuleName.Text;
      with r._rule do
      begin
        Rules.Find(_name, idx);
        Rules.Strings[idx] := edtRuleName.Text;
        StrPCopy(_name, edtRuleName.Text);
        frameEventData1.GetEvent(r);
        if cmbAction.ItemIndex <> -1 then
        begin
          _action := vcAction(cmbAction.ItemIndex);
          t.ImageIndex := cmbAction.ItemIndex;
          t.SelectedIndex := cmbAction.ItemIndex;
        end;
        RuleDirty := false;
        FileDirty := true;
      end;
    end;
  end;
end;

procedure TvcMainForm.OptionsInterceptClick(Sender: TObject);
begin
  DoIntercept := not DoIntercept;
  VcEnable(DoIntercept);
end;

procedure TvcMainForm.OptionsLogClick(Sender: TObject);
begin
  DoLog := not DoLog;
end;

procedure TvcMainForm.OptionsLogOnlyDeniedClick(Sender: TObject);
begin
  if OptionsLogOnlyDenied.Enabled then
    DoShortLog := not DoShortLog;
end;

procedure TvcMainForm.HelpAboutClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

end.



