#include "vc.h"

typedef HINSTANCE (WINAPI* LOADLIBRARYA)(LPCSTR);
typedef HINSTANCE (WINAPI* LOADLIBRARYW)(LPCWSTR);
typedef HINSTANCE (WINAPI* LOADLIBRARYEXA)(LPCSTR,HANDLE,DWORD);
typedef HINSTANCE (WINAPI* LOADLIBRARYEXW)(LPCWSTR,HANDLE,DWORD);
typedef FARPROC	  (WINAPI* GETPROCADDRESS)(HMODULE,LPCSTR);

typedef UINT32 	  (WINAPI* FCT0)(void);
typedef UINT32 	  (WINAPI* FCT1)(UINT32);
typedef UINT32 	  (WINAPI* FCT2)(UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT3)(UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT4)(UINT32,UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT5)(UINT32,UINT32,UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT6)(UINT32,UINT32,UINT32,UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT7)(UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT8)(UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT9)(UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT10)(UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT11)(UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT12)(UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32);
typedef UINT32 	  (WINAPI* FCT13)(UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32,UINT32);

#define	ARG(i)			(pFrame[(i)])
#define	SETRES(v)		pFrame[-1] = (UINT32)(v);
#define	CALLORGFLAG 	pFrame[-2]

//////////////////////////////////////////////////////////////////////////////
// helper class: a class to complete a relative path to the full path length,
// Unicode/MBCS aware with auto-conversion
// Returns in MBCS always as AskManager() expects this.

class clsFilename
	{
	private:
			CHAR*		_pszFilename;

			void		Init(LPCSTR pszFilename, BOOL bCheckForParameters)
							{
							_pszFilename = new CHAR[_MAX_PATH];
							strcpy(_pszFilename,pszFilename);
							if (*_pszFilename == '\"')
								{
								strcpy(_pszFilename,_pszFilename+1);
								if (strchr(_pszFilename,'\"'))
									*strchr(_pszFilename,'\"') = 0;
								}
							  else
							  	if (bCheckForParameters)
									{
									if (strchr(_pszFilename,' '))
										*strchr(_pszFilename,' ') = 0;
									}
							_fullpath(_pszFilename,_pszFilename,_MAX_PATH);
							}	
	public:			
						clsFilename(LPCSTR pszFilename, BOOL bCheckForParameters = FALSE)
							{
							Init(pszFilename,bCheckForParameters);
							}
						clsFilename(LPCWSTR pszFilename, BOOL bCheckForParameters = FALSE)
							{
							Init(clsCharsetConversionString(pszFilename),bCheckForParameters);
							}
						~clsFilename(void)
							{
							delete[] _pszFilename;
							}
			operator LPCSTR()
							{
							return(_pszFilename);
							}
	};
	
//////////////////////////////////////////////////////////////////////////////
// convert a CLSID to a CLSID String
// (there is an OLE API for this, but I don't want to use any OLE API as we want as
//  little footprint as possible!)

LPCSTR CLSIDString(CLSID* pCLSID, LPSTR pszParam)
{
	sprintf(pszParam,"{%08lx-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x}",
			pCLSID->Data1,
			pCLSID->Data2,
			pCLSID->Data3,
			pCLSID->Data4[0],
			pCLSID->Data4[1],
			pCLSID->Data4[2],
			pCLSID->Data4[3],
			pCLSID->Data4[4],
			pCLSID->Data4[5],
			pCLSID->Data4[6],
			pCLSID->Data4[7]);
	return(pszParam);
}			

//////////////////////////////////////////////////////////////////////////////

#if USE_STL
	#if defined(_MSC_VER)
		typedef map<HKEY,CHAR*,less<HKEY>,allocator<CHAR*> >::iterator	RegKeyPathIter;
	  #else
		struct eqHKEY
		{
	  		bool operator()(HKEY p1, HKEY p2) const { return(p1 == p2); }
		};
		struct hash<HKEY*>
		{
	  		size_t operator()(HKEY* __x) const { return((size_t)__x); }
		};
		typedef hash_map<HKEY,CHAR*,hash<HKEY>,eqHKEY>::iterator		RegKeyPathIter;
	#endif
  #else
	typedef WCValSkipListDictIter<HKEY,CHAR*>	RegKeyPathIter;
#endif

class clsRegKeyPathList
	{
	private:
		#if USE_STL
			#if defined(_MSC_VER)
				map<HKEY,CHAR*,less<HKEY>,allocator<CHAR*> > _RegKeyPathList;
			  #else
				hash_map<HKEY,CHAR*,hash<HKEY>,eqHKEY>	_RegKeyPathList;
			#endif
		  #else
		  	WCValSkipListDict<HKEY,CHAR*>	_RegKeyPathList;
		#endif
	public:
						~clsRegKeyPathList(void);
	
			CHAR*		GetRegHKEY(HKEY hKey, LPCSTR pszBranch, LPCSTR pszKey);
			void 		SetRegHKEY(HKEY hKey, CHAR* pszKey);
			void		CloseRegHKEY(HKEY hKey);
	};

clsRegKeyPathList::~clsRegKeyPathList(void)
{
	LIST_FORALL(_RegKeyPathList,RegKeyPathIter,iter)
		{
		delete ITER_VALUE(iter);
		}
	LIST_CLEAR(_RegKeyPathList);
}

CHAR*	clsRegKeyPathList::GetRegHKEY(HKEY hKey, LPCSTR pszBranch, LPCSTR pszKey)
{
	static	CHAR	__szKey[1024]; // assumed this as maximum key length...
	CHAR*	pszEntry;
	
	LIST_FIND(_RegKeyPathList,hKey,pszEntry);
	
	if (pszEntry)
		{
		strcpy(__szKey,pszEntry);
		if (__szKey[strlen(__szKey)-1] != '\\')
			strcat(__szKey,TEXT("\\"));
		}
	  else
	  	switch ((UINT32)hKey)
	  		{
			case (UINT32)HKEY_CLASSES_ROOT:
				strcpy(__szKey,TEXT("HKEY_CLASSES_ROOT\\"));
				break;
			case (UINT32)HKEY_LOCAL_MACHINE:
				strcpy(__szKey,TEXT("HKEY_LOCAL_MACHINE\\"));
				break;
			case (UINT32)HKEY_CURRENT_USER:
				strcpy(__szKey,TEXT("HKEY_CURRENT_USER\\"));
				break;
			case (UINT32)HKEY_USERS:
				strcpy(__szKey,TEXT("HKEY_USERS\\"));
				break;
			case (UINT32)HKEY_CURRENT_CONFIG:
				strcpy(__szKey,TEXT("HKEY_CURRENT_CONFIG\\"));
				break;
			case (UINT32)HKEY_PERFORMANCE_DATA:
				strcpy(__szKey,TEXT("HKEY_PERFORMANCE_DATA\\"));
				break;
			case (UINT32)HKEY_DYN_DATA:
				strcpy(__szKey,TEXT("HKEY_DYN_DATA\\"));
				break;
			default:
				strcpy(__szKey,TEXT("HKEY_???\\"));
				break;
	  		}
	if (pszBranch)
		{
		strcat(__szKey,pszBranch);
		if (__szKey[strlen(__szKey)-1] != '\\')
			strcat(__szKey,TEXT("\\"));
		}
	if (pszKey)	
		strcat(__szKey,pszKey);
	return(__szKey);	
}

void clsRegKeyPathList::SetRegHKEY(HKEY hKey, CHAR* pszKey)
{
	INT		nLen = strlen(pszKey);
	CHAR*	pszVal = new CHAR[nLen+1];
	
	strcpy(pszVal,pszKey);
	LIST_INSERT(_RegKeyPathList,hKey,pszVal);
}

void		clsRegKeyPathList::CloseRegHKEY(HKEY hKey)
{
	CHAR*	pszEntry;
	
	LIST_FIND(_RegKeyPathList,hKey,pszEntry);
	
	if (pszEntry)
		{
		LIST_REMOVE(_RegKeyPathList,hKey);
		delete pszEntry;
		}
}

clsRegKeyPathList	__RegKeyPathList;

//////////////////////////////////////////////////////////////////////////////

UINT32		CallOrgAPI(scFunction* pFunction, UINT32* pFrame)
{
	switch (pFunction->_nParams)
		{
		case 0:		return(((FCT0)(pFunction->_pfnOrgAddress))());
		case 1:		return(((FCT1)(pFunction->_pfnOrgAddress))(ARG(1)));
		case 2:		return(((FCT2)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2)));
		case 3:		return(((FCT3)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3)));
		case 4:		return(((FCT4)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4)));
		case 5:		return(((FCT5)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5)));
		case 6:		return(((FCT6)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5),ARG(6)));
		case 7:		return(((FCT7)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5),ARG(6),ARG(7)));
		case 8:		return(((FCT8)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5),ARG(6),ARG(7),ARG(8)));
		case 9:		return(((FCT9)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5),ARG(6),ARG(7),ARG(8),ARG(9)));
		case 10:	return(((FCT10)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5),ARG(6),ARG(7),ARG(8),ARG(9),ARG(10)));
		case 11:	return(((FCT11)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5),ARG(6),ARG(7),ARG(8),ARG(9),ARG(10),ARG(11)));
		case 12:	return(((FCT12)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5),ARG(6),ARG(7),ARG(8),ARG(9),ARG(10),ARG(11),ARG(12)));
		case 13:	return(((FCT13)(pFunction->_pfnOrgAddress))(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5),ARG(6),ARG(7),ARG(8),ARG(9),ARG(10),ARG(11),ARG(12),ARG(13)));
		}
	return(0);	
}

//////////////////////////////////////////////////////////////////////////////

void __stdcall Interceptor(scFunction* pFunction, UINT32* pFrame)
{
	/*
		pFrame[1...] = parameter 1, ...
		pFrame[0] = return address
		pFrame[-1] = EAX;		(return value)
		pFrame[-2] = CallOrgAPI flag (1 to call original API, 0 to return with return value in pFrame[-1];
	*/

	CALLORGFLAG = TRUE;

	// just to make sure... 
	if (__pData == NULL || 
		__pData->_bDisabled)
		{
		return;
		}
	
	// synchronize this function on a per-thread base
	// (as it's not known reliably, which classes and functions are guaranteed to be thread-safe)
	clsThreadProtection	ThreadProtection(__ThreadSyncObject);

	LONG				lRes;
	HRESULT				hRes;
	
	SETRES(0);
	
	/*
	non-explainable behaviour: the next call to a Windows API after a LoadLibrary(comctl32) call
	gets the wrong address - it seems that someone also patches the IAT and
	uses its patched pointer, which points to our routine. Thus an endless recursion follows.
	Thus I use the "original" API address from scAPIFunction
	*/
	
	HookDebug("intercepting %d",pFunction->_nFunction);

	if (_tcscmp(__Process._szModule,TEXT("MSDEV.EXE")) == 0)
		{
		__asm {int 3}
		}
	switch (pFunction->_nFunction)
		{
		case FCT_GETPROCADDRESS:
			{
			FARPROC		pfnProc = (FARPROC)CallOrgAPI(pFunction,pFrame);
			// look it up in our table!
			if (pfnProc)
				pfnProc = InterceptProc(pfnProc);
			// return value is proc address	
			SETRES(pfnProc);
			// don't call original function, this has already been done!
			CALLORGFLAG = FALSE; 
			}
			break;
		case FCT_LOADLIBRARY:
		case FCT_LOADLIBRARYEX:
			/*
			HINSTANCE LoadLibrary(
			    LPCTSTR lpLibFileName 	// address of filename of executable module 
			   );
			HINSTANCE LoadLibraryEx(
			    LPCTSTR lpLibFileName,	// points to name of executable module
			    HANDLE hFile,	// reserved, must be NULL 
			    DWORD dwFlags 	// entry-point execution flag 
			   );	
			*/
			{
			HINSTANCE	hInstance = (HINSTANCE)CallOrgAPI(pFunction,pFrame);

			// now hook to the new modules!	
			if (hInstance != NULL)
				InterceptFunctionsInTask(TRUE);
			// return value is instance handle	
			SETRES(hInstance);
			// don't call original function, this has already been done!
			CALLORGFLAG = FALSE; 
			}	
			break;
		default:
			{
		    MEMORY_BASIC_INFORMATION 	mbi;
			CHAR*						pszDLL;
			CHAR						szCLSID[1+8+1+4+1+4+1+16+1+1];
			
			szCLSID[0] = 0;
			pszDLL = new CHAR[_MAX_PATH];
			pszDLL[0] = 0;

		    if (VirtualQuery((void*)pFrame[0], &mbi, sizeof(mbi)) == sizeof(mbi))
		    	{
				if (!__bWinNT ||
					(mbi.AllocationProtect & (PAGE_EXECUTE | PAGE_EXECUTE_READ | PAGE_EXECUTE_READWRITE | PAGE_EXECUTE_WRITECOPY)) != 0)
					{
		            GetModuleFileNameA((HINSTANCE)mbi.AllocationBase,pszDLL,_MAX_PATH);
					if (pszDLL[0])
						{
						LPCSTR	pc = strrchr(pszDLL,'\\');
						if (pc)
							strcpy(pszDLL,pc+1);
						pc = strrchr(pszDLL,'/'); // take care for '/' as path separator too!
						if (pc)
							strcpy(pszDLL,pc+1);
						}
					}
				}
			
			CHAR*	pszKey = NULL;

			switch (pFunction->_nFunction)
				{
				case FCT_WINEXEC:
					/*
					UINT WinExec(
					    LPCSTR lpCmdLine,	// address of command line 
					    UINT uCmdShow 	// window style for new application 
					   );	
					*/
					if (pFunction->_nCharset == CS_UNI)
						CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCWSTR)ARG(1),TRUE));
					  else
						CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCSTR)ARG(1),TRUE));
		   			if (!CALLORGFLAG) 
						{
						// deny access
						SETRES(ERROR_FILE_NOT_FOUND);
						}
					break;
				case FCT_CREATEPROCESSASUSER:
					/*
					BOOL CreateProcessAsUser(
					    HANDLE hToken,	// handle to a token that represents a logged-on user
					    LPCTSTR lpApplicationName,	// pointer to name of executable module 
					    LPTSTR lpCommandLine,	// pointer to command line string
					    LPSECURITY_ATTRIBUTES lpProcessAttributes,	// pointer to process security attributes 
					    LPSECURITY_ATTRIBUTES lpThreadAttributes,	// pointer to thread security attributes 
					    BOOL bInheritHandles,	// new process inherits handles 
					    DWORD dwCreationFlags,	// creation flags 
					    LPVOID lpEnvironment,	// pointer to new environment block 
					    LPCTSTR lpCurrentDirectory,	// pointer to current directory name 
					    LPSTARTUPINFO lpStartupInfo,	// pointer to STARTUPINFO 
					    LPPROCESS_INFORMATION lpProcessInformation 	// pointer to PROCESS_INFORMATION  
					   	);
					*/
					if (ARG(2))
						{
						if (pFunction->_nCharset == CS_UNI)
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCWSTR)ARG(2)));
						  else	
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCSTR)ARG(2)));
						}
					  else
						{
						if (pFunction->_nCharset == CS_UNI)
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCWSTR)ARG(3),TRUE));
						  else	
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCSTR)ARG(3),TRUE));
						}	
					if (!CALLORGFLAG)
						{
						// somewhat inconsistent :)
						SetLastError(ERROR_ACCESS_DENIED);
						SETRES(0);
						}
					break;
				case FCT_CREATEPROCESS:
					/*
					BOOL CreateProcess(
					    LPCTSTR lpApplicationName,	// pointer to name of executable module 
					    LPTSTR lpCommandLine,	// pointer to command line string
					    LPSECURITY_ATTRIBUTES lpProcessAttributes,	// pointer to process security attributes 
					    LPSECURITY_ATTRIBUTES lpThreadAttributes,	// pointer to thread security attributes 
					    BOOL bInheritHandles,	// handle inheritance flag 
					    DWORD dwCreationFlags,	// creation flags 
					    LPVOID lpEnvironment,	// pointer to new environment block 
					    LPCTSTR lpCurrentDirectory,	// pointer to current directory name 
					    LPSTARTUPINFO lpStartupInfo,	// pointer to STARTUPINFO 
					    LPPROCESS_INFORMATION lpProcessInformation 	// pointer to PROCESS_INFORMATION  
					   );
					*/
					if (ARG(1))
						{
						if (pFunction->_nCharset == CS_UNI)
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCWSTR)ARG(1)));
						  else	
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCSTR)ARG(1)));
						}
					  else
						{
						if (pFunction->_nCharset == CS_UNI)
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCWSTR)ARG(2),TRUE));
						  else	
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCSTR)ARG(2),TRUE));
						}	
					if (!CALLORGFLAG)
						{
						SetLastError(ERROR_ACCESS_DENIED);
						SETRES(0);
						}
					break;
				case FCT_SHELLEXECUTE:
					/*
					HINSTANCE ShellExecute(
					    HWND hwnd,				// handle to parent window
					    LPCTSTR lpOperation,	// pointer to string that specifies operation to perform
					    LPCTSTR lpFile,			// pointer to filename or folder name string
					    LPCTSTR lpParameters,	// pointer to string that specifies executable-file parameters 
					    LPCTSTR lpDirectory,	// pointer to string that specifies default directory
					    INT nShowCmd 			// whether file is shown when opened
					   );
					*/
					if (pFunction->_nCharset == CS_UNI)
						CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCWSTR)ARG(3)));
					  else
						CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCSTR)ARG(3)));
		   			if (!CALLORGFLAG) 
						{
						SetLastError(ERROR_ACCESS_DENIED);
						SETRES(SE_ERR_ACCESSDENIED);
						}
					break;
				case FCT_SHELLEXECUTEEX:
					/*
					WINSHELLAPI BOOL WINAPI ShellExecuteEx(
					    LPSHELLEXECUTEINFO lpExecInfo	// pointer to SHELLEXECUTEINFO structure
					   );
					   
					typedef struct {   
					    DWORD     cbSize; 
					    ULONG     fMask; 
					    HWND      hwnd; 
					    LPCSTR    lpVerb; 
					    LPCSTR    lpFile; 
					    LPCSTR    lpParameters; 
					    LPCSTR    lpDirectory; 
					    int       nShow; 
					    HINSTANCE hInstApp; 
					    // Optional members 
					    LPVOID lpIDList; 
					    LPCSTR lpClass; 
					    HKEY   hkeyClass; 
					    DWORD  dwHotKey; 
					    HANDLE hIcon; 
					    HANDLE hProcess; 
					} SHELLEXECUTEINFO, FAR *LPSHELLEXECUTEINFO;			   
					*/
					{
					SHELLEXECUTEINFO* pSEI = (SHELLEXECUTEINFO*)ARG(1);
					
					if (pSEI->fMask & SEE_MASK_CLASSNAME)
						{
						if (pFunction->_nCharset == CS_UNI)
							CALLORGFLAG = AskManager(VC_EVENT_CREATEOBJECT,pszDLL,clsCharsetConversionString((LPCWSTR)pSEI->lpClass));
						  else	
							CALLORGFLAG = AskManager(VC_EVENT_CREATEOBJECT,pszDLL,clsCharsetConversionString((LPCSTR)pSEI->lpClass));
						}		
				  	  else
					  	{
						if (pFunction->_nCharset == CS_UNI)
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCWSTR)pSEI->lpFile));
						  else	
							CALLORGFLAG = AskManager(VC_EVENT_EXECUTE,pszDLL,clsFilename((LPCSTR)pSEI->lpFile));
						}		
					if (!CALLORGFLAG)
						{
						pSEI->hInstApp = (HINSTANCE)SE_ERR_ACCESSDENIED;
						SetLastError(ERROR_ACCESS_DENIED);
						SETRES(0);
						}
					}	
					break;
				case FCT_CREATEFILE:
					/*
					HANDLE CreateFile(
					    LPCTSTR lpFileName,				// pointer to name of the file 
					    DWORD dwDesiredAccess,			// access (read-write) mode 
					    DWORD dwShareMode,				// share mode 
					    LPSECURITY_ATTRIBUTES lpSecurityAttributes,	// pointer to security attributes 
					    DWORD dwCreationDistribution,	// how to create 
					    DWORD dwFlagsAndAttributes,		// file attributes 
					    HANDLE hTemplateFile 			// handle to file with attributes to copy  
					   );
					*/
					if (pFunction->_nCharset == CS_UNI)
						CALLORGFLAG = AskManager(VC_EVENT_FILE|
							((DWORD)ARG(2) & GENERIC_WRITE ? VC_EVENTTYPE_WRITE : VC_EVENTTYPE_READ),
							pszDLL,clsFilename((LPCWSTR)ARG(1)));
					  else
						CALLORGFLAG = AskManager(VC_EVENT_FILE|
							((DWORD)ARG(2) & GENERIC_WRITE ? VC_EVENTTYPE_WRITE : VC_EVENTTYPE_READ),
							pszDLL,clsFilename((LPCSTR)ARG(1)));

					if (!CALLORGFLAG)
						{
						SetLastError(ERROR_ACCESS_DENIED);
						SETRES(INVALID_HANDLE_VALUE);
						}
					break;
				case FCT_COPYFILE:
				case FCT_COPYFILEEX:
				case FCT_MOVEFILE:
				case FCT_MOVEFILEEX:
					/*
					BOOL CopyFile(
					    LPCTSTR lpExistingFileName,	// pointer to name of an existing file 
					    LPCTSTR lpNewFileName,	// pointer to filename to copy to 
					    BOOL bFailIfExists 	// flag for operation if file exists 
					   );
					BOOL CopyFileEx(
					    LPCWSTR lpExistingFileName,	// pointer to name of an existing file
					    LPCWSTR lpNewFileName,	// pointer to filename to copy to
					    LPPROGRESS_ROUTINE lpProgressRoutine,	// pointer to the callback function
					    LPVOID lpData,	// to be passed to the callback function
					    LPBOOL pbCancel,	// flag that can be used to cancel the operation
					    DWORD dwCopyFlags	// flags that specify how the file is copied
					   );	
					BOOL MoveFile(
					    LPCTSTR lpExistingFileName,	// address of name of the existing file  
					    LPCTSTR lpNewFileName 	// address of new name for the file 
					   );
					BOOL MoveFileEx(
					    LPCTSTR lpExistingFileName,	// address of name of the existing file  
					    LPCTSTR lpNewFileName,	// address of new name for the file 
					    DWORD dwFlags 	// flag to determine how to move file 
					   );
   					*/
					
					// here, divide this job into two separate rights: 
					// creation rights for the destination, and open rights for the source!
					// (for MoveFile(), even the deletion rights need to be checked!)
					if (pFunction->_nCharset == CS_UNI)
						CALLORGFLAG = AskManager(VC_EVENT_FILE|VC_EVENTTYPE_WRITE,
							pszDLL,clsFilename((LPCWSTR)ARG(2)));
					  else
						CALLORGFLAG = AskManager(VC_EVENT_FILE|VC_EVENTTYPE_WRITE,
							pszDLL,clsFilename((LPCSTR)ARG(2)));
					if (!CALLORGFLAG)
						{
						SetLastError(ERROR_ACCESS_DENIED);
						SETRES(0);
						}
					  else
					  	{	
						if (pFunction->_nCharset == CS_UNI)
							CALLORGFLAG = AskManager(VC_EVENT_FILE|VC_EVENTTYPE_READ,
								pszDLL,clsFilename((LPCWSTR)ARG(1)));
						  else
							CALLORGFLAG = AskManager(VC_EVENT_FILE|VC_EVENTTYPE_READ,
								pszDLL,clsFilename((LPCSTR)ARG(1)));
						if (!CALLORGFLAG)
							{
							SetLastError(ERROR_ACCESS_DENIED);
							SETRES(0);
							}
						  else
						  	{
							switch (pFunction->_nFunction)
								{
								case FCT_MOVEFILE:
								case FCT_MOVEFILEEX:
									if (pFunction->_nCharset == CS_UNI)
										CALLORGFLAG = AskManager(VC_EVENT_FILE|VC_EVENTTYPE_DELETE,
											pszDLL,clsFilename((LPCWSTR)ARG(1)));
									  else
										CALLORGFLAG = AskManager(VC_EVENT_FILE|VC_EVENTTYPE_DELETE,
											pszDLL,clsFilename((LPCSTR)ARG(1)));
									if (!CALLORGFLAG)
										{
										SetLastError(ERROR_ACCESS_DENIED);
										SETRES(0);
										}
									break;
								}
							}	
						}	
					break;
				case FCT_DELETEFILE:
					if (pFunction->_nCharset == CS_UNI)
						CALLORGFLAG = AskManager(VC_EVENT_FILE|VC_EVENTTYPE_DELETE,
							pszDLL,clsFilename((LPCWSTR)ARG(1)));
					  else
						CALLORGFLAG = AskManager(VC_EVENT_FILE|VC_EVENTTYPE_DELETE,
							pszDLL,clsFilename((LPCSTR)ARG(1)));
					if (!CALLORGFLAG)
						{
						SetLastError(ERROR_ACCESS_DENIED);
						SETRES(0);
						}
					break;
				case FCT_SHELLLOADINPROC:
					/*
					WINSHELLAPI HRESULT WINAPI SHLoadInProc(
					    REFCLSID rclsid	
					   );					
					*/
					CALLORGFLAG = AskManager(VC_EVENT_CREATEOBJECT,pszDLL,CLSIDString((CLSID*)ARG(1),szCLSID));
					if (CALLORGFLAG)
						{
						hRes = CallOrgAPI(pFunction,pFrame);
						if (SUCCEEDED(hRes))	
							InterceptFunctionsInTask(TRUE);
						SETRES(hRes);
						// don't call original function, this has already been done!
						CALLORGFLAG = FALSE;
						}
					  else	
						SETRES(REGDB_E_CLASSNOTREG);
					break;
				case FCT_COCREATEINSTANCE:
				case FCT_COCREATEINSTANCEEX:
					/*
					STDAPI CoCreateInstance(
					    REFCLSID rclsid,	//Class identifier (CLSID) of the object
					    LPUNKNOWN pUnkOuter,	//Pointer to whether object is or isnt part of an aggregate 
					    DWORD dwClsContext,	//Context for running executable code
					    REFIID riid,	//Reference to the identifier of the interface
					    LPVOID * ppv	//Indirect pointer to requested interface
					   );
					HRESULT CoCreateInstanceEx(
					    REFCLSID  rclsid,	//CLSID of the object to be created
					    IUnknown *  punkOuter,	//If part of an aggregate, the controlling IUnknown
					    DWORD  dwClsCtx,	//CLSCTX values
					    COSERVERINFO* pServerInfo, 	//Machine on which the object is to be instantiated
					    ULONG  cmq,	//Number of MULTI_QI structures in rgmqResults
					    MULTI_QI  rgmqResults	//Array of MULTI_QI structures
					   );			
					*/
					CALLORGFLAG = AskManager(VC_EVENT_CREATEOBJECT,pszDLL,CLSIDString((CLSID*)ARG(1),szCLSID));
					if (CALLORGFLAG)
						{
						hRes = CallOrgAPI(pFunction,pFrame);
						if (SUCCEEDED(hRes))	
							InterceptFunctionsInTask(TRUE);
						SETRES(hRes);
						// don't call original function, this has already been done!
						CALLORGFLAG = FALSE;
						}
					  else	
						SETRES(REGDB_E_CLASSNOTREG);
					break;
				case FCT_COGETCLASSOBJECT:
					/*
					STDAPI CoGetClassObject(
					    REFCLSID rclsid,	//CLSID associated with the class object
					    DWORD dwClsContext,	//Context for running executable code
					    COSERVERINFO * pServerInfo,	//Pointer to machine on which the object is to be instantiated
					    REFIID riid,	//Reference to the identifier of the interface
					    LPVOID * ppv	//Indirect pointer to the interface
					   );
					*/
					CALLORGFLAG = AskManager(VC_EVENT_CREATEOBJECT,pszDLL,CLSIDString((CLSID*)ARG(1),szCLSID));
					if (CALLORGFLAG)
						{
						hRes = CallOrgAPI(pFunction,pFrame);
						if (SUCCEEDED(hRes))	
							InterceptFunctionsInTask(TRUE);
						SETRES(hRes);
						// don't call original function, this has already been done!
						CALLORGFLAG = FALSE;
						}
					  else	
						SETRES(REGDB_E_CLASSNOTREG);
					break;
				case FCT_COGETINSTANCEFROMFILE:
					/*
					HRESULT CoGetInstanceFromFile(
					    COSERVERINFO *  pServerInfo, 	//Pointer to COSERVERINFO struct indicating remote system
					    CLSID*  pclsid,	//Pointer to the class of the object to create
					    IUnknown * punkOuter,	//If part of an aggregate, pointer to the controlling IUnknown
					    DWORD dwClsCtx, 	//CLSCTX values
					    OLECHAR* szName,	//File to initialize the object with
					    ULONG  cmq,	//Number of MULTI_QI structures in rgmqResults
					    MULTI_QI * rgmqResults	//Array of MULTI_QI structures
					   );
					*/
					CALLORGFLAG = AskManager(VC_EVENT_CREATEOBJECT,pszDLL,CLSIDString((CLSID*)ARG(2),szCLSID));
					if (CALLORGFLAG)
						{
						hRes = CallOrgAPI(pFunction,pFrame);
						if (SUCCEEDED(hRes))	
							InterceptFunctionsInTask(TRUE);
						SETRES(hRes);
						// don't call original function, this has already been done!
						CALLORGFLAG = FALSE;
						}
					  else	
						SETRES(REGDB_E_CLASSNOTREG);
					break;
				case FCT_COGETINSTANCEFROMISTORAGE:
					/*
					HRESULT CoGetInstanceFromIStorage(
					    COSERVERINFO *  pServerInfo,	//Pointer to COSERVERINFO struct indicating remote system
					    CLSID *  pclsid,	//Pointer to the CLSID of the object to be created
					    IUnknown * punkOuter,	//If part of an aggregate, pointer to the controlling IUnknown
					    DWORD  dwClsCtx,	//Values taken from the CLSCTX enumeration
					    IStorage * pstg,	//Pointer to storage from which object is to be initialized
					    ULONG  cmq,	//Number of MULTI_QI structures in rgmqResults
					    MULTI_QI * rgmqResults	//Array of MULTI_QI structures
					   );	
					*/
					CALLORGFLAG = AskManager(VC_EVENT_CREATEOBJECT,pszDLL,CLSIDString((CLSID*)ARG(2),szCLSID));
					if (CALLORGFLAG)
						{
						hRes = CallOrgAPI(pFunction,pFrame);
						if (SUCCEEDED(hRes))	
							InterceptFunctionsInTask(TRUE);
						SETRES(hRes);
						// don't call original function, this has already been done!
						CALLORGFLAG = FALSE;
						}
					  else	
						SETRES(REGDB_E_CLASSNOTREG);
					break;
				case FCT_OLECREATE:
					/*
					WINOLEAPI OleCreate(
					  REFCLSID rclsid,  //CLSID of embedded object to be created
					  REFIID riid,      //Reference to the identifier of the interface 
					                    // used to communicate with new object
					  DWORD renderopt,  //RENDEROPT value indicating cached capabilities
					  FORMATETC * pFormatEtc,
					                    //Pointer to a FORMATETC structure
					  IOleClientSite * pClientSite,
					                    //Pointer to request services from the container
					  IStorage * pStg,  //Pointer to storage for the object
					  void ** ppvObject //Address of output variable that receives the 
					                    // interface pointer requested in riid
					);
					HRESULT OleCreateEx(
					  REFCLSID rclsid,        //Class of object to create
					  REFIID riid,            //Reference to the identifier of the 
					                          // interface of object to return
					  DWORD dwFlags,          //Value from OLECREATE 
					                          // enumeration
					  DWORD renderopt,        //Value from OLERENDER 
					                          // enumeration
					  ULONG cFormats,         //Number of FORMATETC 
					                          // structures in rgFormatEtc
					  DWORD rgAdvf,           //Points to an array of cFormats DWORD 
					                          // elements
					  LPFORMATETC rgFormatEtc,  //Points to an array of cFormats 
					                            // FORMATETC structures; NULL otherwise
					  LPADVISESINK pAdviseSink,  //IAdviseSink pointer 
					                             // (custom caching); NULL (default 
					                             // caching); NULL otherwise
					  DWORD* rgdwConnection,  //Location to return array of dwConnection 
					                          // values
					  LPOLECLIENTSITE pClientSite,
					                          //Pointer to the primary interface the 
					                          // object will use to request services
					  LPSTORAGE pStg,         //Pointer to storage to use for object
					  LPVOID FAR* ppvObj      //Address of output variable that receives 
					                          // the interface pointer requested in riid
					);
		 			*/
					CALLORGFLAG = AskManager(VC_EVENT_CREATEOBJECT,pszDLL,CLSIDString((CLSID*)ARG(1),szCLSID));
					if (CALLORGFLAG)
						{
						hRes = CallOrgAPI(pFunction,pFrame);
						if (SUCCEEDED(hRes))	
							InterceptFunctionsInTask(TRUE);
						SETRES(hRes);
						// don't call original function, this has already been done!
						CALLORGFLAG = FALSE;
						}
					  else	
						SETRES(REGDB_E_CLASSNOTREG);
					break;
				case FCT_OLECREATEFROMFILE:
					/*
					WINOLEAPI OleCreateFromFile(
					    REFCLSID rclsid,	//Reserved. Must be CLSID_NULL
					    LPCOLESTR lpszFileName,	//Pointer to full path of file used to create object
					    REFIID riid,	//Reference to the identifier of the interface to be used to communicate with new object
					    DWORD renderopt,	//Value from OLERENDER
					    LPFORMATETC pFormatEtc,	//Pointer to the FORMATETC structure
					    LPOLECLIENTSITE pClientSite,	//Pointer to an interface
					    LPSTORAGE pStg,	//Pointer tothe interface to be used as object storage
					    LPVOID FAR* ppvObj	//Indirect pointer to the interface requested in riid
					   );	
					HRESULT OleCreateFromFileEx(
					    REFCLSID rclsid,	//Reserved; must be CLSID_NULL
					    LPCOLESTR lpszFileName,	//Pointer to name of file to initialize new object from
					    REFIID riid,	//Reference to the identifier of the interface of object to return
					    DWORD dwFlags,	//Value from OLECREATE enumeration
					    DWORD renderopt,	//Value from OLERENDER enumeration
					    ULONG cFormats,	//Number of FORMATETC structures in the rgFormatEtc array
					    DWORD rgAdvf,	//Points to an array of cFormats DWORD elements
					    LPFORMATETC rgFormatEtc,	//Points to an array of cFormats FORMATETC structures 
					    LPADVISESINK pAdviseSink,	//IAdviseSink pointer (custom caching), or NULL (default caching)
					    DWORD FAR* rgdwConnection,	//Location to return the array of dwConnection values
					    LPCLIENTSITE pClientSite,	//Pointer to primary interface the object will use to request services
					    LPSTORAGE pStg,	//Pointer to storage to use for object
					    LPVOID FAR* ppvObj	//Indirect pointer to location to return riid interface
					    );	
					*/
					CALLORGFLAG = AskManager(VC_EVENT_CREATEOBJECT,pszDLL,clsFilename((LPCWSTR)ARG(2)));
					if (CALLORGFLAG)
						{
						hRes = CallOrgAPI(pFunction,pFrame);
						if (SUCCEEDED(hRes))	
							InterceptFunctionsInTask(TRUE);
						SETRES(hRes);
						// don't call original function, this has already been done!
						CALLORGFLAG = FALSE;
						}
					  else	
						SETRES(REGDB_E_CLASSNOTREG);
					break;
				case FCT_REGCREATEKEY:
					/*
					LONG RegCreateKey(
					    HKEY hKey,	// handle of an open key 
					    LPCTSTR lpSubKey,	// address of name of subkey to open 
					    PHKEY phkResult 	// address of buffer for opened handle 
					   );	
					*/
					{
					if (pFunction->_nCharset == CS_UNI)
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),clsCharsetConversionString((LPCWSTR)ARG(2)),NULL);
					  else
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),(LPCSTR)ARG(2),NULL);

					CALLORGFLAG = AskManager(VC_EVENT_REGKEY|VC_EVENTTYPE_WRITE,pszDLL,pszKey);
					if (CALLORGFLAG)
						{
						lRes = CallOrgAPI(pFunction,pFrame);
						if (lRes == ERROR_SUCCESS) // sigh...
							__RegKeyPathList.SetRegHKEY(*(PHKEY)ARG(3),pszKey);
						CALLORGFLAG = FALSE;
						SETRES(lRes);
						}
					  else	
						SETRES(ERROR_ACCESS_DENIED);
					}
					break;
				case FCT_REGCREATEKEYEX:
					/*
					LONG RegCreateKeyEx(
					    HKEY hKey,	// handle of an open key 
					    LPCTSTR lpSubKey,	// address of subkey name 
					    DWORD Reserved,	// reserved 
					    LPTSTR lpClass,	// address of class string 
					    DWORD dwOptions,	// special options flag 
					    REGSAM samDesired,	// desired security access 
					    LPSECURITY_ATTRIBUTES lpSecurityAttributes,	// address of key security structure 
					    PHKEY phkResult,	// address of buffer for opened handle  
					    LPDWORD lpdwDisposition 	// address of disposition value buffer 
					   );
					*/
					{
					if (pFunction->_nCharset == CS_UNI)
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),clsCharsetConversionString((LPCWSTR)ARG(2)),NULL);
					  else
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),(LPCSTR)ARG(2),NULL);

					CALLORGFLAG = AskManager(VC_EVENT_REGKEY|VC_EVENTTYPE_WRITE,pszDLL,pszKey);
					if (CALLORGFLAG)
						{
						lRes = CallOrgAPI(pFunction,pFrame);
						if (lRes == ERROR_SUCCESS) // sigh...
							__RegKeyPathList.SetRegHKEY(*(PHKEY)ARG(8),pszKey);
						CALLORGFLAG = FALSE;
						SETRES(lRes);
						}
					  else	
						SETRES(ERROR_ACCESS_DENIED);
					}
					break;
				case FCT_REGOPENKEY:
					/*
					LONG RegOpenKey(
					    HKEY hKey,	// handle of open key 
					    LPCTSTR lpSubKey,	// address of name of subkey to open 
					    PHKEY phkResult 	// address of handle of open key 
					   );
					*/
					if (ARG(2) == NULL)
						{
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,NULL);
						lRes = CallOrgAPI(pFunction,pFrame);
						if (lRes == ERROR_SUCCESS) 
							__RegKeyPathList.SetRegHKEY(*(PHKEY)ARG(3),pszKey);
						CALLORGFLAG = FALSE;
						SETRES(lRes);
						}
					  else
					  	{	
						if (pFunction->_nCharset == CS_UNI)
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),clsCharsetConversionString((LPCWSTR)ARG(2)),NULL);
						  else
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),(LPCSTR)ARG(2),NULL);

						CALLORGFLAG = AskManager(VC_EVENT_REGKEY|VC_EVENTTYPE_WRITE,pszDLL,pszKey); // WRITE assumed...
						if (CALLORGFLAG)
							{
							lRes = CallOrgAPI(pFunction,pFrame);
							if (lRes == ERROR_SUCCESS) 
								__RegKeyPathList.SetRegHKEY(*(PHKEY)ARG(3),pszKey);
							CALLORGFLAG = FALSE;
							SETRES(lRes);
							}
						  else	
							SETRES(ERROR_ACCESS_DENIED);
						}
					break;
				case FCT_REGOPENKEYEX:
					/*
					LONG RegOpenKeyEx(
					    HKEY hKey,			// handle of open key 
					    LPCTSTR lpSubKey,	// address of name of subkey to open 
					    DWORD ulOptions,	// reserved 
					    REGSAM samDesired,	// security access mask 
					    PHKEY phkResult 	// address of handle of open key 
					   );					
					*/
					if (ARG(2) == NULL)
						{
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,NULL);
						lRes = CallOrgAPI(pFunction,pFrame);
						if (lRes == ERROR_SUCCESS) 
							__RegKeyPathList.SetRegHKEY(*(PHKEY)ARG(5),pszKey);
						CALLORGFLAG = FALSE;
						SETRES(lRes);
						}
					  else
					  	{	
						if (pFunction->_nCharset == CS_UNI)
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),clsCharsetConversionString((LPCWSTR)ARG(2)),NULL);
						  else
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),(LPCSTR)ARG(2),NULL);

						CALLORGFLAG = AskManager(VC_EVENT_REGKEY|((ARG(4) & (KEY_WRITE)) ? VC_EVENTTYPE_WRITE : VC_EVENTTYPE_READ),pszDLL,pszKey); 
						if (CALLORGFLAG)
							{
							lRes = CallOrgAPI(pFunction,pFrame);
							if (lRes == ERROR_SUCCESS)
								__RegKeyPathList.SetRegHKEY(*(PHKEY)(ARG(5)),pszKey);
							CALLORGFLAG = FALSE;
							SETRES(lRes);
							}
						  else	
							SETRES(ERROR_ACCESS_DENIED);
						}
					break;
				case FCT_REGCLOSEKEY:
					/*
					LONG RegCloseKey(
					    HKEY hKey 	// handle of key to close  
					   );	
					*/
					__RegKeyPathList.CloseRegHKEY((HKEY)ARG(1));
					break;
				case FCT_REGDELETEKEY:
						/*
						LONG RegDeleteValue(
						    HKEY hKey,	// handle of key 
						    LPCTSTR lpValueName 	// address of value name 
						   );						
						*/
					if (ARG(2) == NULL)
						{
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,NULL);
						}
					  else
					  	{
						if (pFunction->_nCharset == CS_UNI)
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),clsCharsetConversionString((LPCWSTR)ARG(2)),NULL);
						  else
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),(LPCSTR)ARG(2),NULL);
						}	
					CALLORGFLAG = AskManager(VC_EVENT_REGVALUE|VC_EVENTTYPE_DELETE,pszDLL,pszKey);
					if (CALLORGFLAG)
						{
						lRes = CallOrgAPI(pFunction,pFrame);
						CALLORGFLAG = FALSE;
						SETRES(lRes);
						}
					  else	
						SETRES(ERROR_ACCESS_DENIED);
					break;
	 			case FCT_REGSETVALUE:
					/*
					LONG RegSetValue(
					    HKEY hKey,	// handle of key to set value for 
					    LPCTSTR lpSubKey,	// address of subkey name 
					    DWORD dwType,	// type of value 
					    LPCTSTR lpData,	// address of value data 
					    DWORD cbData 	// size of value data 
					   );
   					*/
					if (ARG(2) == NULL)
						{
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,NULL);
						}
					  else
					  	{
						if (pFunction->_nCharset == CS_UNI)
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,clsCharsetConversionString((LPCWSTR)ARG(2)));
						  else
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,(LPCSTR)ARG(2));
						}	

					CALLORGFLAG = AskManager(VC_EVENT_REGVALUE|VC_EVENTTYPE_WRITE,pszDLL,pszKey);
					if (CALLORGFLAG)
						{
						lRes = CallOrgAPI(pFunction,pFrame);
						CALLORGFLAG = FALSE;
						SETRES(lRes);
						}
					  else	
						SETRES(ERROR_ACCESS_DENIED);
					break;
	 			case FCT_REGSETVALUEEX:
					/*
					LONG RegSetValueEx(
					    HKEY hKey,	// handle of key to set value for  
					    LPCTSTR lpValueName,	// address of value to set 
					    DWORD Reserved,	// reserved 
					    DWORD dwType,	// flag for value type 
					    CONST BYTE *lpData,	// address of value data 
					    DWORD cbData 	// size of value data 
					   );
					*/
					if (ARG(2) == NULL)
						{
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,NULL);
						}
					  else
					  	{
						if (pFunction->_nCharset == CS_UNI)
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,clsCharsetConversionString((LPCWSTR)ARG(2)));
						  else
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,(LPCSTR)ARG(2));
						}	

					CALLORGFLAG = AskManager(VC_EVENT_REGVALUE|VC_EVENTTYPE_WRITE,pszDLL,pszKey);
					if (CALLORGFLAG)
						{
						lRes = CallOrgAPI(pFunction,pFrame);
						CALLORGFLAG = FALSE;
						SETRES(lRes);
						}
					  else	
						SETRES(ERROR_ACCESS_DENIED);
					break;
				case FCT_REGQUERYVALUE:
					/*
					LONG RegQueryValue(
					    HKEY hKey,	// handle of key to query 
					    LPCTSTR lpSubKey,	// address of name of subkey to query 
					    LPTSTR lpValue,	// address of buffer for returned string 
					    PLONG lpcbValue 	// address of buffer for size of returned string 
					   );
   					*/
					if (ARG(2) == NULL)
						{
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,NULL);
						}
					  else
					  	{
						if (pFunction->_nCharset == CS_UNI)
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,clsCharsetConversionString((LPCWSTR)ARG(2)));
						  else
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,(LPCSTR)ARG(2));
						}	

					CALLORGFLAG = AskManager(VC_EVENT_REGVALUE|VC_EVENTTYPE_READ,pszDLL,pszKey);
					if (CALLORGFLAG)
						{
						lRes = CallOrgAPI(pFunction,pFrame);
						CALLORGFLAG = FALSE;
						SETRES(lRes);
						}
					  else	
						SETRES(ERROR_ACCESS_DENIED);
					break;
				case FCT_REGQUERYVALUEEX:
					/*
					LONG RegQueryValueEx(
					    HKEY hKey,	// handle of key to query 
					    LPTSTR lpValueName,	// address of name of value to query 
					    LPDWORD lpReserved,	// reserved 
					    LPDWORD lpType,	// address of buffer for value type 
					    LPBYTE lpData,	// address of data buffer 
					    LPDWORD lpcbData 	// address of data buffer size 
					   );	
   					*/
					if (ARG(2) == NULL)
						{
						pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,NULL);
						}
					  else
					  	{
						if (pFunction->_nCharset == CS_UNI)
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,clsCharsetConversionString((LPCWSTR)ARG(2)));
						  else
							pszKey = __RegKeyPathList.GetRegHKEY((HKEY)ARG(1),NULL,(LPCSTR)ARG(2));
						}	

					CALLORGFLAG = AskManager(VC_EVENT_REGVALUE|VC_EVENTTYPE_READ,pszDLL,pszKey);
					if (CALLORGFLAG)
						{
						lRes = CallOrgAPI(pFunction,pFrame);
						// lRes = ((STDREGFCT6)pFunction->_pfnOrgAddress)(ARG(1),ARG(2),ARG(3),ARG(4),ARG(5),ARG(6));
						CALLORGFLAG = FALSE;
						SETRES(lRes);
						}
					  else	
						SETRES(ERROR_ACCESS_DENIED);
					break;
				}
			delete[] pszDLL;	
			delete[] pszKey;	
			}	
			break;
		}

	return;
}

