// genericDlg.cpp : implementation file
//

#include "stdafx.h"
#include "generic.h"
#include "genericDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGenericDlg dialog

CGenericDlg::CGenericDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGenericDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGenericDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CGenericDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGenericDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGenericDlg, CDialog)
	//{{AFX_MSG_MAP(CGenericDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON, OnButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGenericDlg message handlers

BOOL CGenericDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CGenericDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGenericDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGenericDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


#ifdef _MBCS
//*********************************************************************
// pstrterm()
//
// Terminieren eines Strings (Multibyte-Version)
//
// IN:  str  - Zeiger auf String
//      nstr - max. Gre von str (inkl. Nullbyte)
// OUT: Zeiger auf String
//
// C: UPh        (C) PASS Engineering GmbH 1994 
//*********************************************************************
LPTSTR pstrterm(LPTSTR str, int nstr)
{
    if (nstr <= 0)
        return str;
    
    LPTSTR p;
    for (p = str; *p != '\0' && nstr > 1; p++, nstr--)
    {
        // Vorletztes Zeichen im String und LeadByte, dann schon 
        // bei LeadByte abschneiden
        if (_istlead(*p) && nstr == 2)
            break;
    }
    *p = 0;
        
    return str;
}
#else
LPTSTR pstrterm(LPTSTR str, int nstr)
{ 
    if (nstr > 0) 
        str[nstr-1] = 0; 
    
    return str;
}
#endif

//*********************************************************************
// _FSMakeSepFmt()
//
// Erzeuge einen Formatstring mit Separatoren ("%s%d" -> "@%s@d")
//
// IN:  fmtx  - neuer Formatstring
//      nfmtx - max Lnge von fmtx
//      fmt   - alter Formatstring
// OUT: Separator
//
// C: UPh      (C) PASS Engineering GmbH 1994 
//*********************************************************************
static TCHAR _FSMakeSepFmt(LPTSTR fmtx, int nfmtx, LPCTSTR fmt)
{
    TCHAR sep = (char) 1;
    LPTSTR px = fmtx;
    LPCTSTR p  = fmt;

    while(*p != (char) 0 && px - fmtx < nfmtx - 2)
    {
        // Vor dem Formatspecifier einen Separator eintragen
        if (*p == _T('%'))
            *px++ = sep;

        *px++ = *p++;
    }

    // Am Ende noch ein Separator und das Nullbyte
    *px++ = sep;
    *px++ = 0;

    return sep;
}

//*********************************************************************
// void _FSInsertParam()
//
// Schreibe einen Parameter aus der Liste in den buffer
//
// IN:  buf  - zu beschreibender Buffer
//      nbuf - Gre von buf (Zeichen)
//      inx  - Index des Parameters
//      par  - Liste der Parameter (String mit Separatoren)
//      sep  - Separatorzeichen
// OUT: -
//
// C: UPh      (C) PASS Engineering 1994 
//*********************************************************************
static void 
_FSInsertPara(LPTSTR buf, int nbuf, int inx, LPCTSTR par, TCHAR sep)
{
    while(*par != (TCHAR) 0 && nbuf > 1)
    {
        if (*par == sep)
        {
            // inx +1 ter Separator => Parameter steht jetzt in buf
            if (inx <= 0)
                break;

            // Index runterzhlen
            inx --;
        }
        else if (inx <= 0) 
        {
            // Kopieren, wenn inxten Separator berlesen
            *buf++ = *par;
            nbuf--;
        }

        par++;
    }

    *buf = (TCHAR) 0;
}

//*********************************************************************
// _vFmtStr()
//
// IN:  buf  - Zielbuffer fr formatierten String
//      nbuf - Maximale Grsse des Zielbuffers
//      str  - Formatstring mit %1, %2 etc.
//      fmt  - Formatspecifiers wie %s%d etc.
//      args - Parameterliste
// OUT: Lnge des formatierten Strings
//
// C: UPh      (C) PASS Engineering 1994 
//*********************************************************************
static int 
_vFmtStr(LPTSTR buf, int nbuf, LPCTSTR str, LPCTSTR fmt, va_list args)
{
    if (nbuf <= 0)
        return 0;

    if (HIWORD(str) == 0) // Falls eine String-ID bergeben wurde
    {
        CString str0;
        str0.LoadString(LOWORD(str));
        str = (LPCTSTR) str0;
    }

    TCHAR par[1024];
    TCHAR fmtx[60];
    TCHAR sep;
    LPCTSTR p = str;
    LPTSTR pb = buf;

    // Formatspecifier trennen
    sep = _FSMakeSepFmt(fmtx, 60, fmt);

    // par enthlt Parameter formatiert wie fmt, getrennt mit sep 
    _vsntprintf(par, 1024, fmtx, args);
    pstrterm(par, 1024);

    while(*p != (TCHAR) 0 && nbuf > 1)
    {
        // '%' gefolgt von '0' bis '9' sind niemals LeadBytes
        if (p[0] == _T('%') && p[1] >= _T('1') && p[1] <= _T('9'))
        {
            // Parameter einfgen
            _FSInsertPara(pb, nbuf, (int) (p[1] - _T('0')), par, sep);

            nbuf -= lstrlen(pb);
            pb   += lstrlen(pb);
            p    += 2;
        }
        else
        {
            // '%' als Escape-Zeichen?
            if (p[0] == _T('%') && p[1] != (TCHAR) 0)
                p++;

            // DoubleByte-Zeichen?
            if (_istlead((BYTE) *p))
            {
                *pb++ = *p++;
                nbuf--;
            }

            *pb++ = *p++;
            nbuf--;
        }
    }

    *pb = (TCHAR) 0;

    return lstrlen(buf);
}

//*********************************************************************
// FmtStr()
//
// Formatiere einen String der "%1", "%2" ... enthlt
//
// IN:  buf  - nimmt das Ergebnis auf
//      nbuf - Gre des Buffers
//      str  - Message String (z.B. "Fehler %1 in Modul %2");
//      fmt  - Formatangabe   (z.B. "%02d%s");
//      ...  - entsprechende Argumente
// OUT: Anzahl der geschriebenen Characters
//
// C: UPh      (C) PASS Engineering 1994 
//*********************************************************************
int FmtStr(LPTSTR buf, int nbuf, LPCTSTR str, LPCTSTR fmt, ...)
{
    va_list args;
    va_start(args, fmt);

    return _vFmtStr(buf, nbuf, str, fmt, args);
}

//*********************************************************************
// FmtStr()
//
// (s.o.) - bergabe einer StringID statt eines Strings
//
// C: UPh      (C) PASS Engineering 1994 
//*********************************************************************
int FmtStr(LPTSTR buf, int nbuf, UINT strid, LPCTSTR fmt, ...)
{
    if (nbuf <= 0)
        return 0;

    va_list args;
    va_start(args, fmt);

    return _vFmtStr(buf, nbuf, MAKEINTRESOURCE(strid), fmt, args);
}

//****************************************************************************
// HandleString3()
//
// Diese Funktion enthlt keine Texte mehr, die bersetzt werden mssen
//
// IN:  text - In text Klammern suchen. Text und # Zeichen dazwischen ausgeben
// OUT:
//
//****************************************************************************
void HandleString3( LPCTSTR text)
{
    LPTSTR start, end;
    TCHAR msg[160], paratext[8];
    CString resstring;
    int  len;

    // Wir suchen nach begrenzenden Klammern
    start = _tcschr(text, _T('('));
    end   = _tcsrchr(text, _T(')'));

    if (start == NULL || end == NULL)
        resstring.LoadString(IDS_TEXT_WITHOUT_PARENTHESES);
    else
        resstring.LoadString(IDS_TEXT_WITH_PARENTHESES);

    AfxMessageBox((LPCTSTR) resstring);

    // Eine oder beide Klammern fehlen
    if (start == NULL || end == NULL || end < start)
        return;

    // Eine oder beide Klammern fehlen oder die Anordnung ist falsch
    len = end - start - 1;

    // sizeof liefert fr UNICODE nicht die Lnge in WCHAR sondern 
    // in char. Besser das Makro DIMOF verwenden
    if (len >= DIMOF(paratext))
    {
        resstring.LoadString(IDS_ERROR);
        AfxMessageBox((LPCTSTR) resstring);
        return;
    }

    // Info anzeigen
    _tcsncpy(paratext, start + 1, len);
    paratext[len] = _T('\0');
    
    // len enthlt # der Bytes/WBytes, nicht Anzahl Zeichen in MBCS
    // _tcsclen liefert fr SBCS/MBCS und Unicode die richtige Anzahl
    FmtStr(msg, DIMOF(msg), 
           IDS_STATUS, _T("%d%s"), 
           _tcsclen(paratext), paratext);
             
    AfxMessageBox(msg);
}


//****************************************************************************
// HandleString2()
//
// Diese Funktion verwendet Funktionen die fr SBCS/DBCS- und Unicode 
// Zeichenstze funktionieren.
//
// IN:  text - In text Klammern suchen. Text und # Zeichen dazwischen ausgeben
// OUT:
//
// C:  10/31/00        LC: , 10/31/00
//****************************************************************************
void HandleString2( LPCTSTR text)
{
    LPTSTR start, end;
    TCHAR message[80], paratext[8];
    int  len;

    // Wir suchen nach begrenzenden Klammern
    start = _tcschr(text, _T('('));
    end   = _tcsrchr(text, _T(')'));

    _stprintf(message, _T("Text enthlt %sKlammern!"), 
            (start == NULL || end == NULL) ? "keine " : "");
    AfxMessageBox(message);

    // Eine oder beide Klammern fehlen
    if (start == NULL || end == NULL || end < start)
        return;

    // Eine oder beide Klammern fehlen oder die Anordnung ist falsch
    len = end - start - 1;

    // sizeof liefert fr UNICODE nicht die Lnge in WCHAR sondern 
    // in char. Besser das Makro DIMOF verwenden
    if (len >= DIMOF(paratext))
    {
        AfxMessageBox(
            _T("Fehler: Text zwischen Klammern ist zu lang!"));
        return;
    }

    // Info anzeigen
    _tcsncpy(paratext, start + 1, len);
    paratext[len] = _T('\0');
    
    // len enthlt # der Bytes/WBytes, nicht Anzahl Zeichen in MBCS
    // _tcsclen liefert fr SBCS/MBCS und Unicode die richtige Anzahl
    _stprintf(message, 
       _T("Text zwischen Klammern ist %d Zeichen lang und lautet\n%s"),
       _tcsclen(paratext), paratext);
             
    AfxMessageBox(message);
}

#if SO_NICHT
//****************************************************************************
// HandleString()
//
// Diese Funktion verwendet C-Standard-Funktionen, die nicht 
// internationalisiert sind
//
// IN:  text - In text Klammern suchen. Text und # Zeichen dazwischen ausgeben
// OUT:
//
// C:  10/31/00        LC: , 10/31/00
//****************************************************************************
void HandleString( LPCSTR text)
{
    LPSTR start, end;
    char message[80], paratext[8];
    int  len;

    // Wir suchen nach begrenzenden Klammern
    start = strchr(text, '(');
    end   = strrchr(text, ')');

    sprintf(message, "Text enthlt %sKlammern!", 
          (start == NULL || end == NULL) ? "keine " : "");
    AfxMessageBox(message);

    // Eine oder beide Klammern fehlen oder die Anordnung ist falsch
    if (start == NULL || end == NULL || end < start)
        return;

    // Wenn Lnge des Textes zwischen Klammern zu lang => Ende
    len = end - start - 1;
    if (len >= sizeof(paratext))
    {
        AfxMessageBox("Fehler: Text in Klammern ist zu lang!");
        return;
    }

    // Info anzeigen
    strncpy(paratext, start + 1, len);
    paratext[len] = '\0';
    
    sprintf(message, 
          "Text zwischen Klammern ist %d Zeichen lang und lautet\n%s",
          len, paratext);
             
    AfxMessageBox(message);
}
#endif

void CGenericDlg::OnButton() 
{
    CString buffer;
    
    GetDlgItemText( IDC_EDIT, buffer);	
    if (buffer.GetLength())
        HandleString2((LPCTSTR) buffer);

}
